package GUI::FruReport;

use Report;
use Reports;
use Reports::Fru;
use System;
use Html::List;
use strict;
use Modules;
use Process;
use AdminGroup;
use Math;

#
# used by the scheduler to re-run the report-set if missing or old.
#
sub RUN {
  my($q) = @_;
  my $F = System->get_home() . "/DATA/tmp/fru_report";
  my $age = Util->getFileAge($F, "h");

  if (!-f $F || $age > 12) {
    my $st = Process->status(undef, "fru_report");
    if ($st =~ /Running/) {
       print "Fru report already running!\n";
    } else {
       Process->start("fru_report");
       Reports::Fru->new(1);
    }
  }
}


sub compare {
  my($q) = @_;
  my $LB = Labels->read('GUI::FruReport');
  my @L;

  foreach my $el (keys %$q) {
     if (substr($el,0,4) eq "sel_") {
       push(@L, substr($el,4));
       last if ($#L == 1);
     }
  }
  my $r1 = Util->deserialize("FruReport_history/$L[0]");
  my $r2 = Util->deserialize("FruReport_history/$L[1]");
  my (%ENC, %ENC2, %FRU, %FRU2);


  my (@array, $changes);
  foreach my $el (@$r1) {
     $ENC{$el->[0]} = $el;
     my $fru = "$el->[0].$el->[1].$el->[2].$el->[3]";
     $FRU{$fru} = $el;
  }
  foreach my $el (@$r2) {
     $ENC2{$el->[0]} = $el;
  }
  foreach my $el (keys %ENC) {
     my $v = $ENC{$el};
     if (!$ENC2{$v->[0]}) {
       push(@array, [$LB->{del}, $v->[0], ""]);
       $changes++;
     }
  }
  foreach my $el (keys %ENC2) {
     my $v = $ENC2{$el};
     if (!$ENC{$v->[0]}) {
       push(@array, [$LB->{add}, $v->[0], ""]);
       $changes++;
     }
  }

  foreach my $el (@$r2) {
     my $dev = $el->[0];
     next if (!$ENC{$dev});
     my $fru = "$el->[0].$el->[1].$el->[2].$el->[3]";

     if (!$FRU{$fru}) {
        push(@array, [$LB->{new_fru},$fru ]);
        $changes++;
     } else {
        my $el0 = $FRU{$fru};
        if ($el0->[4] ne $el->[4] || $el0->[5] ne $el->[5] || $el0->[6] ne $el->[6]) {
          my $v1 = "$LB->{vendor}:$el0->[4], $LB->{model}: $el0->[5], $LB->{serial}:$el0->[6]";
          my $v2 = "$LB->{vendor}:$el->[4], $LB->{model}: $el->[5], $LB->{serial}:$el->[6]";
          push(@array, [ $LB->{rep},$fru, $v1, $v2 ]);
          $changes++;
        } elsif ($el0->[7] ne $el->[7]) {
          push(@array, [ $LB->{rev},$fru, $el0->[7], $el->[7] ]);
          $changes++;
        }
     }
  }
  if (!$changes) {
     push(@array, [ $LB->{no_diff} ]);
  }

  my $scr = Html::Screen->new();

  $scr->table( {title => $LB->{title4} },
   [
   [ f => 'First Report', $L[0] ],
   [ f => 'Second Report', $L[1] ],
   ]);

  $scr->list($q, { interactive => 1 , reportSize => 1}, 
   [
   [ l => $LB->{action}, '+n' ],
   [ l => $LB->{dev}, '+n' ],
   [ l => $LB->{old} ],
   [ l => $LB->{new} ],
   ],
   \@array,
   );
  print $scr->out();

}

sub history {
  my($q) = @_;
  my $LB = Labels->read('GUI::FruReport');
  print Html->body();

  if ($q->{ACTION_delete}) {
    my $del;
    print Html->header2("report.general.fru_hist");
    foreach my $el (keys %$q) {
      if (substr($el,0,4) eq "sel_") {
        my $file = System->get_home() . "/DATA/FruReport_history/" . substr($el, 4);
        unlink $file;
        $del++;
      }
    }
    print Html->info("Deleted $del archived report(s).");

  } elsif ($q->{ACTION_compare}) {
     print Html->header2("report.general.fru_hist", 0, 0, {noHelp => 1});
     &compare($q);
     return;
  } else {
    print Html->header2("report.general.fru_hist");
  }

  my $D = System->get_home() . "/DATA/FruReport_history";

  opendir(O, $D);
  my @l = readdir(O); closedir(O);


  my (@array);

  my $cnt;
  foreach my $f (@l) {
     next if ($f !~ /fru_report/);
     my($name, $date) = split(/\./, $f);
     $date =~ s/_/ /g;
     my $sel = "<input type=checkbox name=sel_$f>";
     my $url = "<a href=$Http::WEBPROC?GO=GUI::FruReport::frus0&filename=../FruReport_history/$f&date=$date>$date</a>";
     push(@array, [ $sel, $url]);
     $cnt++;
  }
  if (!$cnt) {
    push(@array, [ $LB->{no_arch} ]);
  }

  my $scr = Html::Screen->new();
  $scr->add(" <form><input type=hidden name=GO value=GUI::FruReport::history>");
  $scr->list($q, { reportSize => 1, title => $LB->{hist} , bottomButton => 1},
   [
   [ l => $LB->{sel} ],
   [ l => $LB->{creation} ],
   ],
   \@array,
   [
   [ l => 'ACTION_compare', $LB->{submit_comp} ],
   [ l => 'ACTION_delete', $LB->{submit_sel} ],
   ]);
   $scr->add("</form>");
   print $scr->out();
}

sub frus {
  my($q) = @_;
  my $LB = Labels->read('GUI::FruReport');
  print Html->body();

  my $LIST = [
    [ "fruDetail.html",   "GUI::FruReport::frus0", $LB->{report1}],
    [ "fruDetail2.html",  "GUI::FruReport::frus0_health", $LB->{report1_health}],
    [ "fruSummary1.html", "GUI::FruReport::summ1", $LB->{report2}],
    [ "fruSummary2.html", "GUI::FruReport::summ2", $LB->{report3}],
#   [ "fruSummaryB.html", "GUI::FruReport::battery", $LB->{reportB}],
    [ "fruReboot.html",   "GUI::FruReport::reboot", $LB->{reportReboot}],
    [ "fruTemp.html",     "GUI::FruReport::temperature", $LB->{reportTemp}],
    [ "fruTemp2.html",    "GUI::FruReport::temperature2", $LB->{reportTempUCL}],
#   [ "fruGlist.html",    "GUI::FruReport::glist", $LB->{reportGlist}],
    ];
  my ($info, $started);
  
  if ($q->{ACTION_archive}) {
    my $D = System->get_home() . "/DATA/FruReport_history";
    my $F = System->get_home() . "/DATA/tmp/fru_report";
    my $date1 = Util->get_file_created($F);
    $date1 =~ s/ /_/g;
    mkdir $D, 0777 if (!-d $D);
    open(O, $F);
    open(W, ">$D/fru_report.$date1");
    my ($l);
    while ($l = <O>) {
       print W $l;
    }
    close(O); close(W);
    print Html->info($LB->{arch_done});

  } elsif ($q->{ACTION_new}) {
    my $st = Process->status(undef, "fru_report");
    my $cpid;
    if ($st =~ /Running/) {
       print Html->warning($LB->{running});
    } else {
      $SIG{CHLD} = 'IGNORE';
      if (($cpid = fork()) == 0) {
        Process->start("fru_report");
        close STDIN; 
        close STDERR;
        close(STDOUT) if (!$ENV{FCGI});
        Reports::Fru->new(1);
        exit;
      } else {
        sleep(1);
        $info = Html->info($LB->expand(started => $cpid) );
        $started = 1;
      }
    }

  } elsif ($q->{ACTION_email}) {
    if ($q->{email}) {
      Reports->email($q, $q->{email}, "Fru Report", $LIST);
      $info= "$LB->{email_sent}!<br>";
    } else {
      print Html->error($LB->{email});
    }
    $Html::HEADER2_DONE = 0;
  }
  my $st = Process->status(undef, "fru_report");
  my($new, $meta);
  if ($st =~ /Running/ || $started) {
    $meta = "<meta http-equiv=Refresh content=\"10;URL=$Http::WEBPROC?GO=GUI::FruReport::frus\">" 
  } else {
    $new = 1;
  }

  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/fru_report");
  my ($archive);

  print $meta;
  print Html->header2("report.general.fru_report");
  my $dis1 = $st;
  $dis1 .= "..." if ($st =~ /Running/);

  if ($date) {
    $archive = 1;
  }
  my $scr = Html::Screen->new();
  $scr->add("$info <form> <input type=hidden name=GO value=GUI::FruReport::frus>");

  $scr->table( { title => $LB->{create} },
    [
    [ f => $LB->{report_status}, $dis1 ],
    ]);
  $scr->button2( [
   [ l => 'ACTION_new', $LB->{submit_new}, !$new ],
   [ l => 'ACTION_archive', $LB->{submit_archive}, !$archive ],
   ]);

   $scr->add( Reports->list($q, $LIST, $date));
   $scr->add("</form>");
   print $scr->out();

}



sub frus0_health {
  my($q) = @_;
  $q->{health} = 1;
  return &frus0($q);
}

sub read_admin_groups {
  my ($renv, $devs) = PDM::ConfigFile->read();
  my %AG;
  foreach my $d (@$devs) {
     $AG{$d->{name}} = $d->{adm_group};
  }
  return \%AG;
}

sub frus0 {
  my($q) = @_;
  my (%TYPE, %DEV, @NEW, $out);
  my $AG = &read_admin_groups();

  if (!$q->{SORT}) {
    $q->{SORT} = 1 ; $q->{SIGN} = 1;
  }
  my $LB = Labels->read('GUI::FruReport');
  my $history = 1 if ($q->{date});

  my $REP = Reports::Fru->new(undef, $q);

  print Html->body();
  if (! $REP) {
     print Html->error($LB->{no_report});
     return ;
  }
  $out .= Html->header2("report.general.fru_report", undef, $history ? $LB->{history}:"", undef, 
               {nohelp => $q->{email}, 
                right => $q->{date} || Util->get_today(), 
               noTabs => $q->{email}, 
                noDoc => 1});

  $REP = Reports::Fru->health($REP) if ($q->{health});

  foreach my $el (@$REP) {
	$DEV{$el->[1]} = 1;
	$TYPE{$el->[2]} = 1;
	next if ($q->{ADMGRP} && ($AG->{$el->[0]} ne $q->{ADMGRP}));
	next if ($q->{DEV} && ($q->{DEV} ne $el->[1]));
	next if ($q->{TYPE} && ($q->{TYPE} ne $el->[2]));
	push(@NEW, $el);
  }
  $REP = \@NEW;
  my @tt = split(/\,/, $LB->{titles1}); 

  my $gr = AdminGroup->select2($q->{ADMGRP});

  my $sel = "<select name=DEV><option value=\"\">[$LB->{device_type}]</option>"; 
  foreach my $el (sort keys %DEV) {
	  my $ck = $el eq $q->{DEV} ? "selected" : "";
	  $sel .= "<option value=\"$el\" $ck>$el</option>";
  }
  $sel .= "</select>";
  my $types = "<select name=TYPE><option value=\"\">[$LB->{fru_type}]</option>"; 
  foreach my $el (sort keys %TYPE) {
	  my $ck = $el eq $q->{TYPE} ? "selected" : "";
	  $types .= "<option value=\"$el\" $ck>$el</option>";
  }
  $types .= "</select>";
  my $title1 = $q->{health} ? $LB->{report1_health} : $LB->{report1};
  my $jump   = $q->{health} ? "frus0_health"        : "frus0";

  my $scr = Html::Screen->new();
  my $go1 = $scr->goForm([ "GO=GUI::FruReport::$jump", "SORT=$q->{SORT}", "SIGN=$q->{SIGN}",
         "date=$q->{date}" ],
    "$LB->{filters}: $gr &nbsp; $sel &nbsp; $types");

  $scr->list($q, { title => $title1, reportSize => 1, interactive => !$q->{email} } ,
   [
   [ l => $tt[0], '+sn' ],
   [ l => $tt[1], '+' ],
   [ l => $tt[2], '+' ],
   [ l => $tt[3], '+' ],
   [ l => $tt[4], '+' ],
   [ l => $tt[5], '+' ],
   [ l => $tt[6], '+' ],
   [ l => $tt[7], '+' ],
   [ l => $tt[8], '+' ],
   ],
   \@NEW,
   [
   [ l => 'DATA' , $go1, $q->{email} ]
   ]);
  $out .= $scr->out();

  return Reports->format($q, $REP, \$out, $history);
}


sub summ1 {
  my($q) = @_;
  my $out;
  my $AG = &read_admin_groups();

  if (!$q->{SORT}) {
    $q->{SORT} = 1 ; $q->{SIGN} = 1;
  }
  my $REP = Reports::Fru->new();
  my $LB = Labels->read('GUI::FruReport');

  print Html->body();
  if (! $REP) {
     print Html->error($LB->{no_report});
     return;
  }
  $out .= Html->header2("report.general.fru_report", undef, undef, undef, 
                         {nohelp => $q->{email}, right => Util->get_today(), noDoc => 1,
                          noTabs => $q->{email} });

  my $R = $REP->summ1($AG, $q->{ADMGRP});
  my @tt = split(/,/, $LB->{titles2});
  my $gr = AdminGroup->select2($q->{ADMGRP});

  my $scr = Html::Screen->new();
  my $go1 = $scr->goForm(["GO=GUI::FruReport::summ1","SORT=$q->{SORT}","SIGN=$q->{SIGN}"],$gr);

  $scr->list($q, { reportSize => 1, title => $LB->{report2}, interactive => !$q->{email} },
   [
   [ l => $tt[0], '+sn' ],
   [ l => $tt[1], '+' ],
   [ l => $tt[2], '+' ],
   [ l => $tt[3], '+' ],
   [ l => $tt[4], '+' ],
   [ l => $tt[5], '+' ],
   [ r => $tt[6], '-' ],
   ],
   $R,
   [
   [ l => 'DATA', $go1, $q->{email} ]
   ]);

  $out .= $scr->out();
         #<td align=right>Filters: $gr  <b> <input type=submit name=ACTION_filter value=GO>&nbsp;

  return Reports->format($q, $R, \$out);

}

sub summ2 {
  my($q) = @_;

  my $out;
  if (!$q->{SORT}) {
    $q->{SORT} = 1; $q->{SIGN} = 1;
  }

  my $REP = Reports::Fru->new();
  my $LB = Labels->read('GUI::FruReport');
  my $AG = &read_admin_groups();
  my $gr = AdminGroup->select2($q->{ADMGRP});

  print Html->body();
  if (! $REP) {
     print Html->error($LB->{no_report});
     return;
  } 
  $out .= Html->header2("report.general.fru_report", undef, undef, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), 
                          noTabs => $q->{email}, noDoc => 1});

  my ($R, $tot) = $REP->summ2($AG, $q->{ADMGRP});
  my @tt = split(/,/, $LB->{titles3});

  my $scr = Html::Screen->new();
  my $go1 = $scr->goForm([ "GO=GUI::FruReport::summ2", "SORT=$q->{SORT}","SIGN=$q->{SIGN}"], $gr);
          
  $scr->list($q, { title => $LB->{report3}, interactive => !$q->{email}, reportSize => 1 },
   [ 
   [ l => $tt[0], '+sn' ],
   [ l => $tt[1], '+' ],
   [ l => $tt[2], '+' ],
   [ l => $tt[3], '+' ],
   [ l => $tt[4], '+' ],
   [ r => $tt[5], '-' ],
   ],
   $R,
   [
   [ l => 'DATA', $go1 , $q->{email}],
   ]);
  $out .= $scr->out();
  return Reports->format($q, $R, \$out);
}

sub temp {
  my($q) = @_;

  my $out;
  my $REP = Reports::Fru->new();
  my @R;
  my $L = Labels->read('GUI::FruReport');

  foreach my $el (@$REP) {
     next if ($el->[0] ne $q->{name});
     my $t = sprintf("%.1f", $el->[9]);
     if (defined ($el->[9])) {
       push(@R, [$el->[2], $el->[3], $el->[4], $el->[5], $el->[7], $t, $el->[11]]);
     }
  }
  my $AG = &read_admin_groups();
  my $gr = AdminGroup->select2($q->{ADMGRP});

  my($pageInfo, $list) = Html::List->makeList($q, \@R,
        [ $L->{type}, $L->{fru},   $L->{vendor},$L->{model} , $L->{sm_rev}, $L->{temp}, $L->{glist} ],
        ['l',     'l',     'l',     'l',      'l',    'r',  'r'       ],
        [ '+',    '+',     '+',     '+',      '+',    '-',  '+'       ],
             {reportSize => 1, interactive => !$q->{email} });

  $out .= "
  <table border=0 cellspacing=0 bgcolor=white cellpadding=4 width=98%>
    <$q->{email}form><input type=hidden name=GO value=GUI::FruReport::temp>
	 <input type=hidden name=SORT value=$q->{SORT}>
	 <input type=hidden name=SIGN value=$q->{SIGN}>
    <tr><td colspan=7 bgcolor=$Style::DARK>
      <table border=0 cellspacing=0 width=100%><tr>
         <td><b><font color=white>Fru Details for $q->{name}</td>
      </table></td>
  </table>
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=$Style::WIDTH>
    $list
  </table>
  ";
  return Reports->format($q, \@R, \$out);
  
}

sub temperature2 {
  my($q) = @_;

  my $out;
  print Html->body();

  my $LB = Labels->read('GUI::FruReport');
  $out .= Html->header2("report.general.fru_report", undef, $LB->{reportTempUCL}, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), 
                          noTabs => $q->{email}, noDoc => 1});

  $out .= "<table border=0><tr><td></table>";
  if (!$q->{SORT}) {
    $q->{SORT} = 1; $q->{SIGN} = 1;
  }

  my $REP = Reports::Fru->new();

  if (! $REP) {
     $out .= Html->error($LB->{no_report});
     return $out;
  } 
  my ($R, $tot, $std, $avg, $lcl, $ucl) = $REP->temperature(undef, undef, {ucl => 1});
  my(@R2);
  foreach my $el (@$R) {
     push(@R2, [$el->[0], $el->[1],$el->[2],$el->[3],$el->[4],$el->[5], 
               $el->[6], $el->[7],$el->[9]]);
  }
  $avg = sprintf("%.2f", $avg);
  $std = sprintf("%.2f", $std);
  $lcl = sprintf("%.2f", $lcl);
  $ucl = sprintf("%.2f", $ucl);

  $out .= "<table border=0 cellpadding=2 width=$Style::WIDTH bgcolor=white>
  <tr><td>$LB->{fru_count} <b>$tot</b>, $LB->{avg_temp_all} 
  <font color=blue><b>$avg</b></font>, $LB->{std_dev} <b>$std</b>
  <br> $LB->{low_lim}: <font color=red>
  <b>$lcl</b></font>, $LB->{up_lim}: <font color=red><b>$ucl</b></font>
  </table>";

  my($pageInfo, $list) = Html::List->makeList($q, \@R2,
        [ $LB->{devicename}, $LB->{type}, $LB->{fru},   $LB->{fruid}, $LB->{vendor} ,$LB->{model} , $LB->{serial_n}, $LB->{sm_rev}, $LB->{temp}    ],
        ['l',           'c',     'l',    'l',     'l',     'l',      'l',       'l',    'c'       ],
        ['+',           '+',    '+',     '+',     '+',     '+sn',      '+',       '+',    '-'       ],
         {reportSize => 1, interactive => !$q->{email} });

  $out .= "
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=$Style::WIDTH>
    $list
  </table>
  &nbsp;<p>
  <table border=0 width=60% bgcolor=white><tr><td>
    $LB->{note}
   </table>
  ";

  return Reports->format($q, \@R2, \$out);
}

sub temperature {
  my($q) = @_;

  my $out;
  print Html->body();

  $out .= "<script>
  function win1(a) {
     var b = '$Http::WEBPROC?GO=GUI::FruReport::temp&name=' + a;
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=500,height=500');
      O.focus();
  }
  </script>
  " ;
  my $G = Labels->read();
  my $LB = Labels->read('GUI::FruReport');
  $out .= Html->header2("report.general.fru_report", undef, $LB->{reportTemp}, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), 
                          noTabs => $q->{email}, noDoc => 1});

  $out .= "<table border=0><tr><td></table>";
  if (!$q->{SORT}) {
    $q->{SORT} = 1; $q->{SIGN} = 1;
  }

  my $REP = Reports::Fru->new();

  if (! $REP) {
     $out .= Html->error($LB->{no_report});
     return $out;
  } 
  my $AG = &read_admin_groups();
  my $gr = AdminGroup->select2($q->{ADMGRP});

  my ($R, $tot, $std, $avg, $lcl, $ucl) = $REP->temperature($AG, $q->{ADMGRP});

  foreach my $e (@$R) {
     $e->[0] = "<a href=javascript:win1('$e->[0]')>$e->[0]</a>";
     $e->[4] = sprintf("%2.2d", $e->[3] - $e->[2]+ 1);
  }
  $avg = sprintf("%.2f", $avg);
  $std = sprintf("%.2f", $std);
  $lcl = sprintf("%.2f", $lcl);
  $ucl = sprintf("%.2f", $ucl);

  $out .= "<table border=0 cellpadding=2 width=$Style::WIDTH bgcolor=white>
  <tr><td>$LB->{dev_cnt}: <b>$tot</b>, $LB->{avg_temp}: <font color=blue><b>$avg</b></font>, $LB->{stddev}: <b>$std</b>, $LB->{low_lim}: <font color=red><b>$lcl</b></font>, $LB->{up_lim}: <font color=red><b>$ucl</b></font></table>";

  my $head ="$LB->{temperature_dis}</b> ($LB->{temp_msg})<pre>0         1         2         3         4         5         6\n0123456789012345678901234567890123456789012345678901234567890</td>";

  my($pageInfo, $list) = Html::List->makeList($q, $R,
        [ "$LB->{devicename}", $head,     "$LB->{low}", "$LB->{high}" , "$LB->{spread}"   ],
        ['l',           'x',       'c',     'c' , 'c'     ],
        [ '+',         undef,      '+',    '-'  , '-'    ],
          { reportSize=> 1, interactive => !$q->{email} });


  $out .= "
  <table border=0 cellspacing=0 bgcolor=white cellpadding=0 width=$Style::WIDTH>
    <$q->{email}form><input type=hidden name=GO value=GUI::FruReport::temperature>
	 <input type=hidden name=SORT value=$q->{SORT}>
	 <input type=hidden name=SIGN value=$q->{SIGN}>
         <td align=right>Filters: $gr  <b>".
        Html::Screen->submitButton("ACTION_filter",$G->{go}) . "&nbsp;</table></td>
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=$Style::WIDTH>
    $list
  </table>
   &nbsp;
  <table border=0 width=$Style::WIDTH><tr><td>$LB->{dev_cnt}: <b>$tot</b>, $LB->{average}: <font color=blue><b>$avg</b></font>, $LB->{stddev}: <b>$std</b>, $LB->{lcl}: <font color=red><b>$lcl</b></font>, $LB->{ucl}: <font color=red><b>$ucl</b></font><br><small>$LB->{limits}.</table>
  ";																															   

  return Reports->format($q, $R, \$out);

}

sub glist {
  my($q) = @_;

  my $out;
  print Html->body();

  $out .= "<script>
  function win1(a) {
     var b = '$Http::WEBPROC?GO=GUI::FruReport::temp&name=' + a;
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=500,height=500');
      O.focus();
  }
  </script>
  " ;
  my $LB = Labels->read('GUI::FruReport');
  $out .= Html->header2("report.general.fru_report", undef, $LB->{reportGlist}, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), 
                          noTabs => $q->{email}, noDoc => 1});

  $out .= "<table border=0><tr><td></table>";
  if (!$q->{SORT}) {
    $q->{SORT} = 1; $q->{SIGN} = 1;
  }

  my $REP = Reports::Fru->new();

  if (! $REP) {
     $out .= Html->error($LB->{no_report});
     return $out;
  } 
  my $AG = &read_admin_groups();
  my $gr = AdminGroup->select2($q->{ADMGRP});

  my ($R, $tot, $std, $avg, $lcl, $ucl) = $REP->glist($AG, $q->{ADMGRP});

  foreach my $e (@$R) {
     $e->[0] = "<a href=javascript:win1('$e->[0]')>$e->[0]</a>";
     $e->[4] = sprintf("%2.2d", $e->[3] - $e->[2]);
  }
  $avg = sprintf("%.2f", $avg);
  $std = sprintf("%.2f", $std);
  $lcl = sprintf("%.2f", $lcl);
  $ucl = sprintf("%.2f", $ucl);

  $out .= "<table border=0 cellpadding=2 width=$Style::WIDTH bgcolor=white>
  <tr><td>Device Count: <b>$tot</b>, Average Glist Count: <font color=blue><b>$avg</b></font>, Std-Dev: <b>$std</b>, Lower Control Limit: <font color=red><b>$lcl</b></font>, Upper Control Limit: <font color=red><b>$ucl</b></font></table>";

  my $head ="Glist Distribution</b> (Number of frus for each Glist Count)<pre>0         1         2         3         4         5\n012345678901234567890123456789012345678901234567890</td>";

  my($pageInfo, $list) = Html::List->makeList($q, $R,
        [ "DeviceName", $head,     "Low", "High" , "Spread"   ],
        ['l',           'x',       'c',     'c' , 'c'     ],
        [ '+',         undef,      '+',    '-'  , '-'    ],
          { reportSize=> 1, interactive => !$q->{email} });


  $out .= "
  <table border=0 cellspacing=0 bgcolor=white cellpadding=0 width=$Style::WIDTH>
    <$q->{email}form><input type=hidden name=GO value=GUI::FruReport::glist>
	 <input type=hidden name=SORT value=$q->{SORT}>
	 <input type=hidden name=SIGN value=$q->{SIGN}>
         <td align=right>Filters: $gr  <b>".
        Html::Screen->submitButton("ACTION_filter", "GO") . "&nbsp;
      </table></td>
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=$Style::WIDTH>
    $list
  </table>
   &nbsp;
  <table border=0 width=$Style::WIDTH><tr><td>Device Count: <b>$tot</b>, Average: <font color=blue><b>$avg</b></font>, StdDev: <b>$std</b>, LCL: <font color=red><b>$lcl</b></font>, UCL: <font color=red><b>$ucl</b></font><br><small>Lower and Upper Control Limits are 3 standard deviations under and over the median.</table>
  ";

  return Reports->format($q, $R, \$out);

}




sub reboot {
  my($q) = @_;

  my $out;
  print Html->body();

  $out .= Html->header2("report.general.fru_report", undef, undef, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), 
                          noTabs => $q->{email}, noDoc => 1});
  if (!$q->{SORT}) {
    $q->{SORT} = 3; $q->{SIGN} = -1;
  }

  my $REP = Reports::Fru->new();
  my $LB = Labels->read('GUI::FruReport');

  if (! $REP) {
     print Html->error($LB->{no_report});
     return;
  } 
  my $AG = &read_admin_groups();
  my $gr = AdminGroup->select2($q->{ADMGRP});
  my ($R, $tot) = $REP->reboot($AG, $q->{ADMGRP});
  my @tt = split(/,/, $LB->{titlesReboot});

  my($pageInfo, $list) = Html::List->makeList($q, $R,
        [ @tt                    ],
        ['l',  'l',     'l'      ],
        ['+',  '+',    '+'       ],
             {reportSize=> 1, interactive => !$q->{email},
              colDisplay => [0, 0, \&reboot_age] });

  $out .= "
  <table border=0 cellspacing=0 bgcolor=white cellpadding=4 width=$Style::WIDTH>
    <form><input type=hidden name=GO value=GUI::FruReport::reboot>
	 <input type=hidden name=SORT value=$q->{SORT}>
	 <input type=hidden name=SIGN value=$q->{SIGN}>
    <tr><td colspan=2>
      <table border=0 cellspacing=0 width=100%><tr>
         <td>$LB->{reportReboot}</td>
         <td align=right>Filters: $gr  <b>".
        Html::Screen->submitButton("ACTION_filter", "GO") . "&nbsp;
      </table></td>
  </table>
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=$Style::WIDTH>

    $list
   <tr><td colspan=3>&nbsp; Total: $tot devices &nbsp;</td>
  </table>
  ";
  return Reports->format($q, $R, \$out);
}




sub battery {

  # No Longer used - Arrays no lnger report battery information
  my($q) = @_;

  my $out;
  print Html->body();

  $out .= Html->header2("report.general.fru_report", undef, undef, undef,
                         {nohelp => $q->{email}, right => Util->get_today(), 
                          noTabs => $q->{email}, noDoc => 1});
  if (!$q->{SORT}) {
    $q->{SORT} = 1; $q->{SIGN} = 1;
  }

  my $REP = Reports::Fru->new();
  my $LB = Labels->read('GUI::FruReport');

  if (! $REP) {
     print Html->error($LB->{no_report});
     return;
  } 
  my $AG = &read_admin_groups();
  my $gr = AdminGroup->select2($q->{ADMGRP});

  my ($R, $tot) = $REP->battery($AG, $q->{ADMGRP});
  my @tt = split(/,/, $LB->{titlesB});
  $q->{SORT} = 1 if (!$q->{SORT});


  my $scr = Html::Screen->new();
  my $go1 = $scr->goForm(["GO=GUI::FruReport::battery","SORT=q->{SORT}","SIGN=$q->{SIGN}" ], $gr );

  $scr->list($q, { reportSize =>1, title => $LB->{reportB}, interactive => !$q->{email} },
  [
  [ l => $tt[0], '+sn'],
  [ l => $tt[1], '+'],
  [ l => $tt[2], '+'],
  ],
  $R,
  [
  [ l => $go1 ],
  ]);

  $out .= $scr->out();
  return Reports->format($q, $R, \$out);

}


sub reboot_age {
  my($age) = @_;
  $age += 0;
  if ($age == 0) {
     return "<td>Data Not Available</td>";
  } elsif ($age > 400) {
     return "<td bgcolor=#FFD0D0>&nbsp;<b>$age days</td>";
  } else {
     return "<td>&nbsp;$age days</td>";
  }
}



1;

