package GUI::EventReport;

use Report;
use System;
use Html::List;
use Reports;
use Reports::Event;
use strict;
use Modules;

sub events {
  my($q) = @_;

  my $LB = Labels->read("GUI::EventReport");

  my $LIST = [
   [ "eventYM.html",   "GUI::EventReport::eventsYmd",  $LB->{report1}],
   [ "eventWeek.html", "GUI::EventReport::eventsWeek", $LB->{report2}],
   [ "eventDOW.html",  "GUI::EventReport::eventsDow",  $LB->{report3}],
    ];
  my $info;
  print Html->body();

  if ($q->{ACTION_new}) {
    Reports::Event->new(1, {actionable => $q->{actionable}} );
    $info= "New Report done!";

  } elsif ($q->{ACTION_email}) {
    if ($q->{email}) {
      Reports->email($q, $q->{email}, "Event Report", $LIST);
      $info= "$LB->{email_sent}!<br>";
    } else {
      print Html->error($LB->{email});
    }
    $Html::HEADER2_DONE = 0;
  }
  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/event_report");

  print Html->header2("report.general.event_report");

  my $scr = Html::Screen->new();
  $scr->add("$info <form> <input type=hidden name=GO value=GUI::EventReport::events>");
  $scr->table( { title => $LB->{create} },
   [
   [ f => $LB->{action}, "<input type=checkbox name=actionable>" ],
   [ f => $LB->{last_run}, $date ],
   ]);
  $scr->button2( [
    [ l => 'ACTION_new', $LB->{submit_run} ],
    ]);
 
  $scr->add(Reports->list($q, $LIST, $date));
  $scr->add("</form>");
  print $scr->out();
}
  

sub eventsYmd {
  my($q) = @_;
  print Html->body();
  my $out = Html->header2("report.general.event_report",undef, undef, undef, 
                {nohelp => $q->{email}, right => Util->get_today(), 
                 noTabs => $q->{email}, noDoc => 1});

  my $REP = Reports::Event->new();
  my $LB = Labels->read("GUI::EventReport");

  my ($R, $TOT)   = $REP->ymd({ interactive => !$q->{email}} );
  $out .= &all_reports($q, $R,$TOT, $LB->{year_month}, $REP);
  if ($q->{email}) {
     return $out;
  } else {
     print $out;
  }
}

sub eventsWeek {
  my($q) = @_;
  print Html->body();
  my $out = Html->header2("report.general.event_report",undef, undef, undef, 
                  {nohelp => $q->{email}, right => Util->get_today(), 
                   noTabs => $q->{email}, noDoc => 1});

  my $REP = Reports::Event->new();
  my $LB = Labels->read("GUI::EventReport");

  my ($R, $TOT)   = $REP->week({ interactive => !$q->{email}} );
  $out .= &all_reports($q, $R,$TOT, $LB->{year_week}, $REP);
  if ($q->{email}) {
     return $out;
  } else {
     print $out;
  }
}

sub eventsDow {
  my($q) = @_;
  print Html->body();
  my $out = Html->header2("report.general.event_report",undef, undef, undef, 
                {nohelp => $q->{email}, right => Util->get_today(), 
                 noTabs => $q->{email}, noDoc => 1});

  my $REP = Reports::Event->new();
  my $LB = Labels->read("GUI::EventReport");
  my $G  = Labels->read();

  my @DD = split(/,/, $G->{dow});
  my %MAP = (0=>$DD[0], 1=>$DD[1],2=>$DD[2],3=>$DD[3],4=>$DD[4],5=>$DD[5],6=>$DD[6]);

  my ($R, $TOT)   = $REP->dow({ interactive => !$q->{email}, map => \%MAP } );
  $out .= &all_reports($q, $R,$TOT, $LB->{dow}, $REP);
  if ($q->{email}) {
     return $out;
  } else {
     print $out;
  }
}

sub all_reports {
  my($q, $R, $TOT, $label1, $REP) = @_;
  
  if (!$q->{SORT}) {
    $q->{SORT} = 1 ; $q->{SIGN} = 1;
  }
  my $LB = Labels->read("GUI::EventReport");

  my($pageInfo, $list) = Html::List->makeList($q, $R,
        [$LB->{dev_type}, $label1,   $LB->{info}, $LB->{warn},$LB->{err}, $LB->{down} ],
        [  'l',         'l',        'r',    'r',     'r',     'r'    ],
        [ '+sn',        '+sn',      '-',    '-',     '-',     '-'    ],
                     {pageSize => 100, interactive => !$q->{email} });

  my $ac = $REP->{action} ? $LB->{act} : $LB->{all} ;

  return "
  <script>
  function openw(a) {
	  var b = '$Http::WEBPROC?GO=GUI::EventReport::details&' + a;
	  var O = window.open(b,'rep','menubar=no,resizable=yes,scrollbars=yes,width=800,height=500');
	  O.focus();
  }
  </script>
  <table border=1 cellspacing=0 cellpadding=0 width=$Style::WIDTH bgcolor=white>
  <tr><td colspan=6><table border=0><tr><td><b>$LB->{title1}/ $label1</b> &nbsp;($ac)</table></td>
    $list
  <tr><td align=right colspan=2>Total:</td> <td align=right><b>$TOT->[0]&nbsp;</td> <td align=right><b>$TOT->[1]&nbsp;</td> <td align=right><b>$TOT->[2]&nbsp;</td> <td align=right><b>$TOT->[3]&nbsp;</td>
  </table>
  <table border=0><tr><td></table>
  <table border=0 width=95%>
    <tr><td>$pageInfo</td>
        <td align=right>
  </table>
  ";
}

sub details {
  my($q) = @_;

  print Html->body();
  my $LB = Labels->read("GUI::EventReport");

  my @SEV = ('INFO','WARN','ERR','DOWN');
  open(O, System->get_home(). "/DATA/tmp/Events.log1");
  my $ym;
  if ($q->{ym}) {
    $ym  = $q->{ym};
    $ym =~ s/-//g;
  }
  my $sev   = "Sev:$q->{sev}"     if (exists($q->{sev}));
  my $type  = "\t$q->{type}\."    if ($q->{type});
  my $yweek = "Yweek:$q->{yweek}" if ($q->{yweek});
  my $dow   = "Dow:$q->{dow}"     if ($q->{dow});
  my ($l,@F);
  while ($l = <O>) {
       next if ($ym   && $l !~ /^$ym/);
       next if ($sev  && index($l, $sev) < 0);
       next if ($type && index($l, $type) < 0);
       next if ($dow  && index($l, $dow) < 0);
       next if ($yweek && index($l, $yweek) < 0);
       push(@F, $l);
  }
  close(O);
  my $title = "$LB->{date}: $ym," if ($ym);
  $title .= " $LB->{sev}: $SEV[$q->{sev}]," if (exists($q->{sev}));
  $title .= " $LB->{type}: $q->{type},"     if (exists($q->{type}));
  $title .= " $LB->{yweek}: $q->{yweek},"   if (exists($q->{yweek}));
  $title .= " $LB->{dow}: $q->{dow},"       if (exists($q->{dow}));
  chop($title) if ($title);

  print "<table border=0 cellpadding=4 cellspacing=0 width=100% bgcolor=white>
  <tr><td>Event List [ $title ] ";
  if ($#F > 200 && !$q->{ALL}) {
    my $list;
    foreach my $e (keys %$q) {
      next if ($e eq "GO");
      $list .= "&$e=$q->{$e}";
    }
    my $l1 = Labels->expand(display => ($#F+1));
    print "<td align=right>$l1 [<a href=/rashttp?GO=GUI::EventReport::details$list&ALL=1>LB->{display_all}</a>]";
  } else {
    print "<td align=right>" . ($#F+1) . " $LB->{events}</td>";
  }
  print "</table>";
 
  my $header = "</table><table border=1 cellspacing=0 width=100% cellpadding=0 bgcolor=white>
    <tr bgcolor=$Style::LIGHT>
      <td><b>$LB->{date}</td>
      <td><b>$LB->{event}</td>
      <td><b>$LB->{topic}</td>
      <td><b>$LB->{desc}</td>
      <td><b>$LB->{sev}</td>
      <td><b>$LB->{action2}</td>
       ";
  my $cnt = 0;
  foreach my $l (@F) {
	print $header if ($cnt++ % 100 == 0) ;
        last if ($cnt > 200 && !$q->{ALL});
        my($dt, $event, $comp, $desc, $sev, $action, $enc) = split(/\t/, $l);
	$comp =~ s/\./. /g;
	my($cat, $ev) = split(/\./, $event,2);
        my $date = substr($dt,0,4) . "-" . substr($dt,4,2) . "-" . substr($dt,6,2);
	my $time = substr($dt,8,2) . ":" . substr($dt,10,2);
	my $enc = substr($enc,4);
	$sev = $SEV[substr($sev,4)];
	$event =~ s/Event$//;
        print "<tr><td>$date $time<td>$event<td>$comp&nbsp;<td>$desc&nbsp;<td><center>$sev".
	       "<td><center>" . substr($action,7) . "</td>";
  }
  print "</table>";
}


1;

