package GUI::Discover;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict 'vars';
use System;
use Util;
use TO;
use GUI::Devices;
use Logic::SWITCH;
use Discover;


sub details {
  my($q) = @_;
  my $type = $q->{type};
  my $L     = Labels->read('GUI::Discover');
  print Html->body();
  print "<table border=1 cellspacing=0 width=100% bgcolor=white>
   <tr><td bgcolor=$Style::DARK colspan=4><font color=white><b>$L->{discovered}</td>
   <tr bgcolor=$Style::LIGHT>
       <th>$L->{agent}</th>
       <th>$L->{type}</th>
       <th>$L->{name}</th>
       <th>$L->{ip}</th>
  ";
 my $D = System->get_home() . '/DATA/Discover';
 opendir(O1, $D);
 my @files = readdir(O1); closedir(O1);
 my ($agent, $l);
 foreach my $f (@files) {
    if ($f =~ /^$type.(.+)/) {
       $agent = $1;
       open(O1, "$D/$f");
       while ($l = <O1>) {
           chop($l);
           next if (substr($l,0,1) eq "#" || index($l, "|") < 0); 
           my @a = split(/\|/, $l);
           if ($a[0] eq "ERR") {
             print "<tr><td colspan=4>$a[0]: $a[1]</td>";
           } else {
             my $t = $a[8] || $a[1];
	     my $name = $a[7] || $a[9] || $a[2];
             print "<tr><td>$agent</td>
              <td><center>$t</td>
              <td>$name</td>
              <td>$a[2]</td>";
           }
       }
       close(O1);
    }
 }
 print "</table>";
       
}
#
# called from the left_frame, generate the welcome to discovery page with buttons
# for each device type that can be discovered.
#
sub run {
  my($q) = @_;

  my($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read;
  my(@admins, $fun);
  print Html->body();
  if (my $err = Roles->verifyRole($q, "admin")) {
     print $err;
     return;
  }
  if (-f System->get_home() . "/DATA/Solution.golden" && !$q->{ALL}) {
     GUI::Discover::discover({product => "Solution"});
     return;
  }
  my $G     = Labels->read();
  my $L     = Labels->read('GUI::Discover');
  my $L2    = Labels->read('GUI::Discover')->section('disco');

  my $MODS  = Modules->load("GUIAdmin");

  my($input, $input2, $input3);
  my ($cnt, $cnt2, @L);
  $input    = "<select name=product>";

  foreach my $m (sort @$MODS) {
    $fun = "GUIAdmin::${m}::discover";

    if (defined(&$fun)) {
      my $f1 = "GUIAdmin::${m}" ; 
      my $i = $f1->isDevice();
      my $pk = "GUIAdmin::${m}";
      my $name2 = $pk->description("Dis_Screen");
    
      if ($name2) {
        push(@L, "$name2|$i|$m");
      }
    }
  }
  foreach my $l (sort @L) {
     my($name2, $i, $m) = split(/\|/, $l);
     $name2 .= " ($L2->{background})" if (index("DeviceFromIP,SWITCH,T3,6020,6120,3310", $m) >= 0);
     my $ck = "selected" if ($m eq $q->{SELECT});
     if (lc($m) eq "subnet") {
         $input3 .= "<option value=$m>$name2</option>";
     } elsif ($i) {  
         $input2 .= "<option value=$m $ck>$name2</option>";
     } else {
         $input .= "<option value=$m $ck>$name2</option>";
     }
  }
  $input .= "$input2 $input3</select>";
  my $select_hosts = "<select name=select_host><option value=\"\">$G->{all_hosts}<option value=local>" . 
                      $renv->{hostname};
  $select_hosts .= $Config->slaveSelect();
  $select_hosts .= "</select>";

  my $TOT = Discover->stats();
  my $total_running;
  my $scr = Html::Screen->new();
  my (@array, $c1);
  foreach my $el (keys %$TOT) {
       my $r1 = $TOT->{$el}{start} - $TOT->{$el}{stop};
       $r1 = 0 if ($r1 < 0);
       $total_running += $r1;
       my $url = "<a href=javascript:details('$el')>&nbsp;$TOT->{$el}{lines}&nbsp;</a>";
       push(@array, [ $el, $r1, $TOT->{$el}{stop}, $url ]);
       $c1++;
  }
  my @buttons;
  if ($c1) {
       push(@buttons, 
         [ l => "ACTION_clear",   $L2->{clear2} ],
         [ l => "ACTION_process", $L2->{submit2} ],
           );
  } else {
      push(@array, [$L2->{none}]);
  }
  if ($total_running && !$q->{SELECT} ) {
    print "\n<meta http-equiv=Refresh content=\"10;URL=$Http::WEBPROC?GO=GUI::Discover::run\">" ;
  }
  print Html->header2("admin.gen_maint.discovery");

  $scr->add(" <form  method=get> <input type=hidden name=GO value=GUI::Discover::discover>");

  $scr->list($q, { title => $L2->{title} , pageInfo => 0 },
   [
   [ l => $L2->{method}  ],
   [ l => $L2->{running} ],
   [ l => $L2->{done}    ],
   [ l => $L2->{dev}     ],
   ],
   \@array,
   \@buttons,
   );

  $scr->add("&nbsp;");
  $scr->script("
   function details(a) {
     var b = '$Http::WEBPROC?GO=GUI::Discover::details&type=' + a;
     var O = window.open(b,'win1','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
     O.focus();
   }
   ");

  $scr->table( {title => $L->{'disco.l1'} },
   [
   [ f => $L->{'disco.l2'}, $select_hosts     ],
   [ f => "Product/ $L->{'disco.l3'}", $input ],
   ]);

  $scr->button2([
    [ l => 'ACTION_d',  $L->{'disco.submit1'} ],
    ] );
  $scr->add("</form>");

  print $scr->out();
}


#
# Called to discover a specific type of device
#
sub discover {
  my($q, $post, $util) = @_;
  my($fun);
  print Html->body();
  if ($q->{ACTION_clear}) {
      my $DIR = System->get_home() . "/DATA/Discover";
      opendir(OO, $DIR);
      my @files = readdir(OO); closedir(OO);
      foreach my $f (@files) {
         next if (substr($f,0,1) eq ".");
         unlink "$DIR/$f";
      }
      &run($q);
      return;

  } elsif ($q->{ACTION_process}) {
      my ($err, $all_running, $info) = Discover->process_discovery($q);
      print "$info<br>" if ($info);
      print Html->warning($err) if ($err);
      print "$all_running agent(s) still running!" if ($all_running);
      use GUI::Devices;
      GUI::Devices::list($q);
      return;
  }
  my $MODS = Modules->load("GUIAdmin");

  if (($fun=$q->{PKG})) { # it's a callback
    if (defined(&$fun)) {
      my $rc = &$fun($q,$post,$util);
      if ($rc eq "DONE") {
        GUI::Devices::list($q);
      } elsif ($rc eq "DISCO") {
        # Must sleep a little bit to allow time for files
	# to get created from background processes
	# Otherwise page doesn't refresh
        sleep(5);
        &run($q);
      }
    }
    return;
  }

# find which button was pressed

  my $name;
  if ($q->{product}) {
     $name = $q->{product};
     $fun = "GUIAdmin::${name}::discover";

     if (defined(&$fun)) {
        my $rc = &$fun($q,$post,$util);
        if ($rc eq "DONE") {
          GUI::Devices::list($q) ;
        } elsif ($rc eq "DISCO") {
          &run($q);
        }
     }
  }
  #run($q,$post,$util);
}




sub rediscover {
  my($q) = @_;

  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;

  my $head = Html->header("Save SnapShop ","","","rediscover");
  my $info =  Html->readHtdocs("rediscover");

  print "\n<body bgcolor=$Style::BGCOLOR>&nbsp;<center>$head
  <table border=0 bgcolor=white width=90% cellpadding=4><tr><td>$info</table>\n";

  print "<table border=0><tr><td></table>\n";
  print "<table border=1 cellspacing=0 width=90% bgcolor=white>
  <tr bgcolor=$Style::LIGHT>
      <td><form><input type=hidden name=GO value=GUI::Discover::rediscover>
          <b><center>Select</td>
      <td><b><center>Host</td>
      <td><b><center>Last Discover</td>
  ";
  my $F = System->get_home() . "/DATA/topo/$renv->{hostname}";
  my $c = "N/A";
  $c = Util->get_file_created($F) if (-f $F);

  print "<tr>
    <td><center><input type=checkbox name=host_$renv->{hostname}>
    <td>&nbsp;$renv->{hostname}
    <td>&nbsp;$c
     ";

  foreach my $h (@$hosts) {
    my $F = System->get_home() . "/DATA/topo/$h->{hostname}";
    my $c = "N/A";
    $c = Util->get_file_created($F) if (-f $F);
    print "<tr>
       <td><center><input type=checkbox name=host_$h->{hostname}>
       <td>&nbsp;$h->{hostname}
       <td>&nbsp;$c
         ";
  }
  print "</table>";
  print "<b><input type=submit name=ACTION value=Re-Discover></form>";
}



1;

