package GUI::DeviceReport;
use Report;
use System;
use strict;
use State;
use Grid;
use Html::List;

use vars qw (@E @GIF);
@E = ('ok', 'Warning', 'Error', 'Critical');

# $Http::WEBPROC?GO=GUI::Instr::rStart&Roption=2&topo=MERGE-MASTER&file=' + a;

sub make_link {
  my($q, $type, $h, $name , $window) = @_;
  my $h0 = $h;
  $h0 =~ s/\W//g;
  my $args = Html->makeArgs($q, "Roption,topo,file");
  $name = $h if (!$name);
  if ($window eq "N") {
    return "<a href=$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=2&topo=MERGE-MASTER&file=$type:$h$args>$name</a>";
  } else {
    return "<a href=javascript:win1('$type:$h','$h0')>$name</a>";
  }
}

# ONE LINE PER DEVICE
# CALLED MY SYSTEM1
#
sub runWin {
 my($q) = @_;

 &alarmRun($q);
}

# summary=0: only show devices that are broke
# summary=2: show all devices in config.
# summary=1: show only broke + show one alarm description (not very useful)
# severity=3|2|1

sub run {
 my($q) = @_;
 my $deny = Roles->verifyRole($q, "admin");
 print Html->body();
 my $renv = System->get_renv();
 my $ruser = System->get_ruser();
 my $window = $ruser->{window} || $renv->{window};
 my $summ = $q->{summary};
 my $SEV  = $q->{severity};
 my $G    = Labels->read();
 my $extra;
 foreach my $el (keys %$q) {
    $extra .= "&$el=$q->{$el}";
 }

 if ($q->{ACTION_stop}) {
   delete($q->{ACTION_refresh});
   delete($q->{ACTION_stop});
 } elsif ($q->{ACTION_refresh}) {
    my $args = Html->makeArgs($q, "summary,ACTION_refresh");
    print "<meta http-equiv=Refresh content=\"70;URL=$Http::WEBPROC?".
          "GO=GUI::DeviceReport::run$args&summary=$summ&ACTION_refresh=1\">";
    delete($q->{ACTION_stop});
 } elsif ($q->{ACTION_clear}) {
    State->clearAllComponents();
    State->write();
 }
 my $all= "<a href=/rashttp?GO=GUI::DeviceReport::run>$G->{allsev}</a>";

 print Html->header2( "report.general.dev_report5",
       undef, undef, undef, 
     { noDoc => 1,          noTabs => $q->{noTabs}, 
       CNL   => $q->{CNL},  right  => $all 
     });

 my %REPORT;
 my $LB = Labels->read("GUI::AlertReport");

 my $RL = Report->reportList();
 foreach my $r0 (keys %$RL) {
    $REPORT{$r0} = 1;
 }
 my($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read;
 State->cleanState();
 my $DB = State->getComponentState(1); # worst severity for each comp.
 my @report;

 my($sw, $st, $ho);
 my $file =  "host:" . $renv->{hostname};
 my ($sev, $err, $col, $sev_no) = &sev($SEV, $DB, $file, $summ);
 my $mon = "$LB->{on}";
 $mon .= "/" . $LB->{no_report} if (!$REPORT{$file});
 my $url = &make_link($q, "host", $renv->{hostname}, undef, $window);

 $ho=1;
 if ($sev_no || $summ > 0) {
   push(@report, ["host", $url, $sev, Util->name2ip(),$mon, $renv->{time_added}, $err, $col ]);
 }

 foreach my $h (@$hosts) {
   ($sev, $err, $col, $sev_no) = &sev($SEV, $DB, "host:" . $h->{hostname}, $summ);
   $ho++;
   next if (!$sev_no && $summ == 0);
   my $file =  "host:" . $renv->{hostname};
   my $mon = "$LB->{on}";
   $mon .= "/$LB->{no_report}" if (!$REPORT{$file});
   my $url = &make_link($q, "host", $h->{hostname}, undef, $window);
   push(@report, ["host", $url, $sev, $h->{ipno},  $mon, $h->{time_added}, $err, $col]);
 }
 foreach my $dev (@$devs) {
    next if ($dev->{type} eq $renv->{solution}); # skip se2, se
    my $file = $dev->{type} . ":" . $dev->{key};
    my $mon = ($dev->{active} eq "Y") ? "$LB->{on}" : "$LB->{off}";
    $mon .= " <font color=red><small>($LB->{skipped} " . Util->get_today($dev->{skip}) . ")</small></font>" if ($dev->{skip});

    $mon .= "/$LB->{no_report}" if (!$REPORT{$file});

    if ($dev->{class} =~ /^switch/) {
       $sw++;
    } else {
       $st++;
    }
    my $label= $dev->{userLabel} || $dev->{type};

    next if (index($Report::EXCLUDE, ",$dev->{type},") >= 0);
    
    my $state = $DB->{$file};
    ($sev, $err, $col, $sev_no) = &sev($SEV, $DB, $file, $summ, $q);
    next if (!$sev_no && $summ == 0);
    
    my $url = &make_link($q, $dev->{type}, $dev->{key}, $dev->{name}, $window);
    push(@report, [$label, $url, $sev, $dev->{ipno},  $mon, $dev->{time_added}, $err, $col]);
 }
 my $f = "<font color=white>";
 my $f2 = "</font>";
 my($h1,$h2,$h, $links, $title);

 
 my $scr = Html::Screen->new({ });
 $scr->script("
  function win1(a, winname) {
   var b = '$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=2&topo=MERGE-MASTER&file=' + a;
   var O = window.open(b,winname,'menubar=no,resizable=yes,scrollbars=yes,width=550,height=700');
   O.focus();
  }
  ");
 $q->{SORT} = 3 if (!$q->{SORT});

 $scr->list($q, { title => $title ,  line2 => 6, colorRow => 8, 
               interactive => 1, pageSize => 2000 },
   [
   [ c => $LB->{type},     '+'],
   [ l =>  $LB->{name},    '+'],
   [ c =>  $LB->{health0}, '-'],
   [ l =>  $LB->{ip},      '+'],
   [ c =>  $LB->{mon},     '+'],
   [ l =>  $LB->{added},     '+'],
   ],
   \@report,
   );
  print $scr->out();
  $sw += 0; $ho += 0;
  my $reload_line;
  my $reload_but = Html::Screen->submitButton("ACTION_refresh",$LB->{submit_reload});
  if ($q->{ACTION_refresh}) {
     $reload_but = Html::Screen->submitButton("ACTION_stop",$LB->{stop_reload});
  }
  my $hidden = Html->makeHidden($q, "summary,ACTION_clear");
  print "
  <table border=0><tr><td></table>
  <form>
     $hidden
    <input type=hidden name=summary value=$summ>
    <input type=hidden name=GO value=GUI::DeviceReport::run>
    <b>";
  print $reload_but;
  if (!$deny) {
    print "<b>" . 
      Html::Screen->submitButton("ACTION_clear", $LB->{submit_ack});
  }
  print "</form>";
}

#
# DISPLAY ONE LINE PER ALARMS
#
sub alarmRun {
 my($q) = @_;
 my $deny = Roles->verifyRole($q, "admin");
 print Html->body();
 my $renv = System->get_renv();
 my $ruser = System->get_ruser();
 my $window = $ruser->{window} || $renv->{window};
 my $summ = $q->{summary};
 my $SEV  = $q->{severity};
 my $G    = Labels->read();
 my $LB   = Labels->read("GUI::AlertReport");
 my $NARROW = Http->isNarrow();
 my $extra;
 if (!$Http::EXTERNAL_IP) {
   if ($ENV{HTTP_HOST}) {
      $Http::EXTERNAL_IP = $ENV{HTTP_HOST};
      open(OO, ">/opt/SUNWstade/DATA/EXTERNAL_IP");
      print OO  "https://$Http::EXTERNAL_IP";
      close(OO);
   } else {
      $Http::EXTERNAL_IP = "hostname";
   }
 }
 foreach my $el (keys %$q) {
    $extra .= "&$el=$q->{$el}";
 }

 if ($q->{ACTION_delall}) {
   State->clearAll();

 } elsif ($q->{ACTION_ack} || $q->{ACTION_del}) {
   foreach my $e (keys %$q) {
      if (substr($e,0,4) eq "del_") {
         my $comp = substr($e,4);
         State->clearComponent($comp, 1);
      }
   }
 }
 # C=Customer, S=Service
 my $alarm_view = $q->{alarm_view} || ($renv->{solution} eq "N"? "S" : "C");
 my $alarm_view_s;
 my $view_title;

 if ($alarm_view eq "C") {
   $view_title   = $LB->{customer_view};
   $alarm_view_s = "<a href=/rashttp?GO=GUI::DeviceReport::alarmRun&alarm_view=S>$LB->{service_view}</a>";
 } else {
   $view_title   = $LB->{service_view};
   $alarm_view_s = "<a href=/rashttp?GO=GUI::DeviceReport::alarmRun&alarm_view=C>$LB->{customer_view}</a>";
 }
   
 my $all= "<a href=/rashttp?GO=GUI::DeviceReport::alarmRun>$G->{allsev}</a>" if (exists $q->{severity});

 my $SL  = State->sev_labels();
 my $sel_severity = $q->{severity} ?  $SL->[$q->{severity}] : $G->{all};

 print Html->header2( "alarms.alarms2", undef, undef, undef, 
     { noDoc => 1,          noTabs => $q->{noTabs}, 
       CNL   => $q->{CNL},  right  => $all , alarm_view => $alarm_view,
     });

 print "<script>
   function info2(a) {
      var b = '$Http::WEBPROC?GO=GUI::EventLog::info&event=' + a;
      var O = window.open(b,'linfo','menubar=yes,resizable=yes,scrollbars=yes,width=500,height=600');
      O.focus();
   }
   </script>
  ";

 my (%REPORT, %MAP);

 my($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read;

 State->cleanState($devs, $hosts);

 my $COMPS = State->components(); 
 my @report;
 if (!$q->{SORT}) {
   $q->{SORT} = 2;
   $q->{SIGN} = -1;
 }
 my $GIF = State->sev_gifs();
 my ($debug , $done);
 foreach my $el (keys %$COMPS) {
    my $val = $COMPS->{$el};
    next if ($val->[5] < 0);
    my $agg = $val->[5] + 0;
    #next if ($alarm_view eq "C" && $agg < 0);
    my($cat, $key, $topic) = split(/\:/, $el);
    my $sev0 = int($val->[0] + 0.5);
    my $sev_order = sprintf("%2.2d", $val->[0] * 10);
    next if ($q->{severity} && $sev0 != $q->{severity});
    next if ($sev0 <= 0);
    my $H    = State->eventHash($val->[4]);
    my $etype = $H->{EventType};
    my($cat0, $type) = split(/\./, $etype, 2);
    $type    =~ s/Event// if ($type ne "LogEvent");
    my $topic= $H->{Component} || $H->{Caption};
    $topic = "Enclosure" if ($topic eq "e");
    my $ip = $H->{SourceIP};
    my ($ix, $name);
    if ($H->{TargetName}) {
      $name = $H->{TargetName};
    } else {
      $name = $H->{Target};
      $ix   = index($name, ":");
      $name = substr($name, $ix+1) if ($ix > 0);
    }
    my $grid = $H->{GridCode};
    my $ix   = index($name, "(");
    $name    = substr($name, 0, $ix) if ($ix > 0) ;
    my $name0 = $name;
    my $U = "$Http::WEBPROC?GO=GUI::Instr::rStart&host=*&file=$cat:$key&_name=$name0";
    my $sev = "<img src=/gif/$GIF->[$sev0] border=0 width=13 border=0>";

    $name    =~ s/\./. /;
    my $gcode= Grid->getNo($H->{GridCode});
    my $date = substr($val->[1], 0, 19);
    $date =~ s/\-/\//g;
    $topic =~ s/\./. /g;
    $topic =~ s/([^\s]{20}?)/$1 /g;
    $ix   = rindex($grid, ".");
    $topic .= " (" . substr($grid, $ix+1). ")" if ($type eq "Log" && $ix > 0);
    my $desc = substr($val->[1], 20);
    my $gurl = Grid->links($el, \$done);
    my $sel = $NARROW ? "" : "<input type=checkbox name=del_$el>";

    push(@report, [$sel, "<val $sev_order>$sev", "[ $gurl ]", $name, $date,  $topic, "<small> $desc" ]);
 }

 
 my $scr = Html::Screen->new({ });
 my $hidden = Html->makeHidden($q, "ACTION_ack,ACTION_del");
 $scr->script("
  function win1(a, winname) {
   var b = '$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=2&topo=MERGE-MASTER&file=' + a;
   var O = window.open(b,winname,'menubar=no,resizable=yes,scrollbars=yes,width=550,height=700');
   O.focus();
  }
  ");
  $scr->add("
  <table border=0><tr><td> 
   <form><input type=hidden name=GO value=GUI::DeviceReport::alarmRun>
   $hidden
  </table>
  ");
 
 my($sel_lb, $sev_lb, $line2);

 if ($NARROW) {
   $sel_lb = "" ;
   $sev_lb = "Sev.";
   $line2  = "5,1";
 } else {
   $sel_lb = $LB->{sel};
   $sev_lb = $LB->{sev};
 }
 my @cols = (
   [ c => $sel_lb            ],
   [ c => $sev_lb  , '+'     ],
   [ l => $LB->{details},'+'  ],
   [ l => $LB->{device},'+'  ],
   [ c => $LB->{date} , '+'  ],
   #[ c => $LB->{type}, '+'  ],
   [ c => $LB->{topic}, '+'  ],
   );

 push(@cols, [ l => $LB->{desc} ]) if (!$NARROW);

 $scr->list($q, { title => "$LB->{al_title} : $sel_severity" , 
                  empty => $LB->{no_alarm}, pageSize => 22,
                  line2 => $line2,
                   interactive => 1,  },
   \@cols,
   \@report,
   [
#    [ l => "ACTION_ack", $LB->{ack} ],
    [ l => "ACTION_del", $LB->{del_sel} ],
    [ l => "ACTION_delall", $LB->{del_all} ],
   ]
   );
  $scr->add("</form>");
  print $scr->out();

}

#  'power.u2pcu2.fruPowerFan1State' => [
#    2,
#    '2003-09-09 13:06:28 The state of \'power.u2pcu2.fruPowerFan1State\' on sp-87-array01 is \'fault\' ',
#    'sp-87-array01 (ip=172.20.67.210)',
#    '0',
#    'EventType=6120.AlarmEvent|Target=6120:0x301.5016338.400176|TargetName=sp-87-array01 (ip=172.20.67.210)|Caption=M.power.u2pcu2.fruPowerFan1State|Component=power.u2pcu2|Actionable=TRUE|GridCode=6120.AlarmEvent-.power.fan|SourceIP=172.20.67.210|Severity=2|PriorState=|CurrentState=|CurrentValue='
#  ],


my @GIF = (  "&nbsp;", # <ximg src=/gif/al_ok.gif alt=OK>",
             "<img src=/gif/al_alert.gif width=13  alt=Warning border=0>",
             "<img src=/gif/al_crit.gif width=13  alt=Error border=0>",
             "<img src=/gif/al_down.gif width=13  alt=Critical border=0>",
             );

sub sev {
  my($SEV, $DB, $k, $summ) = @_;
  my $state = $DB->{$k};
  my $sev = int($state->[0]+0.5);
  return () if ($SEV && $sev != $SEV);
  my ($col, $b);
  if ($sev >= 1) {
     $b = "<b>";
  }
  my $d = "<small>$state->[1]" if ($state->[1] && $summ == 1);
  return ("<xx $sev>$b$GIF[$sev]", $d, $col, $sev);
}

1;

