package GUI::Config;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use Html::Screen;
use strict;
use Agent;

#  $Id: Config.pm,v 1.27 2004/01/11 05:38:04 mckenney Exp $
sub test {
  my($q, $post) = @_;
  print Html->body();
  print "test";
}
  

sub site {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my $deny = Roles->verifyRole($q, "admin");
  my $ret = 0;
  print Html->body();
  print Html->header2("admin.gen_maint.site_info");

  my $G = Labels->read();
  my $L = Labels->read('GUI::Config')->section('site');

  my($error);
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  $info = "";
  my($warn2, $warn3, $cat);

  if ($q->{ACTION_submit}) {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
     if ($err1) {
       $info = Html->error($G->{e_108});
       $err1 = "<font color=red>$err1</font>";
     }
     if (!$q->{customer}) {
       print Html->error($G->{e_109});
       $err5 = "<font color=red>$G->{mandat}</font>";
     }
     $q->{site_state} = uc($q->{site_state});
     if (!$q->{site_name} || !$q->{site_city} || !$q->{site_country} || 
         !$q->{site_zip} || !$q->{site_contact} || !$q->{site_email}
          ) {
       print Html->error($L->{err_1});
       $err8 = "<font color=red>$G->{e_110}</font>";
     }
     goto err2 if ($err1 ||  $err5 || $err8);
     $q->{site_country} = "USA" if (! $q->{site_country});

     my $loop = 0;
     my @okchars = (".,-_'",   # customer
                    ",-",      # site_name
                    ".-\#,",   # address
                    " ",       # city
                    " ",       # state
                    "-",        # zip
                    ".,-_' ",   # contact
                    "\_\-\.\@", # email
                    " ",        # country
                    "().-",      # phone
                    );

     my $valid;
     if ($q->{ticker} && $q->{ticker} !~ /^\w+$/) {
          $valid .= $L->expand('err_9', "ticker") . "<br>";
     }
     for my $v ('customer', 'site_name', 'site_address',
                'site_city', 'site_state', 'site_zip', 'site_contact',
                'site_email', 'site_country',  'site_contact_phone',
                'contract' ) {
        $q->{$v} = Util->trim($q->{$v});
        if (my $bad = &charbad($v, $q->{$v}, $okchars[$loop])) {
           $valid .= $L->expand('err_10', $v, $bad) . "<br>";
        }
        $loop++;
     }
     print Html->warning($valid) if ($valid);

     for my $v ('customer','cust_no','site_name','site_address','site_city',
             'site_state', 'site_zip','site_contact','site_email','site_country',
              'site_contact_phone',
             'contract', 'ticker' ) {
        $renv->{$v}    = $q->{$v};
     }
     $renv->{role}     = "M";
     $renv->{admin_email} = $renv->{site_email};
     $renv->{hostname} = System->hostname();

     if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
        print "$G->{e_100}<br>";
     } else {
        $info = Html->info($G->{conf_upd});
     }

  } else {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

     if ($renv->{logfile} && !-f $renv->{logfile}) {
       $warn3 = "<br><font color=red>$G->{cannot_find} $renv->{logfile}";
     }
  }

err2:
  if ($err1 || $err5 || $err8) {
    foreach my $x ('cust_no','contract',
                'site_city', 'site_state', 'site_country', 'site_zip',
                'site_contact', 'site_email','site_address','site_name',
                'customer','ticker','contract') {
       $renv->{$x} = $q->{$x} 
    }
  }

  my $pings = $renv->{ping};
  $pings =~ s/\|/\n/g;
  $pings =~ s/\#/  #/g;
  
  my ($x, $ind_list);
  $ind_list = "=[ Select ]|";
  for ($x=1; $x <= 22; $x++) {
    $ind_list .= $L->{"industry_$x"} . "|";
  }
  my $industry = Html->makeSelect("site_industry",$ind_list, $renv->{"site_industry"});

  my $man = "<font size=+3 color=red><b>*</b></font>";
  my $o;
  print "<form><input type=hidden name=GO value=GUI::Config::site>";

  my $scr = Html::Screen->new();
  my $cust_label = $renv->{solution} eq "N" ? $L->{l3} : $L->{serial_no};
  $err8 = "$err8<br>" if ($err8);

  $scr->table({error => "$info\n$error"  },
  [
   [l => "&nbsp;$L->{l1}"],
   [f =>  "$L->{l2}",
         "<input type=text name=customer size=40  maxlength=60 value=\"$renv->{customer}\">$man <font color=red><b>$G->{mandat}</b></font> " ],
   [f => $cust_label,
         "<input type=text name=cust_no size=20 maxlength=20 value=\"$renv->{cust_no}\">" ],
   [f => $L->{l4},
         "<input type=text size=20 maxlength=20 name=contract value=\"$renv->{contract}\">",1 ],
   [f => $L->{l5},
         "<input type=text name=ticker size=10  maxlength=20 value=\"$renv->{ticker}\">" ,2],
   [l => "&nbsp;$L->{l6}"],
   [f => $L->{l7},
         "$err8<input type=text size=40 maxlength=60 name=site_name value=\"$renv->{site_name}\"> $man" ],
   [f => $L->{l8},
         "<input type=text size=30 maxlength=50 name=site_address value=\"$renv->{site_address}\">" ],
   [f => $L->{l9},
         "<input type=text size=30 maxlength=50 name=site_city value=\"$renv->{site_city}\">$man" ],
   [f =>  $L->{l10},
         "<input type=text size=10 maxlength=20 name=site_state value=\"$renv->{site_state}\">" ,1],
   [f =>  $L->{l11}, 
         "<input type=text size=15 maxlength=20 name=site_zip value=\"$renv->{site_zip}\">$man" ,2],
   [f => $L->{l12},
         "<input type=text size=30 maxlength=50 name=site_country value=\"$renv->{site_country}\">$man" ],
   [f => $L->{l13},
         "<input type=text size=30 maxlength=50 name=site_contact value=\"$renv->{site_contact}\">$man"],
   [f => $L->{l14},
         "<input type=text size=20 maxlength=40 name=site_contact_phone value=\"$renv->{site_contact_phone}\">",1 ],
   [f => $L->{l15},
         "<input type=text size=30 maxlength=50 name=site_email value=\"$renv->{site_email}\">$man", 2],

   ]);

   $scr->button2( [
      [ l => 'ACTION_submit', $G->{submit}, $deny ],
      ]);
   $scr->add("</form>");
   print $scr->out();
}

sub upd {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Config');
  my $renv = System->get_renv();


  my($error);
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  $info = "";
  my($categories) = Agent->findSelectableAgents($renv->{solution});
  my($warn2, $warn3, $cat);
  if ($q->{permanent}) {
     unlink System->get_home() . "/DATA/ALTACTIVE";
     unlink System->get_home() . "/DATA/MASTER";
     my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
     $renv->{role} = "M";
     PDM::ConfigFile->write( $renv, $devs, $hosts, $notifs);

     print Html->info("This is now a Permanent-Master");
  }
  my $no_cat;
  if ($q->{ACTION_b}) {
      require GUI::Hosts;
      GUI::Hosts::list($q);
      return;

  } elsif ($q->{ACTION_s}) {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
     for my $v ('logfile','t300logfile') {
        $q->{$v} =~ s/[\n\r]/ /g;
        $q->{$v} =~ s/\s+/ /;
     }
     if ($q->{t300logfile}) {
       my @l = split(/\s+/ , $q->{t300logfile});
       foreach my $f (@l) {
         if (!-f $f) {
           $warn2 = "<br><font color=red>". $G->expand('e_112',  $f) . "</font>";
         }
       }
     }
     $q->{logfile} = "/var/adm/messages";
     if ($q->{logfile} && !-f $q->{logfile}) {
       $warn3 = "<br><font color=red>" . $G->expand('e_112', $q->{logfile});
     }
     my $cat = "";
     foreach my $m (@$categories) {
        my(@bb) = split(/=/, $m);
        $cat .= "$bb[0]|"  if ($q->{$bb[0]});
     }
     chop($cat) if ($cat);
     if (!$cat) {
       $no_cat = Html->warning($L->expand('host_upd.err_2'));
       #$err6 = "<font color=red>$G->{mandat}</font>";
     }

     #goto err2 if ($err6);

     if ($renv->{solution} eq "N") {
       for my $v ('logfile','t300logfile', 'dsp_logfile') {
          $renv->{$v}    = $q->{$v};
       }
     }
     $renv->{show_monitored_only} = $q->{show_monitored_only}? "Y":"N";
     $renv->{skip_luxadm} = $q->{skip_luxadm} ? 1 : 0;
     $renv->{hostname} = System->hostname();
     if ($renv->{frequency} ne $q->{frequency}) {
        &main::log_change($L->expand('host_upd.err_3', $renv->{frequency}, $q->{frequency}));
     }
     $renv->{frequency}   = $q->{frequency} || 5;

     if ($renv->{categories} ne $cat) {
        &main::log_change($L->expand('host_upd.err_4',$renv->{categories}, $cat));
     }
     $renv->{categories} = $cat;

     if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
        print $G->expand('e_100');
     } else {
        $info = Html->info($G->{conf_upd}, 0);
     }

  } else {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

     if ($renv->{logfile} && !-f $renv->{logfile}) {
       $warn3 = "<br><font color=red>Warn: Cannot find $renv->{logfile}";
     }
  }

err2:
  if ($err6) {
    foreach my $x ('frequency','production') {
       $renv->{$x} = $q->{$x} 
    }
    $cat = "";
    foreach my $m (@$categories) {
      my(@bb) = split(/=/, $m);
      $cat .= "$bb[0]|"  if ($q->{$bb[0]});
    }
    $renv->{categories} = $cat;
  }
  print Html->header2('admin.gen_maint.maintain_hosts');

  my $frequency = Html->select_frequency($renv);
  my $pings = $renv->{ping};
  $pings =~ s/\|/\n/g;
  $pings =~ s/\#/  #/g;
  my($modules_html) = "<table border=0 cellspacing=2 width=100%><tr>";
  my $cnt = 0;
  foreach my $mod (@$categories) {
     $modules_html .= "</td><td valign=top>" if ($cnt++ % 9 == 0);
     my(@bb) = split(/=/, $mod);
     my($ck) = "checked" if (index("|$renv->{categories}|", "|$bb[0]|") >= 0);
     $modules_html .= "<input type=checkbox name=$bb[0] $ck>:$bb[1]<br>";
  }
  $modules_html .= "</table>";

  my $skip_luxadm = ($renv->{skip_luxadm} == 1) ? "checked":"";

  my $man = "<font size=+3 color=red><b>*</b></font>";
  my $ck2 = ($renv->{show_monitored_only} eq "Y") ? "checked":"";
  my $o;
  my $lb1 = $L->expand('host_upd.l1');
  my $active = Util->file2string("ALTACTIVE");
  my $alt;
  if ($active) {
    my $u1 = "<a href=$Http::WEBPROC?GO=GUI::Config::upd&permanent=1>" .
                  $L->{'host_upd.alt_master2'} . "</a>";
    $alt = "<tr><td bgcolor=$Style::LIGHT align=right>$L->{'host_upd.alt_master'}:</td>
    <td colspan=3>$L->{'host_upd.alt_master1'} $u1
    ";
  }
  
  my $scr = Html::Screen->new();
  $scr->add("<form> <input type=hidden name=GO value=GUI::Config::upd>");
  $scr->script("
   function win1(a) {
     var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
     O.focus();
   }  
   ");
  my($array_text, $dsp_entry);

  if ($renv->{solution} eq "N") {
    $array_text = "<textarea name=t300logfile cols=50 rows=3 wrap=virtual>$renv->{t300logfile}</textarea> $alt";
    $dsp_entry = undef;
  } else {
    $array_text = $renv->{t300logfile};
    $dsp_entry = [ f => $L->{'host_upd.dsp'}, $renv->{dsp_logfile} ];
  }

  my $js = "<br><a href=javascript:win1()>$L->{'host_upd.l4'}";
  $scr->table({error => "$info $warn2 $error", labelWidth => "35%" },
  [
   [l => $lb1 ],
   [f => $L->{'host_upd.l2'}, "$renv->{hostname} $renv->{solution_model}" ],
   [f => $L->{'host_upd.l3'} . $js,  "$no_cat$modules_html" ],
   [f => $L->{'host_upd.l5'} , $frequency ],
   [f => $L->{'host_upd.l7'} , "<input type=checkbox name=skip_luxadm $skip_luxadm>"],
   [f => $L->{'host_upd.l8'} , "<input type=checkbox name=show_monitored_only $ck2>" ],
   [l => $L->{'host_upd.l9'} ],
   [f => $L->{'host_upd.l10'}, $renv->{logfile} ],
   $dsp_entry,
   [f => $L->{'host_upd.l11'}, $array_text ], 
  ]);

   $scr->button2([
      [ l => 'ACTION_s', $G->{submit} , $deny ],
      [ l => 'ACTION_b', $G->{back}, $deny ],
      ]);
   $scr->add("</form>");
   print $scr->out();
}


sub charbad  {
   my ($v, $str, $allow) = @_;
   my $list;

   my @datastring = split( //, $str);
   my $bad = "!\@#\$%^&\*()_+|~-=\\\`{}[]:\";\'<>\?,\.\/";

   foreach my $c1 (@datastring) {
      if (index($bad, $c1) >= 0 && index($allow, $c1) < 0) {
         $list .= $c1 if (index($list, $c1) < 0);
      }
   }
   return $list;
}

1;

