# iPort error in switch
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

package FCRules::Rule1;
use TO;
use Data::Dumper;
use FCRules;
use strict;

# WRITE
sub description { return "CRC go up on a switchPort" }

sub category    { return "CRC" }

sub run {
  my($class, $To, $hm, $report, $count, $key, $info, $reads, $writes, $fc_type ) = @_;

# |wwn|port.1|switch

  my($hba, $name, $port0, $type) = split(/\|/, $key);
  return(undef,undef) if ($type ne "switch"); # switch or vicom

  my($port) = substr($port0,5) + 0;

  my($sw) = $To->nodeByKey($name); 
  return(undef,undef) if (!$sw);
  
  my $source_type  = $sw->type();

  if (!$sw) {
    Debug->print2("FCRule: Cannot find $source_type $name in Topology");
    return ();
  }
  
  my($sw_info) = $sw->{info};

  my $port_info  = $sw->{portInfo};
  my $port_type = $port_info->[$port]{sw_PortType};

  my $rn = $port_info->[$port]{RegisterName};

  my $links  = $sw->{port};
  my $link  = $links->[$port];

  my($ltype, $lname, $pno) = split(/:/, $link);

  my $target = $To->nodeByName("$ltype:$lname");
  return undef if (!$target);

  my $target_type = $target->type();

  if (!$target) {
     Debug->print2("Rule1: cannot find target: $ltype:$lname");
     return ();
  }

  my($level, $cnt, $desc, $mins) = Thresholds->test("${fc_type}counters","rule1",
                                     $port , $count, $name);
  $mins = 1 if (!$mins);

  if ( $level eq "E") { # error level threshold fired

    my $target_ports = $target->{portInfo};
    my $target_label = $target->portLabel($pno);
  
    my $target_port = $target_ports->[$pno];
 
    my $short = $target->{info}{name};

    my $id    = $target->id();
    my($desc) = "$fc_type-ERROR ($cnt in $mins mins): ".
                "Detector: port $port on '" . $sw->id() . 
                  ", Link: $target_label on '" . $target->id();

    my($CIMKey1, $CIMKey2, $key1, $key2);

    $key1    = $target->name() . ":$pno";
    $key2    = $sw->name()     . ":$port";

#   key1 is the probable origin of the problem.

    $hm->linkEvent( $report, $ltype,  $key1, $source_type, $key2, $desc, $reads, $writes, 
                    $hba, $fc_type, $sw->id());
  }
  return ("FC", "");
}

1;


