package EventDB;
use strict;
use System;
use Message;
use RasDB;
use vars qw ($EVENTS);

sub write {
  my($class, $ed ) = @_;

  my $ev = $ed->instances(0);
  return if ($ev->value("Severity") == 0);

  $EVENTS = RasDB->new("EVENTS");
  my $hash = $EVENTS->{hash};

  
  my $eventid = $ev->value("EventId");
  my $data = {};
  foreach my $e ('EventId',   'EventType','Severity',   'Actionable',
                 'Caption',   'Component','Description','Target',
		 'TargetName','SourceIP', 'GridCode',   'GridNo',
		 ) {
     $data->{$e} = $ev->value($e);
  }
  my $Data = $ev->value("Data");
  $data->{Data}      = $Data if (index($Data, "#INSTRUMENTATION_REPORT") < 0);
  $data->{aggregate} = $ed->id("aggregate");
  $data->{agg_list}  = $ed->id("agg_list");
  $data->{EventTime} = Message->eventTime0($ev->value("EventTime"));

  $EVENTS->Lock();

  my $info = $hash->{INFO} || {};
  $info->{count}++;
  $hash->{INFO} = $info;

  $hash->{$eventid} = $data;

  $EVENTS->UnLock();
}

# 
# keep only 10 days
# 
sub clean {
  my($class, $max) = @_;
  $EVENTS = RasDB->new("EVENTS");
  my $hash = $EVENTS->{hash};
  $EVENTS->Lock();
  my $now = time;
  my $week = 60 * 60 * 24 * $max;
  my($k,$v);
  while (($k,$v) = each %$hash) {
     my($t1, $rest) = split(/\./, $k);
     if ( $now - $t1 > $week ) {
	 delete $hash->{$k};
     }
  }
  $EVENTS->UnLock();
}

#
# RETURN Devices-Involved and SUB-Events
#
sub sub_events {
  my($class, $ed_list, $html, $skip_grid) = @_;

  my ($data, $involved, $sub_events);
  my ($ALL, %TRACK_CODE, $dcnt);

  $EVENTS = RasDB->new("EVENTS");
  my $hash = $EVENTS->{hash};
  $EVENTS->ReadLock();
  my $G = Labels->read();
  my $done = 0;

  foreach my $e_id (split(/,/, $ed_list) ) {
     my $ev     = $hash->{$e_id};
     my $sev2   = $ev->{Severity};
     my $desc   = $ev->{Description};
     my $comp   = $ev->{Component} || $ev->{Caption};
     my $caption= $ev->{Caption};
     my $etype  = $ev->{EventType};
     my $g_no   = $ev->{GridNo};
     my $g_code = $ev->{GridCode};
     my @edata  = split(/\n/, $ev->{Data});
     $dcnt++;

     my($etype0, $etype1) = split(/\./, $etype);

     $desc =~ s/[\n\r]/ /g;
     my $ta = $ev->{Target};
     if (index($ALL, $ta) < 0) {
        $involved .= " $etype0 " . ($ev->{TargetName} || $ta) . "\n";
        $ALL .= ",$ta";
     }
     my $text = $G->{'sev' . int($sev2+0.5)};

     $sub_events .= "<b>" if ($html);
     $sub_events .= "\n$dcnt) " . $ev->{EventTime} . 
                    " [$text, $etype.$comp, $g_no]\n";
     $sub_events .= "</b>" if ($html);
     $sub_events .= "$desc\n";
     if (substr($desc,-1) eq ":") {
       my $x2;
       for ($x2 = 0; $x2 < 10; $x2++) {
          $sub_events .= "  $edata[$x2]\n" if ($edata[$x2]);
       }
       $sub_events .= "...\n" if ($#edata >= 10);
     }
     if (!$skip_grid && !$done) {
        my $grid_info  = Grid->getInfoString($etype, $caption, $g_code);
        $done = 1;
        if ($grid_info) {
          $grid_info =~ s/\n/\n>  /g;
          $sub_events .= ">  $grid_info\n";
        }
     }
  }
  $EVENTS->UnLock();
  return ($involved, $sub_events);
}


1;
