package Client::Discovery;
use Agent::HOST;
use Client;
use Debug;
use strict;

sub help {
  print Client->http_OK();
  print "#<pre>\n";
  print <<EOF;
 Http Syntax:

 http://<host>:7654/rashttp?GO=Client::Discovery::list&format=xml|tab

agent.0.hostid  80a3738d
agent.0.hostname        indy-90.ebay.sun.com
agent.0.ipno    129.147.50.117
agent.0.agent_version   2.2.I0.000
agent.0.role    M
agent.0.solution_model  6960
agent.1.hostid  83104545
agent.1.hostname        indy-156.ebay.sun.com
agent.1.ipno    10.4.56.156
agent.1.agent_version   2.1.05.002
agent.1.role    AM
agent.1.solution_model  3910
EOF
}


sub ProbeLocal {
  my($q) = @_;
  my $format = $q->{format} || "tab";

  my $startFile = System->get_home() ."/DATA/start";

  if (! -f $startFile){
    print Client->error($format, 100, "Agent not started.");
    return;
  }

  my $command =  System->get_home() . "/bin/ras_admin discover_inband >> /dev/null 2>&1 &";
  Debug->logLine("Client::Discovery::ProbeLocal $command");

  if (system($command) == 0){
    print Client->http_OK();
    print "OK";
    return;
  }
  print Client->error($format, 101, "Error running discover command. " . $?);
}


sub list {
  my($q) = @_;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

  print Client->http_OK();
  my $hostid = System->hostid();
  my $ip     = Util->name2ip();
  my $cnt = 0;
  my (%Ports, $not, $con);
  Agent::HOST->readPorts(\%Ports);
  foreach my $l (keys %Ports) {
    if ($Ports{$l} =~ /NOT/) {
       $not++;
    } else {
       $con++;
    }
  }

  if ($q->{format} eq "xml") {
    print <<EOF;
<?xml version ="1.0"?>
<DISCOVERY_REPORT>
  <AGENT ID="0">
     <VALUE ID="hostid">$hostid</VALUE>
     <VALUE ID="hostname">$renv->{hostname}</VALUE>
     <VALUE ID="ipno">$ip</VALUE>
     <VALUE ID="agent_version">$renv->{version}</VALUE>
     <VALUE ID="role">$renv->{role}</VALUE>
     <VALUE ID="solution_model">$renv->{solution_model}</VALUE>
     <VALUE ID="ports_connected">$con</VALUE>
     <VALUE ID="ports_notconnected">$not</VALUE>
  </AGENT>
EOF
    foreach my $h (@$hosts) {
       $cnt++;

       print <<EOF;
  <AGENT ID="$cnt">
     <VALUE ID="hostid">$h->{hostid}</VALUE>
     <VALUE ID="hostname">$h->{hostname}</VALUE>
     <VALUE ID="ipno">$h->{ipno}</VALUE>
     <VALUE ID="agent_version">$h->{version}</VALUE>
     <VALUE ID="role">$h->{role}</VALUE>
     <VALUE ID="solution_model">$h->{solution_model}</VALUE>
  </AGENT>
EOF
    }
    print "</DISCOVERY_REPORT>\n";

  } else {
    print "#<pre>\n";

    print <<EOF;
agent.0.hostid\t$hostid
agent.0.hostname\t$renv->{hostname}
agent.0.ipno\t$ip
agent.0.agent_version\t$renv->{version}
agent.0.role\t$renv->{role}
agent.0.solution_model\t$renv->{solution_model}
agent.0.ports_connected\t$con
agent.0.ports_notconnected\t$not
EOF
    foreach my $h (@$hosts) {
     $cnt++;

    print <<EOF;
agent.$cnt.hostid\t$h->{hostid}
agent.$cnt.hostname\t$h->{hostname}
agent.$cnt.ipno\t$h->{ipno}
agent.$cnt.agent_version\t$h->{version}
agent.$cnt.role\t$h->{role}
agent.$cnt.solution_model\t$h->{solution_model}
EOF
    }
    print "#Done.\n";
  }
}


  
1;
