package Client::Control;
use Client;
use strict;
use Events;
use Debug;
use Util;

use vars qw ($PRO);

$PRO = "|sae|sunmc|nsm|ssrr|netconnect";

#
# Agent control for ESM health control
#
sub Agent {
  my($q) = @_;
  my $command = $q->{command};
  my $format = $q->{format} || "tab";
  my $key    = $q->{key};
  my $startFile = System->get_home() ."/DATA/start";

  Debug->logLine("Client::Control::Agent $command $key");

# If key then enable/disable a single device on the agent.
  if ($key){
    my($type, $key) = split(/\:/, $key);
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    foreach my $d (@$devs) {
      if ($type eq $d->{type}) {
	if ($key eq $d->{key}){
	  if ($command){
	    if ($command eq "start") {
	      $d->{active} = "Y";
	    }
	    elsif ($command eq "stop") {
	      $d->{active} = "N";
	    }
	    else {
	      print Client->error($format, 101, "Unknown Command [$command]");
	      return;
	      PDM::ConfigFile->write( $renv, $devs,
				      $hosts,$notifs);}
	  }
	  print Client->http_OK();
	  if ( "Y" eq $d->{active} ){
	    print "OK start\n";
	  }
	  else {
	    print "OK stop\n";
	  }
	  return;
	}
      }
    }
  }

# Do agent instead of a single device on the agent.
  if ($command){
    if ($command eq "start") {
      open(O, ">" . $startFile);
      print O "Y";
      close(O);
    }
    elsif ($command eq "stop") {
      unlink $startFile;
    }
    elsif ($command eq "lock") {
      if (-f $startFile){
	unlink $startFile;
	my $exit_value  = system "ps -e | grep rasagent >> /dev/null 2>&1";
	if (0 eq $exit_value){
	  open(O, ">" . $startFile);
	  print O "Y";
	  close(O);
	  print Client->error($format, 102, 
			      "Agent busy");
	  return;

	}
      }
    }
    else {
      print Client->error($format, 101, "Unknown Command [$command]");
      return;
    }
  }

  print Client->http_OK();
  if (! -f $startFile){
    print "OK stop\n";
  }
  else {
    print "OK start\n";
  }
}

#
# Uncontracted command to read environment for StorADE
#
sub GetEnv {
  my($q) = @_;
  my $format = $q->{format} || "tab";

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();

  print Client->http_OK();
  print "#<pre>\n";

  foreach my $x (sort keys %$renv) {
    print "$x\t$renv->{$x}\n";
  }

  foreach my $prop (@$renv) {
    print $prop;
  }
  print "#done";
}

#
# Uncontracted command to set an environment variable for StorADE
#
sub SetEnv {
  my($q) = @_;
  my $format    = $q->{format} || "tab";
  my $propname  = $q->{name};
  my $propvalue = $q->{value};
  my $command   = $q->{command} || "set";

  if (!$propname) {
    print Client->error($format, 100, "Missing argument [name]");
    return;
  }

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();

  if ("$command" eq "set"){
    if (!$propvalue) {
      print Client->error($format, 101, "Missing argument [value]");
      return;
    }
  }
  else {
    if ($renv->{$propname}){
      delete $renv->{$propname};
    }
  }

  $renv->{$propname} = $propvalue;
  PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);

  print Client->http_OK();
  print "OK";
}

#
# Commands for getting and setting site info.
#
sub SiteInfo {
  my($q) = @_;
  my $format = $q->{format} || "tab";
  my $command = $q->{command} || "list";

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();

  if ("$command" eq "update") {
    if ($q->{customer}){
      $renv->{customer} = $q->{customer};
    }
    if ($q->{contract}){
      $renv->{contract} = $q->{contract};
    }
    if ($q->{ticker}){
      $renv->{ticker} = $q->{ticker};
    }
    if ($q->{cust_no}){
      $renv->{cust_no} = $q->{cust_no};
    }
    if ($q->{site_name}){
      $renv->{site_name} = $q->{site_name};
    }
    if ($q->{site_address}){
      $renv->{site_address} = $q->{site_address};
    }
    if ($q->{site_city}){
      $renv->{site_city} = $q->{site_city};
    }
    if ($q->{site_state}){
      $renv->{site_state} = $q->{site_state};
    }
    if ($q->{site_zip}){
      $renv->{site_zip} = $q->{site_zip};
    }
    if ($q->{site_country}){
      $renv->{site_country} = $q->{site_country};
    }
    if ($q->{site_contact}){
      $renv->{site_contact} = $q->{site_contact};
    }
    if ($q->{site_contact_phone}){
      $renv->{site_contact_phone} = $q->{site_contact_phone};
    }
    if ($q->{site_email}){
      $renv->{site_email} = $q->{site_email};
    }
    if ($q->{production}){
      $renv->{production} = $q->{production};
    }

    PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
  }

  print Client->http_OK();
  if ("$format" eq "tab"){
    print "#<pre>\n";
    print "customer\t$renv->{customer}\n";
    print "contract\t$renv->{contract}\n";
    print "ticker\t$renv->{ticker}\n";
    print "cust_no\t$renv->{cust_no}\n";
    print "site_name\t$renv->{site_name}\n";
    print "site_address\t$renv->{site_address}\n";
    print "site_city\t$renv->{site_city}\n";
    print "site_state\t$renv->{site_state}\n";
    print "site_zip\t$renv->{site_zip}\n";
    print "site_country\t$renv->{site_country}\n";
    print "site_contact\t$renv->{site_contact}\n";
    print "site_contact_phone\t$renv->{site_contact_phone}\n";
    print "site_email\t$renv->{site_email}\n";
    print "production\t$renv->{production}\n";
    print "#done";
  }
}

#
# Make this storade a slave to a master at the given ip address
#
sub setMaster {
  my($q) = @_;
  my $command = $q->{command};
  my $ip = $q->{ip};
  my $format = $q->{format} || "tab";

  if ($command eq "slave"){
    if (!$ip){
      print Client->error($format, 102, "Missing argument [ip]");
      return;
    }

    if (open(O, ">" . System->get_home() . "/DATA/MASTER")) {
      print O "$ip";
      close(O);
      print Client->http_OK();
      print "OK\n";
    } else {
      print Client->error($format, 103, "Cannot write to MASTER: $!");
    }
  }
  elsif ($command eq "master") {
    unlink System->get_home() . "/DATA/MASTER";
    print Client->http_OK();
    print "OK";
  }
  elsif ($command eq "push") {
    my $cli =  System->get_home() . "/bin/ras_admin push_config >> /dev/null 2>&1 &";
    Debug->logLine("Client::Agent::setMaster $cli");
    system($cli);

    print Client->http_OK();
    print "OK";
  }
  else {
    print Client->error($format, 101, "Unknown Command [$command]");
    return;
  }
}


sub getProviderSettings {
  my($q) = @_;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

  print Client->http_OK();
  if ($q->{format} eq "xml") {
     print <<EOF;
<?xml version ="1.0"?>
<PROVIDER_REPORT>
EOF
    my %P;
    foreach my $x (sort keys %$renv) {
       if ($x =~ /pro\.([^\.]+)\./) {
          $P{$1} = 1;
       }
    }
    foreach my $pro (sort keys %P) {
       next if (!$pro);
       print "  <PROVIDER ID=\"$pro\">\n";
       foreach my $x (sort keys %$renv) {
          my @l = split(/\./, $x);
          next if ($l[2] eq "maxsize");
          if ($l[0] eq "pro" && $l[1] eq $pro) {
            print "    <VALUE ID=\"$l[2]\">$renv->{$x}</VALUE>\n";
          }
       }
       print "  </PROVIDER>\n";
    }
    print "</PROVIDER_REPORT>\n";

  } else {
    print "#<pre>\n";
    foreach my $x (sort keys %$renv) {
       my @l = split(/\./, $x);
       next if (index($PRO, $l[1]) < 0);

       if (substr($x,0,4) eq "pro.") {
          print "$x\t$renv->{$x}\n";
       }
    }
    print "#Done.\n";
  }
}

#
#  provider=srs|sunmc|netconnect|http
#  active=Y/N
#  ip=ipnumber
#  frequency=6 (hours hb)

sub setProviderSettings {
  my($q) = @_;
  my $VALID     = "|sunmc|sae|";
  my $provider  = $q->{provider};
  my $active    = $q->{active};
  my $frequency = $q->{frequency};
  my $ip        = $q->{ip};

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

  if (index($VALID, "|$q->{provider}|") < 0) {
     print Client->error($q->{format}, 301, "Invalid provider ($VALID)");
     return;
  }
  $renv->{"pro.$provider.active"}    = uc($active);
  $renv->{"pro.$provider.ip"}        = $ip       if ($ip);
  $renv->{"pro.$provider.frequency"} = $frequency +0 if (exists $q->{frequency});
  if ($provider eq "sae") { 
    $renv->{"pro.$provider.components"} = $q->{components} if ($q->{components});
    $renv->{"pro.sae.format"}           = 1 if ($q->{format} ne "xml"); # tabs
  }

  PDM::ConfigFile->write( $renv, $devices, $hosts, $notifs);
  Events->saveEvent("PRO", $provider, $active, 
                    $ENV{REMOTE_USER} || $ENV{REMOTE_ADDR} || "unknown" );

  print Client->http_OK();
  if ($q->{format} eq "xml") {
     print <<EOF;
<?xml version ="1.0"?>
<PROVIDER_REPORT>
   <PROVIDER ID=\"$provider\">
EOF
    foreach my $x (sort keys %$renv) {
       if ($x =~ /pro\.$provider\.(.*)/) {
         my $id = $1;
         print "    <VALUE ID=\"$id\">$renv->{$x}</VALUE>\n";
       }
    }
    print "  </PROVIDER>\n</PROVIDER_REPORT>\n";
  } else {
    print "#<pre>\n";
    foreach my $x (sort keys %$renv) {
       if ($x =~ /pro\.$provider\./) {
         print "$x\t$renv->{$x}\n";
       }
    }
    print "#Done\n";
  }

}




sub GetAlarms {
  my($q) = @_;
  my $format = $q->{format} || "tab";

  require State;
  my $State = State->read();
  my $Comp  = $State->hash();
  my $out;

  print Client->http_OK();
  if ( $q->{format} eq "xml"){
    print "<?xml version=\"1.0\"?>\n";
    print "<ALARMS>\n";
  }
  else {
     print "#<pre>\n";
  }

  foreach my $el (keys %$Comp) {
    my $comp = $Comp->{$el};
    foreach my $topic (keys %$comp) {
      my $sev = int($comp->{$topic}[0] + 0.5);
      my($type, $wwn) = split(/\:/, $el);
      my $desc = $comp->{$topic}[1];
      my $eh   = State->eventHash($comp->{$topic}[4]);
      my $out1;

      if ( $q->{format} eq "xml"){
	print "<event>\n";
   print "<type>$type</type>\n";
  print "<key>$wwn</key>\n";
  print "<topic>$topic</topic>\n";
  print "<severity>$sev</severity>\n";
  print "<desc>$desc</desc>\n";
  print "<eventType>$eh->{EventType}</eventType>\n";
  print "<deviceName>$eh->{TargetName}</deviceName>\n";
  print "<gridCode>$eh->{GridCode}</gridCode>\n";
  print "<ip>$eh->{SourceIP}</ip>\n";
print "</event>\n";
       } else {
          print "$type\t$wwn\t$topic\t$sev\t$desc\t$eh->{EventType}\t$eh->{TargetName}\t$eh->{GridCode}\t$eh->{SourceIP}\n";
       }
     }
  }
  if ( $q->{format} eq "xml"){
    print "</ALARMS>\n";
  }
  else {
     print "#DONE";
  }


}



sub providerHelp {

  print Client->http_OK();

  print <<EOF;
<pre>
GO=Client::Control::getProviderSettings

pro.ssrr.active = Y
pro.ssrr.frequency = 0
pro.ssrr.ip = 172.20.6.124

GO=Client::Control::setProviderSettings&provider=sae&active=Y&ip=1.1.1.1
GO=Client::Control::setProviderSettings&provider=sae&active=Y&ip=1.1.1.1&components=Y
GO=Client::Control::setProviderSettings&provider=srs&active=Y&ip=1.1.1.1
GO=Client::Control::setProviderSettings&provider=srs&active=N
EOF
}
  
1;
