package CIM;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: CIM.pm,v 1.2 2004/01/08 23:24:47 ccadieux Exp $

use Util;
use System;
use Date::Format;
use Time::Zone;
use NWS::Schema;
use vars qw($COUNT);

%MAP = (  S => 'string',   B => 'boolean',    I => 'uint16',
        I16 => 'uint32', I32 => 'uint32',    I64 => 'uint64',   E => 'uint32', 
          D => 'datetime', R => 'reference', SA => "string");

$VERSION = undef;

sub version {
  my($class, $v) = @_;
  $VERSION = $v if ($v);
  return $VERSION;
}

sub check_type {
  my($class, $type) = @_;
  return (index(",boolean,string,char16,uint8,sint8,uint16,sint16,uint32,sint32,uint64,sint64,datetime,real32,real64,stringarray,", ",$type,") >= 0) ;
}

# used by the simulator to fake a today date.

$CIM_TODAY = undef;

sub cim_set_today {
  my($class, $date, $offset) = @_;

  my($s) = $class->cim_date($date, $offset);
  $CIM_TODAY = $s;
}

sub cim_today {
  my($class) = @_;
  return $CIM_TODAY if ($CIM_TODAY);

  my($o) =  tz_local_offset();
  my $cnt = sprintf("%6.6d", $COUNT++);
  $o = sprintf("%+03d%02d", int($o / 3600), abs(int($o % 3600)));
  my($s) = Date::Format::time2str('%Y%m%d%H%M%S.' . $cnt, time) . $o;
  return $s;
}

sub tz {
  my($class) = @_;
  my($o) =  tz_local_offset();
  $o = sprintf("%+03d%02d", int($o / 3600), abs(int($o % 3600)));
  return $o;
}
  


#
# MM/DD/YY HH:MM

sub cim_date {
  my($class, $date, $offset) = @_;
  my($s);
  my($o) =  tz_local_offset();
  $o = sprintf("%+03d%02d", int($o / 3600), abs(int($o % 3600)));

  if (substr($date,0,1) eq "-" || substr($date,0,1) eq "+") {
     $offset = $date;
     $date = "";
  }
  if ($date) {
    my($m, $d, $y, $h, $min) = split(/[\/\- \:]/, $date);
    $y += ($y < 20) ? 2000:1900;
    $s = sprintf("%4.4d%2.2d%2.2d", $y, $m, $d);
    if (!$h) {
      $s .= "120000";
    } else {
      $s .= sprintf("%2.2d%2.2d00", $h, $min);
    }
    $s .= ".000000" . $o;
  } else {
    if (substr($offset,0,1) eq "+") {
       $offset = substr($offset,1);
       $time = time + ($offset * 24 * 60 * 60);
    } elsif (substr($offset,0,1) eq "-") {
       $offset = substr($offset,1);
       $time = time - ($offset * 24 * 60 * 60);
    } else {
       $time = time;
    }
    $s = Date::Format::time2str('%Y%m%d%H%M%S.000000', $time) . $o;
  }
  return $s;
}


1;


# 1;
#


__END__

=head1 NAME

CIM.pm - Utilities class for CIM:..


=head3 SYNOPSIS

 use CIM;

 CIM->check_type : validates a CIM type
 CIM->cim_today  : return a CIM date for today.



=head3 DESCRIPTION

Contains utilities for CIM



=head3 METHODS

=over 4

=item check_type();

validates the type

=item cim_today();

returns CIM date

=back



=head3 AUTHOR

 Christian Cadieux (ccadieux@central.sun)



=head3 COPYRIGHT

Copyright (c) 2000 Sun Microsystems

=cut
