package Agent::TRAPMESSAGE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name:  $ 
#  $Id: TRAPMESSAGE.pm,v 1.1 2003/11/25 04:43:25 ccadieux Exp $

use strict qw(vars);
use State;
use PDM::Parse;
use Report;
use Agent;
use base 'Agent';
use Policies;
use RasThread;

sub isSelectable { 0 }
sub revision     { '$Revision: 1.1 $'}
sub type         { Report::CAT_TRAPMESSAGE }
sub diskTotal    { 9    }

use vars qw( $ERR %FOUND %SAM_MAP @SAM_SEV);

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::TRAPMESSAGE');
  return $self;
}
use vars qw ($DONE);


sub RUN {
   my($agent, $static_list) = @_;
   my($err_lines, $warn_lines,  $out,$device, $connect_errs);
   my($report ,  $id, $lines, $log_err, $type);
   my( $wwn, $portWWN, $port2WWN);
   $DB::single = 1;
   my $type = uc($agent->type());
 
   my $processed_list = [];
 
   my $renv     = System->get_renv();
   my $logf     = $renv->{trap_logfile} || "/var/adm/trap_messages";
   my $warn_lines = [];
   my $ISP;
   $DONE = 1;

   if ($logf && -r $logf) {
       Debug->print1("Executing agent TRAPMESSAGE");
       Timelapse->start("trap:logfile");
       ($log_err, $lines) = $agent->read_log_file($logf,'NEW');  
       Debug->err('CANNOT_READ', $logf) if ($log_err);
       $agent->find_alert($lines, $device, \$ISP, $warn_lines);
       Timelapse->stop("trap:logfile");
   }
      
   my($name) = $renv->{hostname} || System->hostname();
   if ($#$warn_lines >= 0) {
      $id = {
            deviceName  => System->hostid(),
            active      => "Y",
            logFile     => $logf,
            display     => $name,
            name        => $name, 
            class       => "host",
            category    => Report::CAT_TRAPMESSAGE,
            ip          => "",
         };
      $report->{"id.name"} = $name;
      my $new_rep = Report->new($id, $report , $warn_lines, Report::STATUS_DONT_SAVE);
      require Health::Message;
      my $broke_list = Health::Message->all_logic($new_rep);
      foreach my $dev (@$broke_list) {
         $dev->{problems} = 2; # broke but not processed yet.
         push(@$processed_list, $dev);
      }
      PDM->saveReport($new_rep);
   }
 
   return $processed_list;
}



############################################################
#                    SUBROUTINES
############################################################



# 2003-11-20 10:32:03 ns-east-107.East.Sun.COM [10.8.11.107]:
#        system.sysUpTime.0 = Timeticks: (1) 0:00:00.01  .iso.org.dod.internet.snmpV2.snmpModules.snmpMIB.snmpMIBObjects.snmpTrap.snmpTrapOID.0 = OID: enterprises.42.2.28.21.1.2.2.9.0.1    enterprises.42.2.28.21.1.2.1.1 = "TapeAlert"    enterprises.42.2.28.21.1.2.1.2 = 4 enterprises.42.2.28.21.1.2.2.9.1.1 = "SSC2 1"   enterprises.42.2.28.21.1.2.1.5 = "ns-east-107"    enterprises.42.2.28.21.1.2.1.3 = "The tape drive is having problems reading data. No data has been.lost, but there has been a reduction in the performance of the.tape."    enterprises.42.2.28.21.1.2.1.6 = "Thu Nov 20 12:37:54 2003."    enterprises.42.2.28.21.1.2.2.9.1.4 = "HP      "   enterprises.42.2.28.21.1.2.2.9.1.5 = "Ultrium 1-SCSI  " enterprises.42.2.28.21.1.2.2.9.1.6 = "E1AV"       enterprises.42.2.28.21.1.2.2.9.1.2 = "/dev/rmt/2cbn"      enterprises.42.2.28.21.1.2.2.9.1.3 = "AB8731"   enterprises.42.2.28.21.1.2.2.9.1.7 = "The drive is having severe trouble reading." Creating directory: /opt/SUNWstade/DATA/ucd-snmp


sub find_alert {
  my($agent, $lines, $device, $ISP, $err) = @_;
  my( $level, $name, $no1, $no2, $rest);
  my($m, $year, $date, $comp, $x);
  my($ipno);

  my $Config = PDM::ConfigFile->read();
  my $devs = $Config->devices();
  my (%ACTIVE, %IP);
  my %policies;
  $policies{samfs} = Policies->new("samfs_policies");
  my $playback = System->get_snapshot();
  my ($comp1, $comp2, %MAP);

  foreach my $d (@$devs) {
     $MAP{$d->{ipno}} = $d;
     $ACTIVE{$d->{ipno}} = $d->{active};
  }

  for ($x = 0; $x <= $#$lines; $x++ ) {
     my $line = $lines->[$x];
     my @F = split(/\s*\t\s*/, $line);
     my($date, $time, $name, $ip) = split(/\s+/, $F[0]);
     if ($ip =~ /\[(\d+\.\d+\.\d+\.\d+)\]/) {
       $ip = $1;
     }
     my ($cat);
     if ($line =~ / enterprises.42.2.28.21.1./) {
        $cat = "samfs";
     } else {
        next;
     }
     if ($MAP{$ip}) {
       next if ($ACTIVE{$ip} eq "N");
       my (%data ,$l);
       for ($l=1; $l <= $#F; $l++) {
           my($name, $val) = split(/ = /, $F[$l]);
           $val = substr($val, 1, -1) if (substr($val,0,1) eq '"');
           $val = Util->rtrim($val);
           $data{$name} = $val;
       }
       &$cat($policies{$cat},$date, $time, $name, $ip,\%data, $err);
     }
  }         

  return ($err);
}

%SAM_MAP = ('2.1.1' => 'trap_type',
            '2.1.2' => 'severity',
            '2.1.5' => 'systemID',
            '2.1.3' => 'msg',
            '2.1.6' => 'date',
            '2.2.9' => 'details',
           );
@SAM_SEV = ('Unusable','Alert','Critical','Error','Warning');

sub samfs {
  my($policies, $date, $time, $name, $ip, $data, $err) = @_;
  my($x, %DATA);
  foreach my $el (keys %$data) {
      if ($el =~ /^enterprises/) {
         my @E = split(/\./, $el);
         my $new = join(".", @E[6..8]);
         if ($SAM_MAP{$new}) {
            my $new1 = $SAM_MAP{$new};
            $DATA{$new1} .= ", " if (exists $DATA{$new1});
            $DATA{$new1} .= $data->{$el};
         } else {
            $DATA{other} .= "$data->{$el}, ";
         }
      }
  }
  $DATA{severity} = $SAM_SEV[$DATA{severity}];

  my $lines = ["$date $time $name $ip :$DATA{severity}:$DATA{trap_type}: $DATA{systemID} $DATA{date} $DATA{msg} $DATA{details}"];
  my $y = 0;
  my $key = "samfs:samfs_$ip:$DATA{trap_type}";
  my $key0= "samfs:samfs_$ip";
  $policies->run($err, $lines, \$y, $DATA{trap_type}, $name, $key, $ip, $key0, 1);
       
  
}
  


1;
