/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.util;

import com.sun.netstorage.fm.storade.util.ResourceLock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class LockManager {
    public static final String FRU_SEPARATOR = "~";
    public static final String LOCK_DIR = "/tmp/MgmtLocks";
    public static final String MASTERLOCK = "MASTERLOCK";
    public static final String LOCK_EXT = ".lock";
    private String[] resourceNames;
    private FileLock masterLock;
    private FileOutputStream masterStream;
    private FileChannel masterChannel;
    private long lockTime;
    private static String pid = LockManager.setDefaultPID();
    private static boolean TRACE;
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public LockManager(String string) {
        this.resourceNames = new String[]{string};
    }

    public LockManager(String[] stringArray) {
        this.resourceNames = stringArray;
    }

    public synchronized boolean lock(int n, int n2) {
        long l = System.currentTimeMillis() + (long)(n2 * 1000);
        do {
            boolean bl;
            if (bl = this.lock(n)) {
                return true;
            }
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < l);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean lock(int n) {
        boolean bl;
        try {
            try {
                if (this.lockMaster()) {
                    long l = System.currentTimeMillis() / 1000L;
                    long l2 = l + (long)n;
                    ResourceLock[] resourceLockArray = new ResourceLock[this.resourceNames.length];
                    int n2 = 0;
                    while (true) {
                        if (n2 >= this.resourceNames.length) break;
                        resourceLockArray[n2] = new ResourceLock(this.resourceNames[n2]);
                        resourceLockArray[n2].readLock();
                        if (resourceLockArray[n2].isLocked()) {
                            boolean bl2 = false;
                            Object var10_11 = null;
                            this.unlockMaster();
                            return bl2;
                        }
                        if (resourceLockArray[n2].isFRULocked()) {
                            boolean bl3 = false;
                            Object var10_12 = null;
                            this.unlockMaster();
                            return bl3;
                        }
                        ++n2;
                    }
                    boolean bl4 = this.dolocks(resourceLockArray, l2);
                    Object var10_13 = null;
                    this.unlockMaster();
                    return bl4;
                }
                bl = false;
            }
            catch (Exception exception) {
                if (TRACE) {
                    exception.printStackTrace();
                }
                boolean bl5 = false;
                Object var10_15 = null;
                this.unlockMaster();
                return bl5;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            this.unlockMaster();
            throw throwable;
        }
        Object var10_14 = null;
        this.unlockMaster();
        return bl;
    }

    public synchronized void unlock() throws IOException {
        int n = 0;
        while (n < this.resourceNames.length) {
            ResourceLock resourceLock = new ResourceLock(this.resourceNames[n]);
            resourceLock.readLock();
            if (pid.equals(resourceLock.getLockProcessId()) && this.toString().equals(resourceLock.getInfo())) {
                resourceLock.unlock();
            }
            ++n;
        }
    }

    public boolean isLocked() {
        return this.lockTime > System.currentTimeMillis();
    }

    public boolean checkLocked() throws IOException {
        int n = 0;
        while (n < this.resourceNames.length) {
            ResourceLock resourceLock = new ResourceLock(this.resourceNames[n]);
            resourceLock.readLock();
            if (resourceLock.isLocked()) {
                return true;
            }
            if (resourceLock.isFRULocked()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String getPid() {
        return pid;
    }

    private boolean dolocks(ResourceLock[] resourceLockArray, long l) throws IOException {
        boolean bl;
        block5: {
            bl = false;
            try {
                int n = 0;
                while (n < resourceLockArray.length) {
                    resourceLockArray[n].lock(l, this.toString());
                    ++n;
                }
                this.lockTime = l;
                bl = true;
            }
            catch (Exception exception) {
                if (!TRACE) break block5;
                exception.printStackTrace();
            }
        }
        if (!bl) {
            int n = 0;
            while (n < resourceLockArray.length) {
                resourceLockArray[n].unlock();
                ++n;
            }
        }
        return bl;
    }

    private synchronized boolean lockMaster() {
        return this.lockMaster(false);
    }

    private synchronized boolean lockMaster(boolean bl) {
        if (this.masterLock != null) {
            return true;
        }
        try {
            File file = new File(LOCK_DIR);
            file.mkdirs();
            File file2 = new File(LOCK_DIR, MASTERLOCK);
            file2.createNewFile();
            this.masterStream = new FileOutputStream(file2);
            this.masterChannel = this.masterStream.getChannel();
            this.masterLock = bl ? this.masterChannel.lock() : this.masterChannel.tryLock();
            if (this.masterLock.isValid()) {
                PrintWriter printWriter = new PrintWriter(this.masterStream);
                printWriter.println(LockManager.getMasterExpire());
                printWriter.println(LockManager.getPid());
                printWriter.println(this.toString());
                printWriter.flush();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            if (TRACE) {
                exception.printStackTrace();
            }
            this.unlockMaster();
            return false;
        }
    }

    private void clearMaster() {
        block2: {
            try {
                File file = new File(LOCK_DIR, MASTERLOCK);
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(48);
                fileWriter.write(10);
                fileWriter.close();
            }
            catch (IOException iOException) {
                if (!TRACE) break block2;
                iOException.printStackTrace();
            }
        }
    }

    private void unlockMaster() {
        block11: {
            block10: {
                block9: {
                    try {
                        if (this.masterLock != null && this.masterLock.isValid()) {
                            this.clearMaster();
                            this.masterLock.release();
                        }
                    }
                    catch (IOException iOException) {
                        if (!TRACE) break block9;
                        iOException.printStackTrace();
                    }
                }
                try {
                    if (this.masterChannel != null) {
                        this.masterChannel.close();
                    }
                }
                catch (IOException iOException) {
                    if (!TRACE) break block10;
                    iOException.printStackTrace();
                }
            }
            try {
                if (this.masterStream != null) {
                    this.masterStream.close();
                }
            }
            catch (IOException iOException) {
                if (!TRACE) break block11;
                iOException.printStackTrace();
            }
        }
        this.masterLock = null;
        this.masterChannel = null;
        this.masterStream = null;
    }

    private void finishedOp() {
        this.notify();
    }

    private synchronized boolean lockMaster(long l) {
        MasterLocker masterLocker = new MasterLocker();
        Thread thread = new Thread(masterLocker);
        thread.start();
        long l2 = System.currentTimeMillis();
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.masterLock != null) {
            return true;
        }
        if (l2 + l >= System.currentTimeMillis()) {
            masterLocker.setTimedOut();
            return false;
        }
        return false;
    }

    private static String setDefaultPID() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    private static String getMasterExpire() {
        return Long.toString(System.currentTimeMillis() / 1000L + 30L);
    }

    public static void main(String[] stringArray) {
        block13: {
            if (stringArray.length < 1) {
                System.err.println("Usage ResourceLock <command> [args]");
                System.err.println("Commands: lock   <duration> [resources]");
                System.err.println("          unlock <duration> [resources]");
                System.err.println("          check  [resources]");
                System.exit(-1);
            }
            TRACE = true;
            try {
                if ("lock".equals(stringArray[0])) {
                    int n = Integer.parseInt(stringArray[1]);
                    String[] stringArray2 = new String[stringArray.length - 2];
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        stringArray2[n2] = stringArray[n2 + 2];
                        ++n2;
                    }
                    LockManager lockManager = new LockManager(stringArray2);
                    if (lockManager.lock(n)) {
                        System.out.println("locked!");
                    } else {
                        System.out.println("lock failure");
                    }
                    break block13;
                }
                if ("unlock".equals(stringArray[0])) {
                    int n = Integer.parseInt(stringArray[1]);
                    String[] stringArray3 = new String[stringArray.length - 2];
                    int n3 = 0;
                    while (n3 < stringArray3.length) {
                        stringArray3[n3] = stringArray[n3 + 2];
                        ++n3;
                    }
                    LockManager lockManager = new LockManager(stringArray3);
                    if (lockManager.lock(n)) {
                        System.out.println("locked!");
                    } else {
                        System.out.println("lock failure");
                    }
                    lockManager.unlock();
                    System.out.println("unlocked.");
                    break block13;
                }
                if ("check".equals(stringArray[0])) {
                    String[] stringArray4 = new String[stringArray.length - 1];
                    int n = 0;
                    while (n < stringArray4.length) {
                        stringArray4[n] = stringArray[n + 1];
                        ++n;
                    }
                    LockManager lockManager = new LockManager(stringArray4);
                    System.out.println("Locked=" + lockManager.checkLocked());
                    break block13;
                }
                System.err.println("Unknown command " + stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class MasterLocker
    implements Runnable {
        private boolean timedOut;
        private long limit;

        private MasterLocker() {
        }

        public void run() {
            boolean bl = LockManager.this.lockMaster(true);
            LockManager.this.finishedOp();
            if (this.timedOut) {
                LockManager.this.unlockMaster();
            }
        }

        public void setTimedOut() {
            this.timedOut = true;
        }
    }
}

