/*
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 */
package samples.rmi.simple;


import java.io.*;

import java.math.*;

import java.util.*;

import javax.naming.*;

import javax.servlet.*;
import javax.servlet.http.*;

import javax.naming.Context;
import javax.naming.InitialContext;

import javax.rmi.PortableRemoteObject;

import samples.rmi.simple.ejb.Converter;
import samples.rmi.simple.ejb.ConverterHome;


public class ConverterServlet extends HttpServlet {

    public void doGet(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {

        res.setContentType("text/html");

        PrintWriter out = res.getWriter();

        out.println("<html>");
        out.println("<head>");
        out.println("<title>rmi-iiop sample</title>");
        out.println("</head>");
        out.println("<body>");

        String     dollarStr    = req.getParameter("dollar");
        String     yenStr       = req.getParameter("yen");
        BigDecimal dollarAmount = new BigDecimal("0.0");
        BigDecimal yenAmount    = new BigDecimal("0.0");

        if(dollarStr.length() > 0) {
            dollarAmount = new BigDecimal(dollarStr);
        }

        if(yenStr.length() > 0) {
            yenAmount = new BigDecimal(yenStr);
        }

        try {
            javax.naming.InitialContext initial = new javax.naming.InitialContext();


            Object objref = initial.lookup("java:comp/env/ejb/TheConverter");
            ConverterHome home =
                (ConverterHome) PortableRemoteObject.narrow(objref,
                    ConverterHome.class);
            Converter  currencyConverter = home.create();
            BigDecimal amount = currencyConverter.dollarToYen(dollarAmount);

            out.println(dollarStr + " $ = " + amount.toString() + " yen");
            out.println("<BR>");

            amount = currencyConverter.yenToEuro(yenAmount);

            out.println(yenStr + " yen = " + amount.toString() + " Euro$");
        } catch(Exception ex) {
            out.println("<BR>");
            out.println("Caught an exception (see error log for details) - ");
            out.println(ex.getMessage());
            ex.printStackTrace();
        }

        out.println("</body>");
        out.println("</html>");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        doGet(req, res);
    }
}