package com.iplanet.server.http.session;

import java.lang.*;
import java.util.Properties;
import java.util.Enumeration;
import com.iplanet.server.http.session.IWSHttpSessionManager;

/**
 * iPlanet Web Server 6.0's session store abstract class.
 *
 * @deprecated
 */
public abstract class SessionDataStore 
{
    public static final String IWS_SERVLET_CLASSLOADER = "com.iplanet.server.http.servlet.classloader";

    /**
     * The session manager object that manages the sessions using this
     * storage object.
     */
    protected IWSHttpSessionManager _sessionMgr;

    public SessionDataStore()
    {
        _sessionMgr = null;
    }

    public SessionDataStore(IWSHttpSessionManager sessionMgr)
    {
        _sessionMgr = sessionMgr;
    }

    public abstract boolean init(Properties config);
    public abstract IWSHttpSession load(IWSHttpSession session);
    public abstract boolean save(IWSHttpSession session);
    public abstract boolean remove(IWSHttpSession session);

    /**
     * Deletes those sessions that have timed out.
     *
     * This method is called by <code>SessionReaper</code> thread.  
     *
     * @see     #remove
     */
    public void reap(long currentTime)
    {
    }

    /**
     * Sets the session manager
     */
    protected final void setManager(IWSHttpSessionManager sessionMgr)
    {
        _sessionMgr = sessionMgr;
    }
}
