/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDFactory;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DOMBinding;
import org.netbeans.modules.schema2beans.NodeFactory;
import org.netbeans.modules.schema2beans.NullEntityResolver;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GraphManager {
    Document document = null;
    NodeFactory factory = null;
    HashMap bindingsMap = new HashMap();
    BaseBean root;
    private Factory docFactory;
    private Writer docWriter;
    private String docTypePublic;
    private String docTypeSystem;
    static Map factoryMap = Collections.synchronizedMap(new HashMap());
    static Map writerMap = Collections.synchronizedMap(new HashMap());

    public GraphManager(BaseBean baseBean) {
        this.root = baseBean;
    }

    public static void setFactory(InputStream inputStream, Factory factory) throws Schema2BeansException {
        GraphManager.setFactory(inputStream, factory, null);
    }

    public static void setFactory(InputStream inputStream, Factory factory, Writer writer) throws Schema2BeansException {
        if (inputStream == null) {
            throw new Schema2BeansException(Common.getMessage("InputStreamCantBeNull_msg"));
        }
        if (factory != null) {
            factoryMap.put(inputStream, factory);
        } else {
            factoryMap.remove(inputStream);
        }
        if (writer != null) {
            writerMap.put(inputStream, writer);
        } else {
            writerMap.remove(inputStream);
        }
    }

    public void setWriter(Writer writer) {
        this.docWriter = writer;
    }

    public static Node createRootElementNode(String string) throws Schema2BeansRuntimeException {
        String string2 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<" + string + "/>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        Document document = GraphManager.createXmlDocument(byteArrayInputStream, false);
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof DocumentType) {
                document.removeChild(node);
                --n;
            }
            ++n2;
        }
        return document;
    }

    public void setXmlDocument(Node node) throws Schema2BeansRuntimeException {
        if (node instanceof Document) {
            this.document = (Document)node;
            this.setNodeFactory((Document)node);
            Object v = factoryMap.get(node);
            if (v != null) {
                this.docFactory = (Factory)v;
                factoryMap.remove(node);
            }
            if ((v = writerMap.get(node)) != null) {
                this.docWriter = (Writer)v;
                writerMap.remove(node);
            }
        } else {
            throw new Schema2BeansRuntimeException(Common.getMessage("CantFindFactory_msg"));
        }
    }

    public Document getXmlDocument() {
        return this.document;
    }

    public void setDoctype(String string, String string2) {
        this.docTypePublic = string;
        this.docTypeSystem = string2;
    }

    public static Node getElementNode(String string, Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 1 && node2.getNodeName().equals(string)) break;
            node2 = node2.getNextSibling();
        }
        return node2;
    }

    public void createRootBinding(BaseBean baseBean, BeanProp beanProp, Node node) throws Schema2BeansException {
        beanProp.registerDomNode(node, null, baseBean);
        if (node != null) {
            this.bindingsMap.put(node, baseBean.binding);
        }
    }

    public void completeRootBinding(BaseBean baseBean, Node node) {
        this.bindingsMap.put(node, baseBean.binding);
        baseBean.binding.setNode(node);
    }

    public void setNodeFactory(Document document) {
        this.factory = new NodeFactory(document);
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    public BaseBean getBeanRoot() {
        return this.root;
    }

    protected static Element getRootElement(Document document) {
        return document.getDocumentElement();
    }

    protected static String getDocTypeName(Document document) {
        Node node;
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            node = nodeList.item(n2);
            if (node instanceof DocumentType) {
                DocumentType documentType = (DocumentType)node;
                return documentType.getName();
            }
            ++n2;
        }
        node = GraphManager.getRootElement(document);
        return node.getNodeName();
    }

    void write(OutputStream outputStream) throws IOException, Schema2BeansException {
        if (this.document == null) {
            throw new Schema2BeansException(Common.getMessage("CantGetDocument_msg"));
        }
        if (this.docWriter != null) {
            this.docWriter.write(outputStream, this.document);
        } else {
            this.write(outputStream, null);
        }
    }

    protected void write(OutputStream outputStream, String string) throws IOException, Schema2BeansException {
        if (string == null) {
            string = "UTF-8";
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string));
        this.write((java.io.Writer)bufferedWriter, string);
        ((java.io.Writer)bufferedWriter).flush();
    }

    protected void write(java.io.Writer writer) throws IOException, Schema2BeansException {
        this.write(writer, (String)null);
    }

    protected void write(java.io.Writer writer, String string) throws IOException, Schema2BeansException {
        Object object;
        writer.write("<?xml version=\"1.0\"");
        if (string != null) {
            writer.write(" encoding=\"" + string + "\"?>\n");
        } else {
            writer.write(" encoding=\"UTF-8\"?>\n");
        }
        if (this.docTypePublic != null || this.docTypeSystem != null) {
            object = GraphManager.getDocTypeName(this.document);
            DocumentType documentType = this.document.getDoctype();
            NamedNodeMap namedNodeMap = null;
            if (documentType != null) {
                namedNodeMap = documentType.getEntities();
            }
            this.write(writer, (String)object, this.docTypePublic, this.docTypeSystem, namedNodeMap);
            writer.write("\n");
        }
        object = this.document.getChildNodes();
        int n = object.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = object.item(n2);
            if (node instanceof DocumentType) {
                this.write(writer, node);
                writer.write("\n");
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            Node node = object.item(n3);
            if (!(node instanceof DocumentType)) {
                this.write(writer, node);
                writer.write("\n");
            }
            ++n3;
        }
        writer.flush();
    }

    public void write(java.io.Writer writer, Node node) throws IOException, Schema2BeansException {
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        if (node instanceof Element) {
            writer.write("<" + node.getNodeName());
            this.write(writer, node.getAttributes());
            if (nodeList.getLength() == 0) {
                writer.write("/>");
                return;
            }
            writer.write(">");
        } else if (node instanceof Text) {
            GraphManager.printXML(writer, node.getNodeValue(), false);
        } else if (node instanceof Document) {
            bl = true;
        } else if (node instanceof DocumentType) {
            this.write(writer, (DocumentType)node);
        } else if (node instanceof Comment) {
            this.write(writer, (Comment)node);
        } else if (node instanceof Entity) {
            this.write(writer, (Entity)node);
        } else if (node instanceof ProcessingInstruction) {
            this.write(writer, (ProcessingInstruction)node);
        } else {
            System.out.println("! schema2beans found unknown node type in DOM graph:");
            System.out.println("write: node.getClass=" + node.getClass() + " node=" + node);
            System.out.println("write: nodename=" + node.getNodeName() + " nodevalue=" + node.getNodeValue());
            System.out.println("write: getAttributes=" + node.getAttributes());
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.write(writer, nodeList.item(n2));
            if (bl) {
                writer.write("\n");
            }
            ++n2;
        }
        if (node instanceof Element) {
            writer.write("</" + node.getNodeName() + ">");
        }
    }

    protected void write(java.io.Writer writer, DocumentType documentType) throws IOException, Schema2BeansException {
        if (this.docTypePublic != null || this.docTypeSystem != null) {
            return;
        }
        this.write(writer, documentType.getName(), documentType.getPublicId(), documentType.getSystemId(), documentType.getEntities());
    }

    protected void write(java.io.Writer writer, String string, String string2, String string3, NamedNodeMap namedNodeMap) throws IOException, Schema2BeansException {
        int n;
        writer.write("<!DOCTYPE " + string);
        if (string2 != null) {
            writer.write(" PUBLIC \"");
            GraphManager.printXML(writer, string2);
            writer.write("\"");
            if (string3 == null) {
                string3 = "SYSTEM";
            }
        }
        if (string3 != null) {
            writer.write(" \"");
            GraphManager.printXML(writer, string3);
            writer.write("\"");
        }
        if (namedNodeMap != null && (n = namedNodeMap.getLength()) > 0) {
            writer.write(" [");
            int n2 = 0;
            while (n2 < n) {
                Node node = namedNodeMap.item(n2);
                this.write(writer, node);
                ++n2;
            }
            writer.write("]");
        }
        writer.write(">");
    }

    protected void write(java.io.Writer writer, Comment comment) throws IOException {
        writer.write("<!--" + comment.getNodeValue() + "-->");
    }

    protected void write(java.io.Writer writer, Entity entity) throws IOException {
        writer.write("<!ENTITY " + entity.getNodeName());
        writer.write(" UNKNOWN>");
    }

    protected void write(java.io.Writer writer, ProcessingInstruction processingInstruction) throws IOException {
        writer.write("<?" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "?>");
    }

    protected void write(java.io.Writer writer, NamedNodeMap namedNodeMap) throws IOException {
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = namedNodeMap.item(n2);
            writer.write(" ");
            writer.write(node.getNodeName());
            writer.write("=\"");
            GraphManager.printXML(writer, node.getNodeValue());
            writer.write("\"");
            ++n2;
        }
    }

    public static void printXML(java.io.Writer writer, String string) throws IOException {
        GraphManager.printXML(writer, string, true);
    }

    public static void printXML(java.io.Writer writer, String string, boolean bl) throws IOException {
        if (string == null) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            GraphManager.printXML(writer, c, bl);
            ++n2;
        }
    }

    public static void printXML(java.io.Writer writer, char c, boolean bl) throws IOException {
        if (c == '&') {
            writer.write("&amp;");
        } else if (c == '<') {
            writer.write("&lt;");
        } else if (c == '>') {
            writer.write("&gt;");
        } else if (bl && c == '\"') {
            writer.write("&quot;");
        } else if (bl && c == '\'') {
            writer.write("&apos;");
        } else {
            writer.write(c);
        }
    }

    public void reindent(String string) {
        this.reindent(this.document, -1, string);
    }

    protected boolean reindent(Node node, int n, String string) {
        String string2 = node.getNodeValue();
        boolean bl = true;
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            if (!this.reindent(nodeList.item(n3), n + 1, string)) {
                bl = false;
            }
            ++n3;
        }
        if (bl && n >= 0 && n2 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            GraphManager.printLevel(stringBuffer, n, string);
            String string3 = "\n" + stringBuffer.toString().intern();
            GraphManager.printLevel(stringBuffer, 1, string);
            String string4 = "\n" + stringBuffer.toString().intern();
            if (n2 > 1 && !(nodeList.item(n2 - 1) instanceof Text)) {
                node.appendChild(this.document.createTextNode(string3));
                ++n2;
            }
            boolean bl2 = true;
            int n4 = 0;
            while (n4 < n2) {
                Text text;
                String string5;
                Node node2 = nodeList.item(n4);
                boolean bl3 = node2 instanceof Text;
                if (bl2) {
                    if (bl3) {
                        string5 = node2.getNodeValue().intern();
                        if (n2 != 1) {
                            text = (Text)node2;
                            if (n4 == n2 - 1) {
                                if (string3 != string5) {
                                    if (text.getLength() > 0) {
                                        text.deleteData(0, text.getLength());
                                    }
                                    text.appendData(string3);
                                }
                            } else if (string4 != string5) {
                                text.deleteData(0, text.getLength());
                                text.appendData(string4);
                            }
                            bl2 ^= true;
                        }
                    } else {
                        if (n4 == n2 - 1) {
                            node.insertBefore(this.document.createTextNode(string4), node2);
                            node.appendChild(this.document.createTextNode(string3));
                            ++n2;
                        } else {
                            node.insertBefore(this.document.createTextNode(string4), node2);
                        }
                        ++n4;
                        ++n2;
                    }
                } else if (bl3) {
                    node.removeChild(node2);
                    if (--n4 == --n2 - 1 && n4 >= 0 && string3 != (string5 = (node2 = nodeList.item(n4)).getNodeValue().intern())) {
                        text = (Text)node2;
                        if (text.getLength() > 0) {
                            text.deleteData(0, text.getLength());
                        }
                        text.appendData(string3);
                    }
                } else {
                    bl2 ^= true;
                }
                ++n4;
            }
        }
        if (node instanceof Text) {
            if (string2 == null) {
                return true;
            }
            return string2.trim().equals("");
        }
        return true;
    }

    protected static void printLevel(java.io.Writer writer, int n, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        GraphManager.printLevel(stringBuffer, n, string);
        writer.write(stringBuffer.toString());
    }

    protected static void printLevel(StringBuffer stringBuffer, int n, String string) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            ++n2;
        }
    }

    protected static void printLevel(java.io.Writer writer, int n, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        GraphManager.printLevel(stringBuffer, n, string, string2);
        writer.write(stringBuffer.toString());
    }

    protected static void printLevel(OutputStream outputStream, int n, String string, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        GraphManager.printLevel(outputStreamWriter, n, string, string2);
        outputStreamWriter.flush();
    }

    protected static void printLevel(StringBuffer stringBuffer, int n, String string, String string2) {
        GraphManager.printLevel(stringBuffer, n, string);
        stringBuffer.append(string2);
    }

    public static Document createXmlDocument(InputStream inputStream, boolean bl) throws Schema2BeansRuntimeException {
        return GraphManager.createXmlDocument(inputStream, bl, null);
    }

    public static Document createXmlDocument(InputStream inputStream, boolean bl, EntityResolver entityResolver) throws Schema2BeansRuntimeException {
        try {
            Object v = factoryMap.get(inputStream);
            if (v != null) {
                Factory factory = (Factory)v;
                Document document = factory.createDocument(inputStream, bl);
                factoryMap.remove(inputStream);
                factoryMap.put(document, v);
                Object v2 = writerMap.get(inputStream);
                if (v2 != null) {
                    writerMap.remove(inputStream);
                    writerMap.put(document, v2);
                }
                return document;
            }
            return GraphManager.createXmlDocument(new InputSource(inputStream), bl, entityResolver, null);
        }
        catch (Schema2BeansException schema2BeansException) {
            throw new Schema2BeansRuntimeException(schema2BeansException);
        }
    }

    public static Document createXmlDocument(InputSource inputSource, boolean bl) throws Schema2BeansException {
        return GraphManager.createXmlDocument(inputSource, bl, null, null);
    }

    public static Document createXmlDocument(InputSource inputSource, boolean bl, EntityResolver entityResolver, ErrorHandler errorHandler) throws Schema2BeansException {
        if (!bl && entityResolver == null) {
            entityResolver = NullEntityResolver.newInstance();
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (entityResolver != null) {
                documentBuilder.setEntityResolver(entityResolver);
            }
            if (errorHandler != null) {
                documentBuilder.setErrorHandler(errorHandler);
            }
            if (DDLogFlags.debug) {
                System.out.println("createXmlDocument: validate=" + bl + " dbf=" + documentBuilderFactory + " db=" + documentBuilder + " er=" + entityResolver);
            }
            return documentBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), sAXException);
        }
        catch (IOException iOException) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), iOException);
        }
    }

    public void fillProperties(BeanProp[] beanPropArray, Node node) throws Schema2BeansException {
        boolean bl = false;
        if (beanPropArray == null || node == null) {
            return;
        }
        if (this.bindingsMap.get(node) == null) {
            throw new Schema2BeansException(Common.getMessage("CurrentNodeHasNoBinding_msg", new Integer(node.hashCode())));
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                String string = node2.getNodeName();
                int n = 0;
                while (n < beanPropArray.length) {
                    if (beanPropArray[n].dtdName.equals(string)) {
                        DOMBinding dOMBinding;
                        String string2;
                        bl = true;
                        DOMBinding dOMBinding2 = (DOMBinding)this.bindingsMap.get(node2);
                        if (DDLogFlags.debug) {
                            string2 = string + " N(" + node2.hashCode() + ") - " + (dOMBinding2 == null ? "new node" : "already bound B(" + dOMBinding2.hashCode() + ")");
                            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 9, string2);
                        }
                        if ((dOMBinding = beanPropArray[n].registerDomNode(node2, dOMBinding2, null)) == null) break;
                        BaseBean baseBean = Common.isBean(beanPropArray[n].type) ? (BaseBean)dOMBinding.getBean(beanPropArray[n]) : null;
                        if (DDLogFlags.debug) {
                            string2 = "B(" + dOMBinding.hashCode() + ") - " + beanPropArray[n].getPropClass().getName();
                            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 10, string2);
                        }
                        if (baseBean == null) break;
                        if (dOMBinding2 == null) {
                            this.bindingsMap.put(node2, dOMBinding);
                        }
                        baseBean.createBean(node2, this);
                        break;
                    }
                    ++n;
                }
                if (!bl && DDLogFlags.debug) {
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 11, string);
                }
            } else {
                short s = node2.getNodeType();
                String string = node2.getNodeValue();
                if (DDLogFlags.debug) {
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 12, DDFactory.typeToString(s) + " = " + Common.dumpHex(string));
                }
            }
            node2 = node2.getNextSibling();
        }
    }

    public BaseBean getPropertyParent(String string) {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(Common.getMessage("NameShouldStartWithSlash_msg", string));
        }
        BaseBean baseBean = null;
        int n = 0;
        do {
            String string2;
            int n2;
            if ((n = string.indexOf(47, n)) == -1) continue;
            if ((n2 = string.indexOf(47, ++n)) == -1) {
                if (baseBean != null) break;
                baseBean = this.root;
                break;
            }
            String string3 = string.substring(n, n2);
            int n3 = string3.indexOf(46);
            if (n3 != -1) {
                string2 = string3.substring(n3 + 1);
                string3 = string3.substring(0, n3);
                if (string2.indexOf(105) != -1) {
                    throw new IllegalStateException(Common.getMessage("CantFindBeanBecausePartOfNameRemoved_msg", string3, string));
                }
            } else {
                string2 = "0";
            }
            if ((baseBean = baseBean == null ? this.root : baseBean.propertyById(string3, Integer.parseInt(string2, 16))) != null) continue;
            throw new IllegalStateException(Common.getMessage("CantFindBeanMayHaveBeenRemoved_msg", string3, string));
        } while (n != -1);
        return baseBean;
    }

    public String getKeyPropertyName(String string, String[] stringArray, String[] stringArray2) {
        return this.getKeyPropertyName(string, stringArray, stringArray2, false);
    }

    public String getKeyPropertyName(String string) {
        return this.getKeyPropertyName(string, null, null, true);
    }

    public String getKeyPropertyName(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        BaseBean baseBean = this.root;
        String string2 = string;
        if (string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        do {
            Object object;
            String string3;
            String string4;
            int n;
            if ((n = string2.indexOf(47)) != -1) {
                string4 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            } else {
                string4 = string2;
                string2 = null;
            }
            n = string4.indexOf(46);
            if (n != -1) {
                string3 = string4.substring(n + 1);
                string4 = string4.substring(0, n);
                if (string3.indexOf(105) != -1) {
                    throw new IllegalStateException(Common.getMessage("CantFindBeanBecausePartOfNameRemoved_msg", string4, string));
                }
            } else {
                string3 = "0";
            }
            baseBean = this.root.hasName(string4) ? this.root : (baseBean.getProperty(string4).isBean() ? baseBean.propertyById(string4, Integer.parseInt(string3, 16)) : null);
            stringBuffer.append(string4);
            if (stringArray != null && baseBean != null) {
                n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(string4)) {
                        stringBuffer.append(".");
                        stringBuffer.append(stringArray2[n]);
                        stringBuffer.append("=");
                        object = (String)baseBean.getValue(stringArray2[n], 0);
                        if (object == null) break;
                        stringBuffer.append((String)object);
                        break;
                    }
                    ++n;
                }
            } else if (bl && baseBean != null) {
                object = baseBean.listProperties();
                n = 0;
                while (n < ((BaseProperty[])object).length) {
                    String string5 = object[n].getName();
                    if (string5.toLowerCase().indexOf("name") != -1) {
                        stringBuffer.append(".");
                        stringBuffer.append(string5);
                        stringBuffer.append("=");
                        String string6 = (String)baseBean.getValue(string5, 0);
                        if (string6 == null) break;
                        stringBuffer.append(string6);
                        break;
                    }
                    ++n;
                }
            }
            if (string2 == null) continue;
            stringBuffer.append("/");
        } while (string2 != null && baseBean != null);
        return stringBuffer.toString();
    }

    public static String trimPropertyName(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        do {
            if ((n = string.indexOf(46, n2)) == -1) {
                stringBuffer.append(string.substring(n2));
                continue;
            }
            stringBuffer.append(string.substring(n2, n));
            n2 = string.indexOf(47, n);
        } while (n != -1 && n2 != -1);
        return stringBuffer.toString();
    }

    public String getPropertyParentName(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(47)) != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String getPropertyName(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(58)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String getAttributeName(String string) {
        int n = string.lastIndexOf(58);
        string = n != -1 ? string.substring(n + 1) : null;
        return string;
    }

    public boolean isAttribute(String string) {
        int n = string.lastIndexOf(58);
        return n != -1;
    }

    private String extractPropertyIndex(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            if ((n = (string = string.substring(n + 1)).lastIndexOf(58)) != -1) {
                string = string.substring(0, n);
            }
        } else {
            string = null;
        }
        return string;
    }

    public int getPropertyIndex(String string) {
        String string2 = this.extractPropertyIndex(string);
        if (string2 != null) {
            BeanProp beanProp;
            int n = string2.lastIndexOf(105);
            if (n != -1) {
                return Integer.parseInt(string2.substring(n + 1));
            }
            BaseBean baseBean = this.getPropertyParent(string);
            if (baseBean != null && (beanProp = baseBean.beanProp(this.getPropertyName(string))) != null) {
                return beanProp.idToIndex(Integer.parseInt(string2, 16));
            }
        }
        return -1;
    }

    public static void debug(boolean bl) {
        DDLogFlags.debug = bl;
    }

    public Object defaultScalarValue(int n) {
        switch (n & 0xFF00) {
            case 256: {
                return "";
            }
            case 768: {
                return new Boolean(false);
            }
            case 1024: {
                return new Byte(0);
            }
            case 1280: {
                return new Character('\u0000');
            }
            case 1536: {
                return new Short(0);
            }
            case 1792: {
                return new Integer(0);
            }
            case 2048: {
                return new Long(0L);
            }
            case 2304: {
                return new Float(0.0);
            }
            case 2560: {
                return new Double(0.0);
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType", n));
    }

    public static interface Factory {
        public Document createDocument(InputStream var1, boolean var2);
    }

    public static interface Writer {
        public void write(OutputStream var1, Document var2);
    }
}

