/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.naming.NamingServiceMBean;

public final class NamingService
extends NotificationBroadcasterSupport
implements NamingServiceMBean,
MBeanRegistration {
    private int state = 0;
    private long sequenceNumber = 0L;
    private String oldUrlValue = "";
    private String oldIcValue = "";

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return new ObjectName(":service=Naming");
    }

    public void postRegister(Boolean bl) {
        if (!bl.booleanValue()) {
            this.destroy();
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.destroy();
    }

    public String getName() {
        return "Apache JNDI Naming Service";
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return states[this.state];
    }

    public void start() throws Exception {
        AttributeChangeNotification attributeChangeNotification = null;
        if (this.state != 0) {
            return;
        }
        this.state = 2;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Starting Apache JNDI Naming Service", "State", "java.lang.Integer", new Integer(0), new Integer(2));
        this.sendNotification(attributeChangeNotification);
        try {
            String string = "org.apache.naming";
            String string2 = System.getProperty("java.naming.factory.url.pkgs");
            if (string2 != null) {
                this.oldUrlValue = string2;
                string = string2 + ":" + string;
            }
            System.setProperty("java.naming.factory.url.pkgs", string);
            string2 = System.getProperty("java.naming.factory.initial");
            if (string2 != null) {
                this.oldIcValue = string2;
            } else {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            }
        }
        catch (Throwable throwable) {
            this.state = 0;
            attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Apache JNDI Naming Service", "State", "java.lang.Integer", new Integer(2), new Integer(0));
            this.sendNotification(attributeChangeNotification);
        }
        this.state = 3;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Started Apache JNDI Naming Service", "State", "java.lang.Integer", new Integer(2), new Integer(3));
        this.sendNotification(attributeChangeNotification);
    }

    public void stop() {
        AttributeChangeNotification attributeChangeNotification = null;
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopping Apache JNDI Naming Service", "State", "java.lang.Integer", new Integer(3), new Integer(1));
        this.sendNotification(attributeChangeNotification);
        try {
            System.setProperty("java.naming.factory.url.pkgs", this.oldUrlValue);
            System.setProperty("java.naming.factory.initial", this.oldIcValue);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.state = 0;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Apache JNDI Naming Service", "State", "java.lang.Integer", new Integer(1), new Integer(0));
        this.sendNotification(attributeChangeNotification);
    }

    public void destroy() {
        if (this.getState() != 0) {
            this.stop();
        }
    }
}

