/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.PageData;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.PageDataImpl;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class XmlOutputter {
    private StringBuffer sb = new StringBuffer();
    private AttributesImpl rootAttrs = new AttributesImpl();
    private int jspRootLevel = 0;
    public static final String JSP_NAMESPACE = "http://java.sun.com/JSP/Page";
    public static final String JSP_VERSION = "1.2";

    XmlOutputter() {
        this.rootAttrs.addAttribute("", "xmlns:jsp", "xmlns:jsp", "CDATA", JSP_NAMESPACE);
    }

    void addRootAttrs(Attributes attributes) {
        ++this.jspRootLevel;
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            if (string.startsWith("xmlns:jsp")) continue;
            this.rootAttrs.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
    }

    void addRootNamespaces(String string, String string2) {
        this.rootAttrs.addAttribute("", "xmlns", "xmlns:" + string, "CDATA", string2);
    }

    void rootEnd() {
        --this.jspRootLevel;
    }

    void append(char[] cArray) {
        this.sb.append("<![CDATA[\n");
        this.sb.append(this.filter(cArray));
        this.sb.append("]]>\n");
    }

    void append(String string, Attributes attributes, boolean bl) {
        this.append(string, attributes, this.sb, bl);
    }

    void append(String string, Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = ((String[])hashtable.get(string2))[0];
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "name", "name", "CDATA", string2);
            attributesImpl.addAttribute("", "value", "value", "CDATA", string3);
            this.append(string, attributesImpl, this.sb, false);
            this.append(string);
        }
    }

    void append(String string, Attributes attributes, StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append("<").append(string);
        if (attributes == null || attributes.getLength() < 1) {
            if (bl) {
                stringBuffer.append("/>");
            } else {
                stringBuffer.append(">");
            }
        } else {
            String string2;
            int n;
            stringBuffer.append("\n");
            boolean bl2 = false;
            int n2 = attributes.getLength();
            for (n = 0; n < n2; ++n) {
                String string3 = attributes.getQName(n);
                if (string.equals("jsp:directive.page") && string3.equals("import")) {
                    bl2 = true;
                    continue;
                }
                string2 = attributes.getValue(n);
                stringBuffer.append("  ").append(string3).append("=\"");
                stringBuffer.append(JspUtil.getExprInXml(string2)).append("\"\n");
            }
            if (bl2) {
                n = 1;
                for (int i = 0; i < n2; ++i) {
                    string2 = attributes.getQName(i);
                    if (!string.equals("jsp:directive.page") || !string2.equals("import")) continue;
                    String string4 = attributes.getValue(i);
                    if (n != 0) {
                        n = 0;
                        stringBuffer.append("  import=\"");
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(JspUtil.getExprInXml(string4));
                }
                stringBuffer.append("\"\n");
            }
            if (bl) {
                stringBuffer.append("/>\n");
            } else {
                stringBuffer.append(">\n");
            }
        }
    }

    void append(String string, Attributes attributes, char[] cArray) {
        this.append(string, attributes, false);
        this.append(cArray);
        this.sb.append("</").append(string).append(">\n");
    }

    void append(String string) {
        this.sb.append("</").append(string).append(">\n");
    }

    char[] filter(char[] cArray) {
        int n;
        String string = new String(cArray);
        while ((n = string.indexOf("]]>")) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            stringBuffer.append("]]&gt;");
            stringBuffer.append(string.substring(n + 3));
            string = stringBuffer.toString();
        }
        return string.toCharArray();
    }

    PageData getPageData() {
        StringBuffer stringBuffer = new StringBuffer();
        AttributesImpl attributesImpl = new AttributesImpl();
        this.append("jsp:root", this.rootAttrs, stringBuffer, false);
        stringBuffer.append(this.sb.toString());
        stringBuffer.append("</jsp:root>");
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        PageDataImpl pageDataImpl = new PageDataImpl(byteArrayInputStream);
        return pageDataImpl;
    }
}

