/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CharDataGenerator;
import org.apache.jasper.compiler.CommentGenerator;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JspLineMap;
import org.apache.jasper.compiler.JspLineMapItem;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServletWriter;

public class JakartaCommentGenerator
implements CommentGenerator {
    JspLineMapItem lineMapItem;

    public void generateStartComment(Generator generator, ServletWriter servletWriter, Mark mark, Mark mark2) throws JasperException {
        String string = "";
        if (generator instanceof CharDataGenerator) {
            string = "// HTML ";
        }
        if (mark != null && mark2 != null) {
            if (mark.fileid == mark2.fileid) {
                String string2 = servletWriter.quoteString(mark.getFile());
                servletWriter.println(string + "// begin [file=" + string2 + ";from=" + mark.toShortString() + ";to=" + mark2.toShortString() + "]");
            } else {
                servletWriter.println(string + "// begin [from=" + mark + ";to=" + mark2 + "]");
            }
        } else {
            servletWriter.println(string + "// begin");
        }
        this.lineMapItem = new JspLineMapItem();
        this.lineMapItem.setBeginServletLnr(servletWriter.getJavaLine());
    }

    public void generateEndComment(Generator generator, ServletWriter servletWriter, Mark mark, Mark mark2) throws JasperException {
        servletWriter.println("// end");
        JspLineMap jspLineMap = servletWriter.getLineMap();
        this.lineMapItem.setEndServletLnr(servletWriter.getJavaLine());
        this.lineMapItem.setStartJspFileNr(jspLineMap.addFileName(mark.getSystemId()));
        this.lineMapItem.setBeginJspLnr(mark.getLineNumber() + 1);
        this.lineMapItem.setBeginJspColNr(mark.getColumnNumber() + 1);
        this.lineMapItem.setStopJspFileNr(jspLineMap.addFileName(mark2.getSystemId()));
        this.lineMapItem.setEndJspLnr(mark2.getLineNumber() + 1);
        this.lineMapItem.setEndJspColNr(mark2.getColumnNumber() + 1);
        jspLineMap.add(this.lineMapItem);
    }

    private String toShortString(Mark mark) {
        return "(" + mark.getLineNumber() + "," + mark.getColumnNumber() + ")";
    }

    private String toString(Mark mark) {
        return mark.getSystemId() + "(" + mark.getLineNumber() + "," + mark.getColumnNumber() + ")";
    }
}

