/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SunJava14Compiler;

public class JspEngineContext
implements JspCompilationContext {
    JspReader reader;
    ServletWriter writer;
    ServletContext context;
    URLClassLoader loader;
    String classpath;
    boolean isErrPage;
    String jspFile;
    String servletClassName;
    String servletPackageName;
    String servletJavaFileName;
    String contentType;
    Options options;
    HttpServletRequest req;
    HttpServletResponse res;

    public JspEngineContext(URLClassLoader uRLClassLoader, String string, ServletContext servletContext, String string2, boolean bl, Options options, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.loader = uRLClassLoader;
        this.classpath = string;
        this.context = servletContext;
        this.jspFile = string2;
        this.isErrPage = bl;
        this.options = options;
        this.req = httpServletRequest;
        this.res = httpServletResponse;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public String getClassPath() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("path.separator");
        String string2 = this.options.getClassPath();
        if (this.classpath != null) {
            stringBuffer.append(this.classpath);
            stringBuffer.append(string);
        } else {
            URL[] uRLArray = this.loader.getURLs();
            for (int i = 0; i < uRLArray.length; ++i) {
                if (!uRLArray[i].getProtocol().equals("file")) continue;
                stringBuffer.append(uRLArray[i].getFile());
                stringBuffer.append(string);
            }
        }
        stringBuffer.append(System.getProperty("java.class.path"));
        if (string2 != null) {
            stringBuffer.append(string);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public JspReader getReader() {
        return this.reader;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public String getOutputDir() {
        return this.options.getScratchDir().toString();
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setReader(JspReader jspReader) {
        this.reader = jspReader;
    }

    public void setWriter(ServletWriter servletWriter) {
        this.writer = servletWriter;
    }

    public void setServletClassName(String string) {
        this.servletClassName = string;
    }

    public void setServletPackageName(String string) {
        this.servletPackageName = string;
    }

    public void setServletJavaFileName(String string) {
        this.servletJavaFileName = string;
    }

    public void setErrorPage(boolean bl) {
        this.isErrPage = bl;
    }

    public Compiler createCompiler() throws JasperException {
        JavaCompiler javaCompiler;
        String string = this.options.getJspCompilerPath();
        Class clazz = this.options.getJspCompilerPlugin();
        if (clazz != null) {
            try {
                javaCompiler = (JavaCompiler)clazz.newInstance();
            }
            catch (Exception exception) {
                Constants.message("jsp.warning.compiler.class.cantcreate", new Object[]{clazz, exception}, Integer.MIN_VALUE);
                javaCompiler = new SunJava14Compiler();
            }
        } else {
            javaCompiler = new SunJava14Compiler();
        }
        if (string != null) {
            javaCompiler.setCompilerPath(string);
        }
        JspCompiler jspCompiler = new JspCompiler(this);
        jspCompiler.setJavaCompiler(javaCompiler);
        return jspCompiler;
    }

    public String resolveRelativeUri(String string) {
        if (string.charAt(0) == '/') {
            return string;
        }
        String string2 = this.req.getServletPath();
        String string3 = string2.substring(0, string2.lastIndexOf(47));
        return string3 + '/' + string;
    }

    public InputStream getResourceAsStream(String string) {
        return this.context.getResourceAsStream(string);
    }

    public URL getResource(String string) throws MalformedURLException {
        return this.context.getResource(string);
    }

    public String getRealPath(String string) {
        if (this.context != null) {
            return this.context.getRealPath(string);
        }
        return string;
    }

    public String[] getTldLocation(String string) throws JasperException {
        String[] stringArray = this.options.getTldLocationsCache().getLocation(string);
        return stringArray;
    }
}

