/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class RequestDumperValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.RequestDumperValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        String[] stringArray;
        Object object;
        Object object2;
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            return 1;
        }
        HttpRequest httpRequest = (HttpRequest)request;
        HttpResponse httpResponse = (HttpResponse)response;
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)httpResponse.getResponse();
        this.log("REQUEST URI       =" + httpServletRequest.getRequestURI());
        this.log("          authType=" + httpServletRequest.getAuthType());
        this.log(" characterEncoding=" + httpServletRequest.getCharacterEncoding());
        this.log("     contentLength=" + httpServletRequest.getContentLength());
        this.log("       contentType=" + httpServletRequest.getContentType());
        this.log("       contextPath=" + httpServletRequest.getContextPath());
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                this.log("            cookie=" + cookieArray[i].getName() + "=" + cookieArray[i].getValue());
            }
        }
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = httpServletRequest.getHeaders((String)object2);
            while (object.hasMoreElements()) {
                stringArray = (String[])object.nextElement();
                this.log("            header=" + (String)object2 + "=" + (String)stringArray);
            }
        }
        this.log("            locale=" + httpServletRequest.getLocale());
        this.log("            method=" + httpServletRequest.getMethod());
        object2 = httpServletRequest.getParameterNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            stringArray = httpServletRequest.getParameterValues((String)object);
            StringBuffer stringBuffer = new StringBuffer((String)object);
            stringBuffer.append('=');
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
            this.log("         parameter=" + stringBuffer.toString());
        }
        this.log("          pathInfo=" + httpServletRequest.getPathInfo());
        this.log("          protocol=" + httpServletRequest.getProtocol());
        this.log("       queryString=" + httpServletRequest.getQueryString());
        this.log("        remoteAddr=" + httpServletRequest.getRemoteAddr());
        this.log("        remoteHost=" + httpServletRequest.getRemoteHost());
        this.log("        remoteUser=" + httpServletRequest.getRemoteUser());
        this.log("requestedSessionId=" + httpServletRequest.getRequestedSessionId());
        this.log("            scheme=" + httpServletRequest.getScheme());
        this.log("        serverName=" + httpServletRequest.getServerName());
        this.log("        serverPort=" + httpServletRequest.getServerPort());
        this.log("       servletPath=" + httpServletRequest.getServletPath());
        this.log("          isSecure=" + httpServletRequest.isSecure());
        this.log("---------------------------------------------------------------");
        return 1;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            return;
        }
        HttpRequest httpRequest = (HttpRequest)request;
        HttpResponse httpResponse = (HttpResponse)response;
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)httpResponse.getResponse();
        this.log("---------------------------------------------------------------");
        this.log("          authType=" + httpServletRequest.getAuthType());
        this.log("     contentLength=" + httpResponse.getContentLength());
        this.log("       contentType=" + httpResponse.getContentType());
        Cookie[] cookieArray = httpResponse.getCookies();
        for (int i = 0; i < cookieArray.length; ++i) {
            this.log("            cookie=" + cookieArray[i].getName() + "=" + cookieArray[i].getValue() + "; domain=" + cookieArray[i].getDomain() + "; path=" + cookieArray[i].getPath());
        }
        String[] stringArray = httpResponse.getHeaderNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = httpResponse.getHeaderValues(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                this.log("            header=" + stringArray[i] + "=" + stringArray2[j]);
            }
        }
        this.log("           message=" + httpResponse.getMessage());
        this.log("        remoteUser=" + httpServletRequest.getRemoteUser());
        this.log("            status=" + httpResponse.getStatus());
        this.log("===============================================================");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RequestDumperValve[");
        if (this.container != null) {
            stringBuffer.append(this.container.getName());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void log(String string) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + string);
        } else {
            System.out.println(this.toString() + ": " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + string, throwable);
        } else {
            System.out.println(this.toString() + ": " + string);
            throwable.printStackTrace(System.out);
        }
    }
}

