/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;

public final class FileStore
extends StoreBase
implements Store {
    private static final String FILE_EXT = ".session";
    private String directory = ".";
    private File directoryFile = null;
    private static final String info = "FileStore/1.0";
    private static final String storeName = "fileStore";
    private static final String threadName = "FileStore";

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        String string2 = this.directory;
        this.directory = string;
        this.directoryFile = null;
        this.support.firePropertyChange("directory", string2, this.directory);
    }

    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return threadName;
    }

    public String getStoreName() {
        return storeName;
    }

    public int getSize() throws IOException {
        File file = this.directory();
        if (file == null) {
            return 0;
        }
        String[] stringArray = file.list();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(FILE_EXT)) continue;
            ++n;
        }
        return n;
    }

    public void clear() throws IOException {
        String[] stringArray = this.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            this.remove(stringArray[i]);
        }
    }

    public String[] keys() throws IOException {
        File file = this.directory();
        if (file == null) {
            return new String[0];
        }
        String[] stringArray = file.list();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = FILE_EXT.length();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(FILE_EXT)) continue;
            arrayList.add(stringArray[i].substring(0, stringArray[i].length() - n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session load(String string) throws ClassNotFoundException, IOException {
        Object object;
        block16: {
            Object object2;
            File file = this.file(string);
            if (file == null) {
                return null;
            }
            if (this.debug >= 1) {
                this.log(this.sm.getString(this.getStoreName() + ".loading", string, file.getAbsolutePath()));
            }
            FileInputStream fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            try {
                fileInputStream = new FileInputStream(file.getAbsolutePath());
                object2 = new BufferedInputStream(fileInputStream);
                object = this.manager.getContainer();
                if (object != null) {
                    loader = object.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                objectInputStream = classLoader != null ? new CustomObjectInputStream((InputStream)object2, classLoader) : new ObjectInputStream((InputStream)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.debug >= 1) {
                    this.log("No persisted data file found");
                }
                return null;
            }
            catch (IOException iOException) {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    objectInputStream = null;
                }
                throw iOException;
            }
            try {
                object2 = (StandardSession)this.manager.createSession();
                ((StandardSession)object2).readObjectData(objectInputStream);
                ((StandardSession)object2).setManager(this.manager);
                object = object2;
                Object var10_12 = null;
                if (objectInputStream == null) break block16;
            }
            catch (Throwable throwable) {
                block17: {
                    Object var10_13 = null;
                    if (objectInputStream == null) break block17;
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return object;
    }

    public void remove(String string) throws IOException {
        File file = this.file(string);
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(this.sm.getString(this.getStoreName() + ".removing", string, file.getAbsolutePath()));
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Session session) throws IOException {
        File file = this.file(session.getId());
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(this.sm.getString(this.getStoreName() + ".saving", session.getId(), file.getAbsolutePath()));
        }
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file.getAbsolutePath());
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
        }
        catch (IOException iOException) {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw iOException;
        }
        try {
            ((StandardSession)session).writeObjectData(objectOutputStream);
        }
        finally {
            objectOutputStream.close();
        }
    }

    private File directory() {
        if (this.directory == null) {
            return null;
        }
        if (this.directoryFile != null) {
            return this.directoryFile;
        }
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            Container container = this.manager.getContainer();
            if (container instanceof Context) {
                ServletContext servletContext = ((Context)container).getServletContext();
                File file2 = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                file = new File(file2, this.directory);
            } else {
                throw new IllegalArgumentException("Parent Container is not a Context");
            }
        }
        if (!file.exists() || !file.isDirectory()) {
            file.delete();
            file.mkdirs();
        }
        this.directoryFile = file;
        return file;
    }

    private File file(String string) {
        if (this.directory == null) {
            return null;
        }
        String string2 = string + FILE_EXT;
        File file = new File(this.directory(), string2);
        return file;
    }
}

