/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Container;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Mapper;
import org.apache.catalina.Request;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;

public final class StandardContextMapper
implements Mapper {
    private StandardContext context = null;
    private String protocol = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public Container getContainer() {
        return this.context;
    }

    public void setContainer(Container container) {
        if (!(container instanceof StandardContext)) {
            throw new IllegalArgumentException(sm.getString("httpContextMapper.container"));
        }
        this.context = (StandardContext)container;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public Container map(Request request, boolean bl) {
        int n;
        int n2 = this.context.getDebug();
        if (bl && request.getWrapper() != null) {
            return request.getWrapper();
        }
        String string = ((HttpServletRequest)request.getRequest()).getContextPath();
        String string2 = ((HttpServletRequest)request.getRequest()).getRequestURI();
        String string3 = string2.substring(string.length());
        int n3 = string3.indexOf(59);
        if (n3 >= 0) {
            string3 = string3.substring(0, n3);
        }
        if (n2 >= 1) {
            this.context.log("Mapping contextPath='" + string + "' with requestURI='" + string2 + "' and relativeURI='" + string3 + "'");
        }
        try {
            this.validate(string3);
            if (n2 >= 1) {
                this.context.log("Decoded relativeURI='" + string3 + "'");
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(sm.getString("standardContext.urlDecode", string3));
        }
        Wrapper wrapper = null;
        String string4 = string3;
        String string5 = null;
        String string6 = null;
        if (wrapper == null) {
            if (n2 >= 2) {
                this.context.log("  Trying exact match");
            }
            if (!string3.equals("/")) {
                string6 = this.context.findServletMapping(string3);
            }
            if (string6 != null) {
                wrapper = (Wrapper)this.context.findChild(string6);
            }
            if (wrapper != null) {
                string4 = string3;
                string5 = null;
            }
        }
        if (wrapper == null) {
            if (n2 >= 2) {
                this.context.log("  Trying prefix match");
            }
            string4 = string3;
            while (true) {
                if ((string6 = this.context.findServletMapping(string4 + "/*")) != null) {
                    wrapper = (Wrapper)this.context.findChild(string6);
                }
                if (wrapper != null) {
                    string5 = string3.substring(string4.length());
                    if (string5.length() != 0) break;
                    string5 = null;
                    break;
                }
                n = string4.lastIndexOf(47);
                if (n < 0) break;
                string4 = string4.substring(0, n);
            }
        }
        if (wrapper == null) {
            String string7;
            int n4;
            if (n2 >= 2) {
                this.context.log("  Trying extension match");
            }
            if ((n = string3.lastIndexOf(47)) >= 0 && (n4 = (string7 = string3.substring(n)).lastIndexOf(46)) >= 0) {
                String string8 = "*" + string7.substring(n4);
                string6 = this.context.findServletMapping(string8);
                if (string6 != null) {
                    wrapper = (Wrapper)this.context.findChild(string6);
                }
                if (wrapper != null) {
                    string4 = string3;
                    string5 = null;
                }
            }
        }
        if (wrapper == null) {
            if (n2 >= 2) {
                this.context.log("  Trying default match");
            }
            if ((string6 = this.context.findServletMapping("/")) != null) {
                wrapper = (Wrapper)this.context.findChild(string6);
            }
            if (wrapper != null) {
                string4 = string3;
                string5 = null;
            }
        }
        if (n2 >= 1 && wrapper != null) {
            this.context.log(" Mapped to servlet '" + wrapper.getName() + "' with servlet path '" + string4 + "' and path info '" + string5 + "' and update=" + bl);
        }
        if (bl) {
            request.setWrapper(wrapper);
            ((HttpRequest)request).setServletPath(string4);
            ((HttpRequest)request).setPathInfo(string5);
        }
        return wrapper;
    }

    private void validate(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c != '\u007f') continue;
            throw new IllegalArgumentException(sm.getString("standardContext.urlValidate", string));
        }
    }
}

