/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Logger;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.Resource;

public class ApplicationContext
implements ServletContext {
    private HashMap attributes = new HashMap();
    private HashMap readOnlyAttributes = new HashMap();
    private StandardContext context = null;
    private static final ArrayList empty = new ArrayList();
    private ServletContext facade = new ApplicationContextFacade(this);
    private HashMap parameters = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private String basePath = null;
    private String logPrefix = null;

    public ApplicationContext(String string, StandardContext standardContext) {
        this.context = standardContext;
        this.basePath = string;
        this.logPrefix = sm.getString("applicationContext.logPrefix", standardContext.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAttributes() {
        Object object;
        ArrayList arrayList = new ArrayList();
        Object object2 = this.attributes;
        synchronized (object2) {
            object = this.attributes.keySet().iterator();
            while (object.hasNext()) {
                arrayList.add(object.next());
            }
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            this.removeAttribute((String)object);
        }
    }

    public DirContext getResources() {
        return this.context.getResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeReadOnly(String string) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            if (this.attributes.containsKey(string)) {
                this.readOnlyAttributes.put(string, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String string) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new Enumerator(new ArrayList(this.attributes.keySet()));
        }
    }

    public ServletContext getContext(String string) {
        if (string == null || !string.startsWith("/")) {
            return null;
        }
        String string2 = this.context.getPath();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if (string2.length() > 1 && string.startsWith(string2) || string2.equals(string)) {
            return this;
        }
        if (!this.context.getCrossContext()) {
            return null;
        }
        try {
            Host host = (Host)this.context.getParent();
            Context context = host.map(string);
            if (context != null) {
                return context.getServletContext();
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInitParameter(String string) {
        this.mergeParameters();
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInitParameterNames() {
        this.mergeParameters();
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return new Enumerator(new ArrayList(this.parameters.keySet()));
        }
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    public String getMimeType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n + 1);
        if (string2.length() < 1) {
            return null;
        }
        return this.context.findMimeMapping(string2);
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        if (string == null) {
            return null;
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(string);
        if (wrapper == null) {
            return null;
        }
        ApplicationDispatcher applicationDispatcher = new ApplicationDispatcher(wrapper, null, null, null, null, string);
        return applicationDispatcher;
    }

    public String getRealPath(String string) {
        if (!this.context.isFilesystemBased()) {
            return null;
        }
        File file = new File(this.basePath, string);
        return file.getAbsolutePath();
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.requestDispatcher.iae", string));
        }
        if (this.normalize(string) == null) {
            return null;
        }
        String string2 = this.context.getPath();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string;
        String string4 = null;
        int n = string.indexOf(63);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        string3 = RequestUtil.URLDecode(string3.getBytes(), null, false);
        if (System.getSecurityManager() != null) {
            PrivilegedGetRequestDispatcher privilegedGetRequestDispatcher = new PrivilegedGetRequestDispatcher(string2, string3, string4);
            return (RequestDispatcher)AccessController.doPrivileged(privilegedGetRequestDispatcher);
        }
        HttpRequestBase httpRequestBase = new HttpRequestBase();
        httpRequestBase.setContext(this.context);
        httpRequestBase.setContextPath(this.context.getPath());
        httpRequestBase.setRequestURI(string2 + string3);
        httpRequestBase.setQueryString(string4);
        Wrapper wrapper = (Wrapper)this.context.map(httpRequestBase, true);
        if (wrapper == null) {
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequestBase.getRequest();
        return new ApplicationDispatcher(wrapper, httpServletRequest.getRequestURI(), httpServletRequest.getServletPath(), httpServletRequest.getPathInfo(), httpServletRequest.getQueryString(), null);
    }

    public URL getResource(String string) throws MalformedURLException {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            String string2 = sm.getString("applicationContext.requestDispatcher.iae", string);
            throw new MalformedURLException(string2);
        }
        DirContext dirContext = this.context.getResources();
        if (dirContext != null) {
            String string3 = this.context.getName() + string;
            String string4 = this.context.getParent().getName();
            try {
                dirContext.lookup(string);
                if (System.getSecurityManager() != null) {
                    try {
                        PrivilegedGetResource privilegedGetResource = new PrivilegedGetResource(string4, string3, dirContext);
                        return (URL)AccessController.doPrivileged(privilegedGetResource);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
                return new URL("jndi", null, 0, ApplicationContext.getJNDIUri(string4, string3), new DirContextURLStreamHandler(dirContext));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        DirContext dirContext = this.context.getResources();
        if (dirContext != null) {
            try {
                Object object = dirContext.lookup(string);
                if (object instanceof Resource) {
                    return ((Resource)object).streamContent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getResourcePaths(String string) {
        if (string == null || !string.startsWith("/")) {
            return null;
        }
        DirContext dirContext = this.context.getResources();
        if (dirContext != null) {
            if (System.getSecurityManager() != null) {
                PrivilegedGetResourcePaths privilegedGetResourcePaths = new PrivilegedGetResourcePaths(dirContext, string);
                return (Set)AccessController.doPrivileged(privilegedGetResourcePaths);
            }
            return this.getResourcePathsInternal(dirContext, string);
        }
        return null;
    }

    private Set getResourcePathsInternal(DirContext dirContext, String string) {
        ResourceSet resourceSet = new ResourceSet();
        try {
            ApplicationContext.listCollectionPaths(resourceSet, dirContext, string);
        }
        catch (NamingException namingException) {
            return null;
        }
        resourceSet.setLocked(true);
        return resourceSet;
    }

    public String getServerInfo() {
        return "Sun ONE Web Server";
    }

    public Servlet getServlet(String string) {
        return null;
    }

    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    public Enumeration getServletNames() {
        return new Enumerator(empty);
    }

    public Enumeration getServlets() {
        return new Enumerator(empty);
    }

    public void log(String string) {
        if (System.getSecurityManager() != null) {
            PrivilegedLogMessage privilegedLogMessage = new PrivilegedLogMessage(string);
            AccessController.doPrivileged(privilegedLogMessage);
        } else {
            this.internalLog(string);
        }
    }

    private void internalLog(String string) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(this.logPrefix + string, 3);
        }
    }

    public void log(Exception exception, String string) {
        if (System.getSecurityManager() != null) {
            PrivilegedLogException privilegedLogException = new PrivilegedLogException(exception, string);
            AccessController.doPrivileged(privilegedLogException);
        } else {
            this.internalLog(exception, string);
        }
    }

    private void internalLog(Exception exception, String string) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(exception, this.logPrefix + string);
        }
    }

    public void log(String string, Throwable throwable) {
        if (System.getSecurityManager() != null) {
            PrivilegedLogThrowable privilegedLogThrowable = new PrivilegedLogThrowable(string, throwable);
            AccessController.doPrivileged(privilegedLogThrowable);
        } else {
            this.internalLog(string, throwable);
        }
    }

    private void internalLog(String string, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(this.logPrefix + string, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String string) {
        Object var2_2 = null;
        boolean bl = false;
        Object[] objectArray = this.attributes;
        synchronized (this.attributes) {
            if (this.readOnlyAttributes.containsKey(string)) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            bl = this.attributes.containsKey(string);
            if (!bl) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            var2_2 = this.attributes.get(string);
            this.attributes.remove(string);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            objectArray = this.context.getApplicationListeners();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent(this.context.getServletContext(), string, var2_2);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof ServletContextAttributeListener)) continue;
                ServletContextAttributeListener servletContextAttributeListener = (ServletContextAttributeListener)objectArray[i];
                try {
                    this.context.fireContainerEvent("beforeContextAttributeRemoved", servletContextAttributeListener);
                    servletContextAttributeListener.attributeRemoved(servletContextAttributeEvent);
                    this.context.fireContainerEvent("afterContextAttributeRemoved", servletContextAttributeListener);
                    continue;
                }
                catch (Throwable throwable) {
                    this.context.fireContainerEvent("afterContextAttributeRemoved", servletContextAttributeListener);
                    this.log(sm.getString("applicationContext.attributeEvent"), throwable);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        Object var3_3 = null;
        boolean bl = false;
        Object[] objectArray = this.attributes;
        synchronized (this.attributes) {
            if (this.readOnlyAttributes.containsKey(string)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            var3_3 = this.attributes.get(string);
            if (var3_3 != null) {
                bl = true;
            }
            this.attributes.put(string, object);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            objectArray = this.context.getApplicationListeners();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            ServletContextAttributeEvent servletContextAttributeEvent = null;
            servletContextAttributeEvent = bl ? new ServletContextAttributeEvent(this.context.getServletContext(), string, var3_3) : new ServletContextAttributeEvent(this.context.getServletContext(), string, object);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof ServletContextAttributeListener)) continue;
                ServletContextAttributeListener servletContextAttributeListener = (ServletContextAttributeListener)objectArray[i];
                try {
                    if (bl) {
                        this.context.fireContainerEvent("beforeContextAttributeReplaced", servletContextAttributeListener);
                        servletContextAttributeListener.attributeReplaced(servletContextAttributeEvent);
                        this.context.fireContainerEvent("afterContextAttributeReplaced", servletContextAttributeListener);
                        continue;
                    }
                    this.context.fireContainerEvent("beforeContextAttributeAdded", servletContextAttributeListener);
                    servletContextAttributeListener.attributeAdded(servletContextAttributeEvent);
                    this.context.fireContainerEvent("afterContextAttributeAdded", servletContextAttributeListener);
                    continue;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        this.context.fireContainerEvent("afterContextAttributeReplaced", servletContextAttributeListener);
                    } else {
                        this.context.fireContainerEvent("afterContextAttributeAdded", servletContextAttributeListener);
                    }
                    this.log(sm.getString("applicationContext.attributeEvent"), throwable);
                }
            }
            return;
        }
    }

    ServletContext getFacade() {
        return this.facade;
    }

    private String normalize(String string) {
        int n;
        String string2 = string;
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }

    private void mergeParameters() {
        if (this.parameters != null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.context.findParameters();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], this.context.findParameter(stringArray[i]));
        }
        ApplicationParameter[] applicationParameterArray = this.context.findApplicationParameters();
        for (int i = 0; i < applicationParameterArray.length; ++i) {
            if (applicationParameterArray[i].getOverride()) {
                if (hashMap.get(applicationParameterArray[i].getName()) != null) continue;
                hashMap.put(applicationParameterArray[i].getName(), applicationParameterArray[i].getValue());
                continue;
            }
            hashMap.put(applicationParameterArray[i].getName(), applicationParameterArray[i].getValue());
        }
        this.parameters = hashMap;
    }

    private static void listPaths(Set set, DirContext dirContext, String string) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration = dirContext.listBindings(string);
        while (namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            String string2 = binding.getName();
            String string3 = string + "/" + string2;
            set.add(string3);
            Object object = binding.getObject();
            if (!(object instanceof DirContext)) continue;
            ApplicationContext.listPaths(set, dirContext, string3);
        }
    }

    private static void listCollectionPaths(Set set, DirContext dirContext, String string) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration = dirContext.listBindings(string);
        while (namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            String string2 = binding.getName();
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string2);
            Object object = binding.getObject();
            if (object instanceof DirContext) {
                stringBuffer.append("/");
            }
            set.add(stringBuffer.toString());
        }
    }

    public static String getJNDIUri(String string, String string2) {
        if (!string2.startsWith("/")) {
            return "/" + string + "/" + string2;
        }
        return "/" + string + string2;
    }

    protected class PrivilegedLogThrowable
    implements PrivilegedAction {
        private String message;
        private Throwable throwable;

        PrivilegedLogThrowable(String string, Throwable throwable) {
            this.message = string;
            this.throwable = throwable;
        }

        public Object run() {
            ApplicationContext.this.internalLog(this.message, this.throwable);
            return null;
        }
    }

    protected class PrivilegedLogException
    implements PrivilegedAction {
        private String message;
        private Exception exception;

        PrivilegedLogException(Exception exception, String string) {
            this.message = string;
            this.exception = exception;
        }

        public Object run() {
            ApplicationContext.this.internalLog(this.exception, this.message);
            return null;
        }
    }

    protected class PrivilegedLogMessage
    implements PrivilegedAction {
        private String message;

        PrivilegedLogMessage(String string) {
            this.message = string;
        }

        public Object run() {
            ApplicationContext.this.internalLog(this.message);
            return null;
        }
    }

    protected class PrivilegedGetResourcePaths
    implements PrivilegedAction {
        private String path;
        private DirContext resources;

        PrivilegedGetResourcePaths(DirContext dirContext, String string) {
            this.resources = dirContext;
            this.path = string;
        }

        public Object run() {
            return ApplicationContext.this.getResourcePathsInternal(this.resources, this.path);
        }
    }

    protected class PrivilegedGetResource
    implements PrivilegedExceptionAction {
        private String path;
        private String host;
        private DirContext resources;

        PrivilegedGetResource(String string, String string2, DirContext dirContext) {
            this.host = string;
            this.path = string2;
            this.resources = dirContext;
        }

        public Object run() throws Exception {
            return new URL("jndi", null, 0, ApplicationContext.getJNDIUri(this.host, this.path), new DirContextURLStreamHandler(this.resources));
        }
    }

    protected class PrivilegedGetRequestDispatcher
    implements PrivilegedAction {
        private String contextPath;
        private String relativeURI;
        private String queryString;

        PrivilegedGetRequestDispatcher(String string, String string2, String string3) {
            this.contextPath = string;
            this.relativeURI = string2;
            this.queryString = string3;
        }

        public Object run() {
            HttpRequestBase httpRequestBase = new HttpRequestBase();
            httpRequestBase.setContext(ApplicationContext.this.context);
            httpRequestBase.setContextPath(ApplicationContext.this.context.getPath());
            httpRequestBase.setRequestURI(this.contextPath + this.relativeURI);
            httpRequestBase.setQueryString(this.queryString);
            Wrapper wrapper = (Wrapper)ApplicationContext.this.context.map(httpRequestBase, true);
            if (wrapper == null) {
                return null;
            }
            HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequestBase.getRequest();
            return new ApplicationDispatcher(wrapper, httpServletRequest.getRequestURI(), httpServletRequest.getServletPath(), httpServletRequest.getPathInfo(), httpServletRequest.getQueryString(), null);
        }
    }
}

