/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.taglibs;

import com.sun.web.search.retrieval.Result;
import com.sun.web.search.retrieval.ResultSet;
import com.sun.web.search.retrieval.SearchException;
import com.sun.web.search.taglibs.ResultTagBase;
import com.sun.web.search.taglibs.util.Constants;
import com.sun.web.search.taglibs.util.LocalStrings;
import com.sun.web.search.taglibs.util.ResourceUtil;
import com.sun.web.search.util.CollectionInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;

public class ResultIterationTag
extends ResultTagBase {
    private Constants defValues = Constants.getInstance();
    private String elemStart;
    private String elemNumShown;
    private int start = 0;
    private int nShown = 0;
    private int recordCount = 0;
    private int curIndex;
    private List searchResults;
    static LocalStrings ls = LocalStrings.getSearchLogger();
    private Map colls;
    private String collName;
    private String collUri;
    private String collRootDir;
    private Result currentItem;

    private void getCollMap() throws JspException {
        this.colls = (Map)this.pageContext.getServletContext().getAttribute("com.sun.web.search.taglibs.coll_info");
        if (null == this.colls) {
            throw new JspTagException("ResultIteration tag must be used along with the SearchTag");
        }
    }

    public int getCurIndex() {
        return this.curIndex;
    }

    public String getCollUri() {
        return this.collUri;
    }

    public String getCollRoot() {
        return this.collRootDir;
    }

    public Result getCurrentItem() throws JspException {
        return this.currentItem;
    }

    protected void setCurrentItem() throws JspException {
        try {
            this.currentItem = (Result)this.searchResults.get(this.curIndex - this.start);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JspTagException("out of bounds. index " + this.curIndex + " out of " + this.recordCount);
        }
        this.setCollInfo();
    }

    private void setCollInfo() throws JspException {
        try {
            this.collName = this.currentItem.getFieldValue("collection");
        }
        catch (SearchException searchException) {
            throw new JspTagException(searchException.getMessage());
        }
        CollectionInfo collectionInfo = (CollectionInfo)this.colls.get(this.collName);
        if (collectionInfo == null) {
            throw new JspTagException("Collection information is not available.");
        }
        this.collUri = collectionInfo.getUri();
        this.collRootDir = collectionInfo.getRootDirectory();
    }

    private void getElems() throws JspException {
        if (this.hasForm()) {
            this.elemStart = (String)this.formValues.get("com.sun.web.search.taglibs.siName");
            this.elemNumShown = (String)this.formValues.get("com.sun.web.search.taglibs.nsName");
        }
        if (null == this.elemStart) {
            this.elemStart = this.defValues.getDefValue("com.sun.web.search.taglibs.siName");
        }
        if (null == this.elemNumShown) {
            this.elemNumShown = this.defValues.getDefValue("com.sun.web.search.taglibs.nsName");
        }
    }

    private void getSubmitValues() throws JspException {
        this.getElems();
        if (this.hasForm()) {
            this.start = Integer.parseInt((String)this.formValues.get(this.elemStart));
        } else if (this.start == 0) {
            this.start = Integer.parseInt(this.defValues.getDefValue("com.sun.web.search.taglibs.siValue"));
        }
        if (this.start < 1) {
            this.start = 1;
        }
        if (this.hasForm()) {
            this.nShown = Integer.parseInt((String)this.formValues.get(this.elemNumShown));
        } else if (this.nShown == 0) {
            this.nShown = Integer.parseInt(this.defValues.getDefValue("com.sun.web.search.taglibs.nsValue"));
        }
    }

    public void otherDoStartTagOperations() throws JspException {
        Integer n = (Integer)this.pageContext.findAttribute("com.sun.web.search.taglibs.count_" + this.formId);
        if (n != null) {
            this.recordCount = n;
        }
        if (this.recordCount > 0) {
            this.initForm();
            this.getSubmitValues();
            this.getCollMap();
            ResultSet resultSet = (ResultSet)this.pageContext.findAttribute("com.sun.web.search.taglibs.results_" + this.formId);
            this.curIndex = this.start;
            if (null != resultSet) {
                try {
                    this.searchResults = resultSet.getHits(this.start - 1, this.nShown);
                }
                catch (SearchException searchException) {
                    throw new JspException(searchException.getMessage());
                }
                if (this.hasNext()) {
                    this.setCurrentItem();
                }
            }
        } else {
            try {
                JspWriter jspWriter = this.pageContext.getOut();
                jspWriter.print(ResourceUtil.getLocalizedString("noResultsWereFound", this.pageContext));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean hasNext() {
        return this.recordCount > 0 && this.curIndex <= this.recordCount && this.curIndex <= this.start + this.nShown - 1;
    }

    public boolean theBodyShouldBeEvaluated() {
        return this.recordCount > 0;
    }

    public void otherDoEndTagOperations() {
        this.clearProperties();
    }

    protected void clearProperties() {
        this.searchResults = null;
        this.colls = null;
        this.collName = null;
        this.collUri = null;
        this.collRootDir = null;
        this.currentItem = null;
    }

    public boolean shouldEvaluateRestOfPageAfterEndTag() {
        return true;
    }

    public int doStartTag() throws JspException, JspException {
        this.otherDoStartTagOperations();
        if (this.theBodyShouldBeEvaluated()) {
            return 2;
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        BodyContent bodyContent = this.getBodyContent();
        try {
            JspWriter jspWriter = bodyContent.getEnclosingWriter();
            jspWriter.println(bodyContent.getString());
            bodyContent.clearBody();
        }
        catch (IOException iOException) {
            throw new JspTagException(ls.getStr("search.taglibs.IOError"));
        }
        ++this.curIndex;
        if (this.hasNext()) {
            this.setCurrentItem();
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException, JspException {
        this.otherDoEndTagOperations();
        if (this.shouldEvaluateRestOfPageAfterEndTag()) {
            return 6;
        }
        return 5;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setNumShown(int n) {
        this.nShown = n;
    }

    public void setElemStart(String string) {
        this.elemStart = string;
    }

    public void setElemNumShown(String string) {
        this.elemNumShown = string;
    }
}

