/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.index;

import com.sun.web.search.index.FSMElement;
import com.sun.web.search.index.IndexingLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class MetaTagParser {
    private File file;
    private String encoding;
    private InputStreamReader reader;
    private FileInputStream fin;
    private FSMElement FSM;
    private int bufferPos = 0;
    private static final int MAX_BUFFER = 4096;
    private int fileSize = 0;
    private char[] buffer;
    private HashMap metaHash = new HashMap();
    private boolean charSetFound = false;

    private MetaTagParser(File file, String string) throws IOException {
        this.file = file;
        this.encoding = string;
        this.fin = new FileInputStream(file);
        this.fileSize = new Long(file.length()).intValue();
        if (this.fileSize > 4096) {
            this.fileSize = 4096;
        }
        this.buffer = new char[this.fileSize];
        this.reader = new InputStreamReader((InputStream)this.fin, this.encoding);
        this.FSM = FSMElement.getFSM();
        this.metaHash.put("charset", this.encoding);
    }

    private void rewind() throws IOException {
        this.reader.close();
        this.metaHash.put("charset", this.encoding);
        this.fin = new FileInputStream(this.file);
        this.reader = new InputStreamReader((InputStream)this.fin, this.encoding);
    }

    private void readFile() throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fileSize && n >= 0) {
            n = this.reader.read(this.buffer, n2, this.fileSize - n2);
            if (n <= 0) continue;
            n2 += n;
        }
    }

    private HashMap getMeta() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        char c = '\u0000';
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            this.readFile();
            char c2 = this.buffer[n2++];
            while (n2 < this.fileSize) {
                this.FSM.setVal(FSMElement.TOKEN[n3], FSMElement.MFA[n3][0], FSMElement.MFA[n3][1], FSMElement.MFA[n3][2]);
                if (this.FSM.attrType != 0) {
                    n = this.FSM.attrType;
                }
                if ((c = this.FSM.target) == '\u0000') {
                    if (n3 != 20) {
                        if (n4 == 0) {
                            n4 = n2 - 1;
                        }
                        ++n5;
                    }
                    c2 = this.buffer[n2++];
                    n3 = this.FSM.onMatch;
                    continue;
                }
                if (c == Character.toLowerCase(c2)) {
                    c2 = this.buffer[n2++];
                    n3 = this.FSM.onMatch;
                    if (n3 != -1) continue;
                    if (n == 1) {
                        bl = true;
                        stringBuffer.append(this.buffer, n4, n5);
                    }
                    if (n == 2) {
                        bl2 = true;
                        stringBuffer2.append(this.buffer, n4, n5);
                    }
                    if (bl && bl2) {
                        if (stringBuffer.toString().trim().length() > 0 && stringBuffer2.toString().trim().length() > 0) {
                            this.metaHash.put(stringBuffer.toString().trim(), stringBuffer2.toString().trim());
                        }
                        bl = false;
                        bl2 = false;
                        stringBuffer.delete(0, stringBuffer.length());
                        stringBuffer2.delete(0, stringBuffer2.length());
                    }
                    if (!bl && bl2) {
                        String string = null;
                        string = !this.charSetFound ? FSMElement.getCharSet(stringBuffer2.toString()) : this.encoding;
                        if (string != null && string.length() > 0 && !string.equalsIgnoreCase(this.encoding)) {
                            this.metaHash.clear();
                            this.encoding = string;
                            this.charSetFound = true;
                            this.rewind();
                            return this.getMeta();
                        }
                        bl2 = false;
                        stringBuffer2.delete(0, stringBuffer2.length());
                    }
                    n = 0;
                    n4 = 0;
                    n5 = 0;
                    n3 = 12;
                    continue;
                }
                if (this.FSM.onFail == -1) {
                    c2 = this.buffer[n2++];
                    continue;
                }
                n3 = this.FSM.onFail;
            }
            this.reader.close();
        }
        catch (IOException iOException) {
            IndexingLog.log("Error in reading the file :" + this.file.getName() + " with encoding " + this.encoding);
        }
        return this.metaHash;
    }

    public static HashMap parse(String string, String string2) throws IOException {
        File file = new File(string);
        return MetaTagParser.parse(file, string2);
    }

    public static HashMap parse(File file, String string) throws IOException {
        if (string == null) {
            string = "8859_1";
        }
        MetaTagParser metaTagParser = new MetaTagParser(file, string);
        return metaTagParser.getMeta();
    }
}

