/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.index;

import com.sun.kt.search.IndexableFile;
import com.sun.web.search.index.IndexingLog;
import com.sun.web.search.index.MetaTagParser;
import com.sun.web.search.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MetaTagIndexer {
    private String[] keys;

    public MetaTagIndexer(String[] stringArray) {
        this.keys = stringArray;
    }

    public void addMetatags(Map map) {
        String string = (String)map.get("enc");
        String string2 = (String)map.get("filename");
        if (string == null || string2 == null) {
            return;
        }
        if (!string2.toUpperCase().endsWith("HTML") && !string2.toUpperCase().endsWith("HTM")) {
            return;
        }
        try {
            HashMap hashMap;
            try {
                hashMap = MetaTagParser.parse(string2, string);
            }
            catch (Exception exception) {
                hashMap = MetaTagParser.parse(string2, null);
            }
            if (hashMap == null || hashMap.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                String string3 = (String)hashMap.get(this.keys[i]);
                if (string3 == null) continue;
                map.put(this.keys[i], string3);
            }
            String string4 = (String)hashMap.get("charset");
            if (string4 != null && !string4.equalsIgnoreCase(string) && Util.isValidEncoding(string4)) {
                IndexingLog.log("Using charset " + string4 + " for " + map.get("sourcefile"));
                map.put("enc", string4);
                map.put("sourcefile-encoding", string4);
                map.put("file", new IndexableFile(string2, string4));
            }
        }
        catch (IOException iOException) {
            IndexingLog.log("Error in opening the file : " + string2, iOException);
        }
    }
}

