/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.index;

import com.sun.kt.search.SearchEngine;
import com.sun.kt.search.SearchEngineException;
import com.sun.web.search.index.ConversionPool;
import com.sun.web.search.index.FileSource;
import com.sun.web.search.index.IndexDirectory;
import com.sun.web.search.index.IndexException;
import com.sun.web.search.index.IndexingLog;
import com.sun.web.search.index.MetaTagIndexer;
import com.sun.web.search.util.SearchProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class KtIndexer {
    static final int conversionThreads = 5;
    private String[] metaTagKeys = new String[]{"author", "subject", "keywords"};
    protected FileSource source;
    protected String indexDir;
    protected ConversionPool conversionPool;
    protected IndexDirectory dir;
    protected MetaTagIndexer metaIndexer;
    protected SearchProperties searchProps;
    protected SearchEngine engine;

    public KtIndexer(IndexDirectory indexDirectory, FileSource fileSource, Properties properties) throws IndexException {
        this.dir = indexDirectory;
        this.source = fileSource;
        this.searchProps = properties == null ? new SearchProperties() : (SearchProperties)properties;
        this.searchProps.put("indexDir", this.dir.getIndexDirectory().getAbsolutePath());
        this.searchProps.put("lockDir", this.dir.getLockDirectory().getAbsolutePath());
        this.getMetaTags(fileSource);
        this.searchProps.addMetatagFields(this.metaTagKeys);
        this.metaIndexer = new MetaTagIndexer(this.metaTagKeys);
        try {
            IndexingLog.debug(this.dir.getIndexDirectory().getAbsolutePath());
            this.engine = new SearchEngine((Properties)this.searchProps);
            Class<?> clazz = Class.forName("com.sun.web.search.index.ConversionThread");
            this.conversionPool = new ConversionPool(clazz, 5, this.dir, this);
            this.conversionPool.setExtensionSpec(this.searchProps.getProperty("conversionExtensions"));
            this.conversionPool.start();
        }
        catch (Exception exception) {
            throw new IndexException(exception);
        }
    }

    public SearchEngine getEngine() {
        return this.engine;
    }

    public void addDocument(String string, Map map) {
        this.conversionPool.index(string, map);
    }

    public void index(String string, Map map) {
        IndexingLog.log("Indexing " + string);
        try {
            this.metaIndexer.addMetatags(map);
        }
        catch (Exception exception) {
            IndexingLog.log("Could not parse metatags in " + string);
        }
        try {
            this.engine.index(string, map);
        }
        catch (SearchEngineException searchEngineException) {
            IndexingLog.log("Failed to index " + string + ".", searchEngineException);
        }
    }

    public void index() {
        Map map = null;
        while (null != (map = this.source.getNextEntry())) {
            this.conversionPool.index((String)map.get("sourcefile"), map);
        }
    }

    public void index(FileSource fileSource) {
        this.source = fileSource;
        this.index();
        this.conversionPool.index(fileSource);
    }

    public void shutdown() {
        try {
            this.conversionPool.shutdown();
            this.engine.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getMetaTags(FileSource fileSource) {
        String string = this.searchProps.getProperty("indexMetatags");
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("all")) {
            String[] stringArray = fileSource.getMetaTagKeys();
            if (stringArray != null) {
                this.metaTagKeys = stringArray;
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.metaTagKeys.length; ++i) {
            hashSet.add(this.metaTagKeys[i]);
        }
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        this.metaTagKeys = hashSet.toArray(new String[hashSet.size()]);
    }
}

