/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.index;

import com.sun.kt.search.SearchEngine;
import com.sun.web.search.index.ArrayFileSource;
import com.sun.web.search.index.DirectoryFileSource;
import com.sun.web.search.index.ExtensionFileFilter;
import com.sun.web.search.index.FileFilter;
import com.sun.web.search.index.FileSource;
import com.sun.web.search.index.Index;
import com.sun.web.search.index.IndexDirectory;
import com.sun.web.search.index.IndexException;
import com.sun.web.search.index.IndexingLog;
import com.sun.web.search.index.KtAttributeMapper;
import com.sun.web.search.index.KtIndexer;
import com.sun.web.search.retrieval.KtResultSet;
import com.sun.web.search.retrieval.KtSearchEngine;
import com.sun.web.search.retrieval.Result;
import com.sun.web.search.retrieval.SearchException;
import com.sun.web.search.util.SearchConfig;
import com.sun.web.search.util.SearchProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class KtIndex
implements Index {
    protected KtIndexer indexer;
    private String name;
    private SearchConfig config;
    private Properties props;
    private IndexDirectory dir;
    private int numProcessedDocs;
    private int numUpdatedDocs;
    private int numRemOutdatedDocs;
    private SearchProperties searchProps;
    private ArrayList outdatedList;

    public KtIndex(SearchConfig searchConfig, String string, IndexDirectory indexDirectory) throws IndexException {
        this.config = searchConfig;
        this.name = string;
        this.props = searchConfig.getProperties();
        this.dir = indexDirectory;
        this.searchProps = new SearchProperties();
        this.searchProps.merge(this.props);
        this.indexer = null;
        this.clearStats();
    }

    private synchronized void ensureIndexer(FileSource fileSource) throws IndexException {
        try {
            if (this.indexer == null) {
                this.indexer = new KtIndexer(this.dir, fileSource, this.searchProps);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IndexException(exception.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.dir.getIndexDirectory().getAbsolutePath();
    }

    public Properties getProperties() {
        return this.props;
    }

    public void delete() throws IndexException {
        this.dir.cleanup();
    }

    public void optimize() throws IndexException {
        throw new UnsupportedOperationException("KtIndex.optimize() unimplemented");
    }

    public void addDirectory(String string, String string2, FileFilter fileFilter) throws IndexException {
        this.addDirectory(string, true, string2, fileFilter);
    }

    public void addDirectory(String string, boolean bl, String string2, FileFilter fileFilter) throws IndexException {
        Object object;
        this.clearStats();
        if (string2 == null) {
            string2 = "ISO-8859-1";
        }
        if (fileFilter == null) {
            object = (String)this.props.get("excludeExtensions");
            fileFilter = new ExtensionFileFilter((String)object);
        }
        object = new DirectoryFileSource(string, bl, string2, fileFilter, new KtAttributeMapper(this.name));
        Map map = null;
        this.ensureIndexer((FileSource)object);
        while (null != (map = ((ArrayFileSource)object).getNextEntry())) {
            this.addDocument((String)map.get("dockey"), map);
            ++this.numProcessedDocs;
        }
        this.flush();
    }

    public void reindex() throws IndexException, SearchException {
        String[] stringArray;
        Object object;
        this.clearStats();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.loadFilesArrays(arrayList, arrayList2, true, null);
        int n = arrayList.size();
        if (n > 0) {
            object = new String[n];
            stringArray = new String[n];
            object = arrayList.toArray((T[])object);
            stringArray = arrayList2.toArray(stringArray);
            ArrayFileSource arrayFileSource = new ArrayFileSource(this.name, (String[])object, stringArray);
            arrayFileSource.setAttributeMapper(new KtAttributeMapper(this.name));
            this.ensureIndexer(arrayFileSource);
            this.indexer.index(arrayFileSource);
        }
        if (this.outdatedList != null && this.outdatedList.size() > 0) {
            object = this.outdatedList.iterator();
            while (object.hasNext()) {
                stringArray = (String)object.next();
                this.removeDocument((String)stringArray);
            }
        }
        this.flush();
    }

    public void addDocument(String string, Map map) throws IndexException {
        try {
            this.indexer.addDocument(string, map);
        }
        catch (Exception exception) {
            throw new IndexException(exception.toString());
        }
    }

    public void removeDocument(String string) throws IndexException {
        this.ensureIndexer(new FileSource());
        SearchEngine searchEngine = this.indexer.getEngine();
        IndexingLog.log("Deleting " + string);
        searchEngine.delete(string);
    }

    public void removeDocuments(FileFilter fileFilter) throws IndexException, SearchException {
        this.clearStats();
        ArrayList arrayList = new ArrayList();
        this.loadFilesArrays(arrayList, null, false, fileFilter);
        if (arrayList.size() > 0) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.removeDocument(string);
            }
        }
        this.flush();
    }

    public void flush() throws IndexException {
        try {
            if (this.indexer != null) {
                this.indexer.shutdown();
            } else {
                this.close();
            }
            this.indexer = null;
        }
        catch (Exception exception) {
            throw new IndexException(exception.toString());
        }
    }

    private void loadFilesArrays(ArrayList arrayList, ArrayList arrayList2, boolean bl, FileFilter fileFilter) throws IndexException, SearchException {
        KtSearchEngine ktSearchEngine = new KtSearchEngine(this.config);
        String[] stringArray = new String[]{this.name};
        ktSearchEngine.setMaxHits(-1);
        KtResultSet ktResultSet = (KtResultSet)ktSearchEngine.search("dockey != null", "-score", stringArray);
        if (ktResultSet == null) {
            this.close();
            return;
        }
        List list = ktResultSet.getHits(0, ktResultSet.size());
        boolean bl2 = false;
        this.outdatedList = null;
        for (int i = 0; i < list.size(); ++i) {
            ++this.numProcessedDocs;
            Result result = (Result)list.get(i);
            String string = result.getPath();
            File file = new File(string);
            if (bl) {
                Date date;
                if (!file.exists()) {
                    ++this.numRemOutdatedDocs;
                    IndexingLog.log("removing " + string);
                    if (this.outdatedList == null) {
                        this.outdatedList = new ArrayList();
                    }
                    this.outdatedList.add(string);
                    continue;
                }
                Date date2 = result.getDate();
                if (date2.equals(date = new Date(file.lastModified()))) {
                    IndexingLog.log("skipping unmodified " + string);
                    continue;
                }
                IndexingLog.log(string + "has been modified since indexing.");
            }
            if (fileFilter != null && !fileFilter.accept(string)) continue;
            arrayList.add(string);
            ++this.numUpdatedDocs;
            if (arrayList2 == null) continue;
            arrayList2.add(result.getEncoding());
        }
    }

    protected void clearStats() {
        this.numProcessedDocs = 0;
        this.numUpdatedDocs = 0;
        this.numRemOutdatedDocs = 0;
    }

    public int getNumProcessedDocs() {
        return this.numProcessedDocs;
    }

    public int getNumUpdatedDocs() {
        return this.numUpdatedDocs;
    }

    public int getNumRemOutdatedDocs() {
        return this.numRemOutdatedDocs;
    }

    protected void close() {
        try {
            this.searchProps.put("indexDir", this.dir.getIndexDirectory().getAbsolutePath());
            this.searchProps.put("lockDir", this.dir.getLockDirectory().getAbsolutePath());
            SearchEngine searchEngine = new SearchEngine((Properties)this.searchProps);
            searchEngine.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

