/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.admin;

import com.iplanet.ias.config.ConfigException;
import com.sun.web.search.admin.CommandLineParser;
import com.sun.web.search.admin.Options;
import com.sun.web.search.admin.SearchAdminException;
import com.sun.web.search.index.Index;
import com.sun.web.search.index.IndexDirectory;
import com.sun.web.search.index.IndexException;
import com.sun.web.search.index.IndexManager;
import com.sun.web.search.index.IndexingLog;
import com.sun.web.search.index.ShellExpressionFileFilter;
import com.sun.web.search.retrieval.SearchException;
import com.sun.web.search.util.CollectionConfig;
import com.sun.web.search.util.CollectionInfo;
import com.sun.web.search.util.SearchConfig;
import com.sun.web.search.util.Util;
import com.sun.web.search.util.VSNotFoundException;
import java.io.File;
import java.util.Properties;

public class SearchAdmin {
    private Options _options = null;
    private SearchConfig _sConfig = null;
    private IndexManager _mgr = null;
    private static String SCRIPT_NAME = "searchadmin ";
    private String _command = SCRIPT_NAME;
    private static String _rootDir = null;
    private static String SERVER_XML = "/config/server.xml";
    private static String BK_SERVER_XML = "/conf_bk/server.xml";
    private static final int ERR_USAGE = 1;
    private static final int ERR_INIT = 2;
    private static final int ERR_HANDLEIT = 3;

    public static void main(String[] stringArray) {
        SearchAdmin searchAdmin = new SearchAdmin();
        searchAdmin._options = searchAdmin.parseArgs(stringArray);
        if (searchAdmin._options == null) {
            searchAdmin.printUsage();
            System.exit(1);
        }
        if (!searchAdmin.initialize()) {
            System.exit(2);
        }
        if (!searchAdmin.handleIt()) {
            System.exit(3);
        }
    }

    private Options parseArgs(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Incomplete arguments.");
            return null;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this._command = this._command + stringArray[i] + " ";
        }
        return CommandLineParser.parse(stringArray);
    }

    private boolean initialize() {
        _rootDir = Util.getInstanceRoot();
        if (_rootDir == null) {
            System.err.println("installroot is not provided.");
            return false;
        }
        try {
            this._sConfig = new SearchConfig(this.getServerXML(), this._options.getVsId());
            this._sConfig.setAutoCommit(false);
            this._mgr = new IndexManager(this._sConfig);
        }
        catch (ConfigException configException) {
            this.printErrorToCgi("Could not read server.xml.");
            IndexingLog.log(configException.getMessage());
            return false;
        }
        catch (VSNotFoundException vSNotFoundException) {
            this.printErrorToCgi(vSNotFoundException.getMessage());
            IndexingLog.log(vSNotFoundException.getMessage());
            return false;
        }
        catch (IndexException indexException) {
            System.err.println(indexException.getMessage());
            IndexingLog.log(indexException.getMessage());
            return false;
        }
        return true;
    }

    private String getServerXML() {
        return _rootDir + File.separator + this._options.getInstanceId() + BK_SERVER_XML;
    }

    private boolean handleIt() {
        IndexDirectory indexDirectory = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = this._options.getAction();
            String string = this._options.getIndexPath();
            if (string == null || string.equals("")) {
                string = this.getPath();
            }
            string = Util.getCanonicalPath(string);
            indexDirectory = new IndexDirectory(string, false);
            IndexingLog.setLevel(3);
            IndexingLog.setDirectory(indexDirectory);
            switch (this._options.getAction()) {
                case 1: {
                    this.handleCreateCollCommand(indexDirectory);
                    stringBuffer.append("Collection '");
                    stringBuffer.append(this._options.getCollectionName());
                    stringBuffer.append("' successfully created.\n");
                    break;
                }
                case 2: {
                    this.handleConfigCollCommand();
                    break;
                }
                case 3: {
                    this.handleAddDocsCommand();
                    stringBuffer.append("Collection '");
                    stringBuffer.append(this._options.getCollectionName());
                    stringBuffer.append("' successfully updated.\n");
                    break;
                }
                case 4: {
                    this.handleRemoveDocsCommand();
                    stringBuffer.append("Collection '");
                    stringBuffer.append(this._options.getCollectionName());
                    stringBuffer.append("' successfully updated.\n");
                    break;
                }
                case 5: {
                    this.handleRemoveCollCommand();
                    break;
                }
                case 6: {
                    this.handleOptimizeCommand();
                    break;
                }
                case 7: {
                    this.handleReindexCommand();
                    stringBuffer.append("Collection '");
                    stringBuffer.append(this._options.getCollectionName());
                    stringBuffer.append("' successfully reindexed.\n");
                }
            }
            if (this._options.getAction() == 3 || this._options.getAction() == 4 || this._options.getAction() == 7) {
                Index index = this._mgr.getIndex(this._options.getCollectionName());
                stringBuffer.append(index.getNumProcessedDocs()).append(" documents processed.\n");
                if (this._options.getAction() == 7) {
                    stringBuffer.append(index.getNumUpdatedDocs()).append(" documents updated.\n");
                    stringBuffer.append(index.getNumRemOutdatedDocs()).append(" outdated entries removed.\n");
                } else {
                    stringBuffer.append(index.getNumProcessedDocs()).append(" documents indexed.\n");
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof SearchAdminException) {
                this.printErrorToCgi(exception.getMessage());
            } else {
                System.out.println(exception.getMessage());
            }
            exception.printStackTrace();
            IndexingLog.log(exception.getMessage());
            return false;
        }
        IndexingLog.log("succeeded");
        System.out.print(stringBuffer.toString());
        if (indexDirectory != null) {
            indexDirectory.getHistoryWriter().println(this._command);
            indexDirectory.getHistoryWriter().flush();
        }
        return true;
    }

    private void handleAddDocsCommand() throws Exception {
        IndexingLog.log("Adding documents:");
        IndexingLog.log("\tcollection=" + this._options.getCollectionName());
        IndexingLog.log("\tencoding=" + this._options.getEncoding());
        IndexingLog.log("\tpattern=" + this._options.getPattern());
        if (this._options.getEncoding() != null && !Util.isValidEncoding(this._options.getEncoding())) {
            throw new SearchAdminException("Invalid Encoding.");
        }
        CollectionConfig collectionConfig = this._sConfig.getCollectionConfig();
        Index index = this._mgr.getIndex(this._options.getCollectionName());
        Properties properties = index.getProperties();
        String string = (String)properties.get("excludeExtensions");
        ShellExpressionFileFilter shellExpressionFileFilter = new ShellExpressionFileFilter(this._options.getPattern(), this.getDocRoot(collectionConfig));
        shellExpressionFileFilter.setExtensions(string);
        index.addDirectory(this.getDocRoot(collectionConfig), this._options.getRecursive(), this._options.getEncoding(), shellExpressionFileFilter);
    }

    private void handleConfigCollCommand() throws ConfigException, SearchAdminException {
        IndexingLog.log("Modifying collection:");
        IndexingLog.log("\tcollection=" + this._options.getCollectionName());
        IndexingLog.log("\tdisplay name=" + this._options.getDisplayName());
        IndexingLog.log("\tdescription=" + this._options.getDescription());
        IndexingLog.log("\turi=" + this._options.getDocUri());
        CollectionConfig collectionConfig = this._sConfig.getCollectionConfig();
        collectionConfig.modifyCollection(this._options.getCollectionName(), this._options.getDisplayName(), this._options.getDescription(), this._options.getDocUri(), this._options.getEnabled(), null);
        this._sConfig.save();
    }

    private void handleCreateCollCommand(IndexDirectory indexDirectory) throws ConfigException, IndexException, Exception {
        if (this._options.getCollectionName().trim().equals("")) {
            throw new SearchAdminException("Collection name cannot be empty.");
        }
        if (this._options.getDirectory().trim().equals("")) {
            throw new SearchAdminException("Document root cannot be empty.");
        }
        if (this._options.getDocUri().trim().equals("")) {
            throw new SearchAdminException("Docuri cannot be empty.");
        }
        if (!Util.isValidId(this._options.getCollectionName().trim())) {
            throw new SearchAdminException("Collection name is not a valid ID.");
        }
        String string = this.getPath();
        String string2 = this._options.getIndexPath();
        if (string2 != null && !string2.trim().equals("")) {
            string = string2;
        }
        string = Util.getCanonicalPath(string);
        String string3 = Util.getCanonicalPath(this._options.getDirectory());
        IndexingLog.log("Creating collection:");
        IndexingLog.log("\tname=" + this._options.getCollectionName());
        IndexingLog.log("\tdirectory=" + string3);
        IndexingLog.log("\tpath=" + string);
        IndexingLog.log("\turi=" + this._options.getDocUri());
        File file = new File(string3);
        if (!(file.exists() && file.isDirectory())) {
            throw new SearchAdminException("The specified docroot '" + string3 + "' does not exist OR is not a directory.");
        }
        Index index = null;
        try {
            CollectionConfig collectionConfig = this._sConfig.getCollectionConfig();
            collectionConfig.createCollection(this._options.getCollectionName(), this._options.getDisplayName(), this._options.getDescription(), string3, string, this._options.getDocUri(), null);
            index = this._mgr.createIndex(this._options.getCollectionName(), new IndexDirectory(string, true), string3, this._options.getDocUri());
            this._sConfig.save();
        }
        catch (ConfigException configException) {
            IndexingLog.log("Config file error. " + configException);
            try {
                if (index != null) {
                    index.delete();
                } else if (indexDirectory != null) {
                    indexDirectory.cleanup();
                }
                this.deleteDirectory(this.getPath());
            }
            catch (IndexException indexException) {
                IndexingLog.log("index.delete call failed. " + indexException);
            }
            throw configException;
        }
    }

    public void handleOptimizeCommand() throws IndexException {
        IndexingLog.log("Optimizing collection:");
        IndexingLog.log("\tname=" + this._options.getCollectionName());
        CollectionConfig collectionConfig = this._sConfig.getCollectionConfig();
        Index index = this._mgr.getIndex(this._options.getCollectionName());
        index.optimize();
    }

    public void handleReindexCommand() throws IndexException, SearchException, Exception {
        IndexingLog.log("Reindexing:");
        IndexingLog.log("\tname=" + this._options.getCollectionName());
        CollectionConfig collectionConfig = this._sConfig.getCollectionConfig();
        Index index = this._mgr.getIndex(this._options.getCollectionName());
        if (index == null) {
            throw new SearchAdminException("Collection '" + this._options.getCollectionName() + "' does not exist.");
        }
        index.reindex();
    }

    public void handleRemoveCollCommand() throws ConfigException, IndexException, SearchAdminException {
        IndexingLog.log("Removing collection:");
        IndexingLog.log("\tname=" + this._options.getCollectionName());
        CollectionConfig collectionConfig = this._sConfig.getCollectionConfig();
        Index index = this._mgr.getIndex(this._options.getCollectionName());
        collectionConfig.deleteCollection(this._options.getCollectionName());
        index.delete();
        this.deleteDirectory(this.getPath());
        this._sConfig.save();
    }

    public void handleRemoveDocsCommand() throws SearchException, IndexException, Exception {
        IndexingLog.log("Removing documents:");
        IndexingLog.log("\tcollection=" + this._options.getCollectionName());
        IndexingLog.log("\tpattern=" + this._options.getPattern());
        CollectionConfig collectionConfig = this._sConfig.getCollectionConfig();
        String string = "";
        string = this.getDocRoot(collectionConfig);
        Index index = this._mgr.getIndex(this._options.getCollectionName());
        ShellExpressionFileFilter shellExpressionFileFilter = new ShellExpressionFileFilter(this._options.getPattern(), string);
        shellExpressionFileFilter.setExtensions("");
        index.removeDocuments(shellExpressionFileFilter);
    }

    private String getPath() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = SearchAdmin.getServerRoot();
        if (string == null) {
            string = ".";
        }
        string = Util.normalizePath(string);
        stringBuffer.append(string);
        stringBuffer.append("/").append(this._options.getInstanceId());
        stringBuffer.append("/").append("collections");
        stringBuffer.append("/").append(this._options.getVsId());
        stringBuffer.append("/").append(this._options.getCollectionName());
        return stringBuffer.toString();
    }

    private String getDocRoot(CollectionConfig collectionConfig) throws Exception {
        CollectionInfo collectionInfo = collectionConfig.getCollection(this._options.getCollectionName());
        if (collectionInfo == null) {
            throw new SearchAdminException("Collection " + this._options.getCollectionName() + " does not exist.");
        }
        return collectionInfo.getRootDirectory();
    }

    private void deleteDirectory(String string) throws SearchAdminException {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            throw new SearchAdminException("Couldn't delete directory specified by '" + string + "'");
        }
    }

    static String getServerRoot() {
        return _rootDir;
    }

    private void printErrorToCgi(String string) {
        System.out.println("ERROR:" + Util.jsEscape(string));
        IndexingLog.log(string);
    }

    void printUsage() {
        System.out.println("SearchAdmin <createcoll | configcoll | adddocs | removedocs | removecoll | reindexcoll> -instance <instance_name> -vs <vsid> -collection <collection_name> \\");
        System.out.println("");
        System.out.println("Action specific options:");
        System.out.println(" createcoll :::: ");
        System.out.println("                -displayname <display_name>");
        System.out.println("                -description <description>");
        System.out.println("                -docroot <document root>");
        System.out.println("                -path <collection files path>");
        System.out.println("                -docuri <docuri>");
        System.out.println("");
        System.out.println(" configcoll :::: ");
        System.out.println("                -displayname <display_name>");
        System.out.println("                -description <description>");
        System.out.println("                -docuri <docuri>");
        System.out.println("                -enabled <true | false>");
        System.out.println("");
        System.out.println(" adddocs :::: ");
        System.out.println("                -recursive <true | false>");
        System.out.println("                -pattern <pattern>");
        System.out.println("                -enc <enc>");
        System.out.println("");
        System.out.println(" removedocs :::: ");
        System.out.println("                -pattern <pattern>");
        System.out.println("");
    }
}

