/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.resource;

import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Connectionproperty;
import com.iplanet.ias.config.serverbeans.Customresource;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.Externaljndiresource;
import com.iplanet.ias.config.serverbeans.Jdbcconnectionpool;
import com.iplanet.ias.config.serverbeans.Jdbcresource;
import com.iplanet.ias.config.serverbeans.Mailresource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.ServerContextImpl;
import com.iplanet.ias.tools.common.dd.ResourceRef;
import com.iplanet.ias.web.WebModule;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.repository.ConnectionProperty;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.resource.JdbcDataSource;
import com.sun.enterprise.resource.PoolManagerImpl;
import com.sun.enterprise.resource.ProxyRefAddr;
import com.sun.enterprise.resource.util.ConnectionPoolValidator;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import org.apache.catalina.deploy.ContextResource;

public final class ResourceManager
extends ServerLifecycleImpl {
    public static final String CUSTOM_RESOURCE = "Custom Resource";
    public static final String EXTERNALJNDI_RESOURCE = "External JNDI Resource";
    public static final String JDBC_CONNECTION_POOL = "Jdbc Connection Pool";
    public static final String JDBC_RESOURCE = "Jdbc Resource";
    public static final String MAIL_RESOURCE = "Mail Resource";
    public static final String RESOURCE_FACTORY_CLASS_NAME = "com.sun.web.naming.ResourceFactory";
    public static final String RESOURCE_FACTORY_LOCATION = null;
    public static final String ADDR_GLOBAL_RESOURCE_JNDI_NAME = "com.sun.web.resource.global_resource_jndi_name";
    public static final String MAIL_SESSION_FACTORY = "org.apache.naming.factory.MailSessionFactory";
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private boolean _isFineLevel = _logger.isLoggable(Level.FINE);
    private PoolManager poolManager = null;
    private HashMap jdbcConnectionPoolResourceMap = null;
    private HashMap webAppBindings = new HashMap();
    private HashMap resourceRefBindings = new HashMap();

    public JdbcConnectionPool getJDBCConnectionPoolResource(String string) {
        if (this.jdbcConnectionPoolResourceMap == null) {
            return null;
        }
        return (JdbcConnectionPool)this.jdbcConnectionPoolResourceMap.get(string);
    }

    public WebModule getBoundWebApp() {
        return (WebModule)this.webAppBindings.get(Thread.currentThread().getContextClassLoader());
    }

    public void setWebAppBinding(WebModule webModule) {
        this.webAppBindings.put(Thread.currentThread().getContextClassLoader(), webModule);
        this.parseResourceRefDescriptors(webModule);
    }

    public void removeWebAppBinding() {
        this.webAppBindings.remove(Thread.currentThread().getContextClassLoader());
        this.resourceRefBindings.remove(Thread.currentThread().getContextClassLoader());
    }

    private void parseResourceRefDescriptors(WebModule webModule) {
        ResourceRef[] resourceRefArray = webModule.getIasWebAppConfigBean().getResourceRef();
        if (resourceRefArray.length < 1) {
            return;
        }
        HashMap<String, ContextResource> hashMap = new HashMap<String, ContextResource>(resourceRefArray.length);
        for (int i = 0; i < resourceRefArray.length; ++i) {
            hashMap.put(resourceRefArray[i].getJndiName(), webModule.findResource(resourceRefArray[i].getResRefName()));
        }
        this.resourceRefBindings.put(Thread.currentThread().getContextClassLoader(), hashMap);
    }

    public ContextResource getResRefDescriptorByGlobalJNDIName(String string) {
        HashMap hashMap = (HashMap)this.resourceRefBindings.get(Thread.currentThread().getContextClassLoader());
        if (hashMap == null) {
            return null;
        }
        return (ContextResource)hashMap.get(string);
    }

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        Resources resources = this.getResourcesBean(serverContext);
        if (resources == null) {
            return;
        }
        this.loadCustomResources(serverContext, resources.getCustomresource());
        this.loadExternalJNDIResources(serverContext, resources.getExternaljndiresource());
        this.loadJDBCConnectionPoolResources(serverContext, resources.getJdbcconnectionpool());
        this.loadJDBCResources(serverContext, resources.getJdbcresource());
        this.loadMailResources(serverContext, resources.getMailresource());
        this.poolManager = new PoolManagerImpl();
        ((ServerContextImpl)serverContext).setResourceManager(this);
        _logger.log(Level.FINE, "resource.manager.initialized");
    }

    public PoolManager getPoolManager() {
        return this.poolManager;
    }

    private void loadCustomResources(ServerContext serverContext, Customresource[] customresourceArray) throws ServerLifecycleException {
        for (int i = 0; i < customresourceArray.length; ++i) {
            String string = customresourceArray[i].getJndiname();
            if (customresourceArray[i].isEnabled()) {
                Reference reference = new Reference(customresourceArray[i].getRestype(), customresourceArray[i].getFactoryclass(), null);
                this.addPropertiesAsAddrs(reference, customresourceArray[i].getElementProperty());
                this.bindObject(serverContext, string, reference);
                this.logInstalledResource(string, CUSTOM_RESOURCE);
                continue;
            }
            this.logDisabledResource(string, CUSTOM_RESOURCE);
        }
    }

    private void loadExternalJNDIResources(ServerContext serverContext, Externaljndiresource[] externaljndiresourceArray) throws ServerLifecycleException {
        if (externaljndiresourceArray == null || externaljndiresourceArray.length < 1) {
            return;
        }
        String string = null;
        for (int i = 0; i < externaljndiresourceArray.length; ++i) {
            try {
                string = externaljndiresourceArray[i].getJndiname();
                if (externaljndiresourceArray[i].isEnabled()) {
                    String string2 = externaljndiresourceArray[i].getFactoryclass();
                    String string3 = externaljndiresourceArray[i].getJndilookupname();
                    Object object = Utility.loadObject(string2);
                    if (object == null) {
                        _logger.log(Level.WARNING, "resource.ext.jndi.factory_load_error", string2);
                        return;
                    }
                    if (!(object instanceof InitialContextFactory)) {
                        _logger.log(Level.WARNING, "resource.ext.jndi.factory_class_unexpected", string2);
                        return;
                    }
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    ElementProperty[] elementPropertyArray = externaljndiresourceArray[i].getElementProperty();
                    for (int j = 0; j < elementPropertyArray.length; ++j) {
                        hashtable.put(elementPropertyArray[j].getName(), elementPropertyArray[j].getValue());
                    }
                    Context context = null;
                    try {
                        context = ((InitialContextFactory)object).getInitialContext(hashtable);
                    }
                    catch (NamingException namingException) {
                        _logger.log(Level.WARNING, "resource.ext.jndi.initial_context_error", string2);
                        _logger.log(Level.WARNING, "resource.ext.jndi.initial_context_error_excp", namingException.getMessage());
                    }
                    if (context == null) {
                        _logger.log(Level.WARNING, "resource.ext.jndi.factory_create_error", string);
                        return;
                    }
                    Reference reference = new Reference(externaljndiresourceArray[i].getRestype(), "com.sun.enterprise.resource.JndiProxyObjectFactory", null);
                    reference.add(new StringRefAddr("jndiName", string));
                    reference.add(new StringRefAddr("jndiLookupName", string3));
                    reference.add(new StringRefAddr("jndiFactoryClass", string2));
                    reference.add(new ProxyRefAddr(string, hashtable));
                    this.bindObject(serverContext, string, reference);
                    this.logInstalledResource(string, EXTERNALJNDI_RESOURCE);
                    continue;
                }
                this.logDisabledResource(string, EXTERNALJNDI_RESOURCE);
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "resource.ext.jndi.create_ref_error", string);
                _logger.log(Level.SEVERE, "resource.ext.jndi.create_ref_error_excp", exception);
            }
        }
    }

    private void loadJDBCConnectionPoolResources(ServerContext serverContext, Jdbcconnectionpool[] jdbcconnectionpoolArray) throws ServerLifecycleException {
        if (jdbcconnectionpoolArray == null || jdbcconnectionpoolArray.length < 1) {
            return;
        }
        this.jdbcConnectionPoolResourceMap = new HashMap();
        for (int i = 0; i < jdbcconnectionpoolArray.length; ++i) {
            Connectionproperty[] connectionpropertyArray;
            int n;
            String string = jdbcconnectionpoolArray[i].getName();
            JdbcConnectionPool jdbcConnectionPool = new JdbcConnectionPool(string);
            jdbcConnectionPool.setDatasourceClassname(jdbcconnectionpoolArray[i].getDatasourceclassname());
            jdbcConnectionPool.setMaxPoolSize(jdbcconnectionpoolArray[i].getMaxpoolsize());
            jdbcConnectionPool.setSteadyPoolSize(jdbcconnectionpoolArray[i].getSteadypoolsize());
            jdbcConnectionPool.setMaxWaitTimeInMillis(jdbcconnectionpoolArray[i].getMaxwaittime());
            jdbcConnectionPool.setPoolResizeQuantity(jdbcconnectionpoolArray[i].getPoolresizequantity());
            jdbcConnectionPool.setIdleTimeoutInSeconds(jdbcconnectionpoolArray[i].getIdletimeout());
            jdbcConnectionPool.setIsConnectionValidationRequired(jdbcconnectionpoolArray[i].isConnectionvalidationrequired());
            jdbcConnectionPool.setConnectionValidationMethod(jdbcconnectionpoolArray[i].getConnectionvalidationmethod());
            jdbcConnectionPool.setValidationTableName(jdbcconnectionpoolArray[i].getValidationtablename());
            jdbcConnectionPool.setFailAllConnections(jdbcconnectionpoolArray[i].isFailallconnections());
            jdbcConnectionPool.setTransactionIsolationLevel(jdbcconnectionpoolArray[i].getTransactionisolationlevel());
            jdbcConnectionPool.setIsIsolationLevelGuaranteed(jdbcconnectionpoolArray[i].isIsolationlevelguaranteed());
            ElementProperty[] elementPropertyArray = jdbcconnectionpoolArray[i].getElementProperty();
            if (elementPropertyArray != null) {
                for (n = 0; n < elementPropertyArray.length; ++n) {
                    ElementProperty elementProperty = elementPropertyArray[n];
                    ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl(elementProperty.getName(), elementProperty.getValue());
                    jdbcConnectionPool.addProperty(resourcePropertyImpl);
                }
            }
            if ((connectionpropertyArray = jdbcconnectionpoolArray[i].getConnectionproperty()) != null) {
                for (n = 0; n < connectionpropertyArray.length; ++n) {
                    ConnectionProperty connectionProperty = new ConnectionProperty(connectionpropertyArray[n].getName(), connectionpropertyArray[n].getValue(), connectionpropertyArray[n].getInvocationfrequency());
                    jdbcConnectionPool.addConnectionProperty(connectionProperty);
                }
            }
            if (!ConnectionPoolValidator.validate(jdbcConnectionPool)) {
                Object[] objectArray = new Object[]{jdbcConnectionPool.getName()};
                String string2 = Utility.getLocalizedString(_logger, "resource.jdbc.invalid_pool_declaration", objectArray);
                throw new ServerLifecycleException(string2);
            }
            this.jdbcConnectionPoolResourceMap.put(jdbcConnectionPool.getName(), jdbcConnectionPool);
            this.logInstalledResource(jdbcConnectionPool.getName(), JDBC_CONNECTION_POOL);
        }
    }

    private void loadJDBCResources(ServerContext serverContext, Jdbcresource[] jdbcresourceArray) throws ServerLifecycleException {
        if (jdbcresourceArray == null || jdbcresourceArray.length < 1) {
            return;
        }
        for (int i = 0; i < jdbcresourceArray.length; ++i) {
            String string = jdbcresourceArray[i].getJndiname();
            if (jdbcresourceArray[i].isEnabled()) {
                JdbcConnectionPool jdbcConnectionPool = this.getJDBCConnectionPoolResource(jdbcresourceArray[i].getPoolname());
                if (jdbcConnectionPool == null) {
                    _logger.log(Level.INFO, "resource.jdbc.pool_does_not_exist", new String[]{string, jdbcresourceArray[i].getPoolname()});
                    continue;
                }
                JdbcDataSource jdbcDataSource = new JdbcDataSource();
                jdbcDataSource.setDataSourceName(jdbcresourceArray[i].getPoolname());
                jdbcDataSource.setJndiName(string);
                jdbcDataSource.setUserName(jdbcConnectionPool.getUserName());
                jdbcDataSource.setPassword(jdbcConnectionPool.getPassword());
                this.bindObject(serverContext, string, jdbcDataSource);
                this.logInstalledResource(string, JDBC_RESOURCE);
                continue;
            }
            this.logDisabledResource(string, JDBC_RESOURCE);
        }
    }

    private void loadMailResources(ServerContext serverContext, Mailresource[] mailresourceArray) throws ServerLifecycleException {
        for (int i = 0; i < mailresourceArray.length; ++i) {
            String string = mailresourceArray[i].getJndiname();
            if (mailresourceArray[i].isEnabled()) {
                Reference reference = new Reference("javax.mail.Session", MAIL_SESSION_FACTORY, null);
                String string2 = mailresourceArray[i].getStoreprotocol();
                reference.add(new StringRefAddr("mail.store.protocol", string2));
                reference.add(new StringRefAddr("mail." + string2 + ".class", mailresourceArray[i].getStoreprotocolclass()));
                String string3 = mailresourceArray[i].getTransportprotocol();
                reference.add(new StringRefAddr("mail.transport.protocol", string3));
                reference.add(new StringRefAddr("mail." + string3 + ".class", mailresourceArray[i].getTransportprotocolclass()));
                reference.add(new StringRefAddr("mail.host", mailresourceArray[i].getHost()));
                reference.add(new StringRefAddr("mail.user", mailresourceArray[i].getUser()));
                reference.add(new StringRefAddr("mail.from", mailresourceArray[i].getFrom()));
                this.addPropertiesAsAddrs(reference, mailresourceArray[i].getElementProperty());
                this.bindObject(serverContext, string, reference);
                this.logInstalledResource(string, MAIL_RESOURCE);
                continue;
            }
            this.logDisabledResource(string, MAIL_RESOURCE);
        }
    }

    private Resources getResourcesBean(ServerContext serverContext) throws ServerLifecycleException {
        try {
            return (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext.getConfigContext(), ServerXPathHelper.XPATH_RESOURCES);
        }
        catch (ConfigException configException) {
            throw new ServerLifecycleException(configException);
        }
    }

    private void logInstalledResource(String string, String string2) {
        if (this._isFineLevel) {
            _logger.log(Level.FINE, "resource.installed", new String[]{string2, string});
        }
    }

    private void logDisabledResource(String string, String string2) {
        if (this._isFineLevel) {
            _logger.log(Level.FINE, "resource.disabled", new String[]{string2, string});
        }
    }

    public static void createSubcontexts(Context context, String string) throws NamingException {
        Context context2 = context;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("") || !stringTokenizer.hasMoreTokens()) continue;
            try {
                context2 = context2.createSubcontext(string2);
            }
            catch (NamingException namingException) {
                context2 = (Context)context2.lookup(string2);
            }
        }
    }

    private void bindObject(ServerContext serverContext, String string, Object object) throws ServerLifecycleException {
        try {
            ResourceManager.createSubcontexts(serverContext.getNamingContext(), string);
            serverContext.getNamingContext().bind(string, object);
        }
        catch (NamingException namingException) {
            throw new ServerLifecycleException(namingException);
        }
    }

    private void addPropertiesAsAddrs(Reference reference, ElementProperty[] elementPropertyArray) {
        if (elementPropertyArray == null || elementPropertyArray.length < 1) {
            return;
        }
        for (int i = 0; i < elementPropertyArray.length; ++i) {
            reference.add(new StringRefAddr(elementPropertyArray[i].getName(), elementPropertyArray[i].getValue()));
        }
    }
}

