/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.serverbeans.Security;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RoleMapper
implements Serializable {
    private static boolean debug;
    private static Hashtable roleMaps;
    private static final String DEFAULT_ROLE_NAME = "ANYONE";
    private static final String ROLE_IS_NOT_A_GROUP = "com.sun.enterprise.security.acl.roleIsNotAGroup";
    private static Role defaultRole;
    private static String defaultRoleName;
    private static Logger _logger;
    private Hashtable prinTable = new Hashtable();
    private Hashtable roleTable = new Hashtable();
    private String appName;
    private boolean considerRoleAGroup = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoleMapper getRoleMapper(String string) {
        if (!roleMaps.containsKey(string)) {
            Class clazz = RoleMapper.class;
            synchronized (clazz) {
                roleMaps.put(string, new RoleMapper(string));
            }
        }
        return (RoleMapper)roleMaps.get(string);
    }

    public void assignRole(Principal principal, Role role) {
        this.createMapping(this.prinTable, principal, role);
        this.createMapping(this.roleTable, role, principal);
    }

    public boolean hasRole(Principal principal, String string, String string2) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "PRINCIPAL : " + principal + " hasRole?: " + string);
            _logger.log(Level.FINEST, "PRINCIPAL TABLE: " + this.prinTable);
        }
        if (string != null && string.equals(defaultRoleName)) {
            return true;
        }
        HashSet hashSet = (HashSet)this.prinTable.get(principal);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, this.toString());
            _logger.log(Level.FINEST, "Principal: " + principal + " directly maps to roles: " + hashSet);
        }
        Role role = new Role(string);
        if (hashSet != null && hashSet.contains(role)) {
            return true;
        }
        return this.isPrincipalInMappedGroups(principal.getName(), role, string2);
    }

    private RoleMapper(String string) {
        this.appName = string;
        RoleMapper.initDefaultRole();
        if (System.getProperty(ROLE_IS_NOT_A_GROUP) != null) {
            this.considerRoleAGroup = false;
            _logger.fine("Roles names will not be considered to be group names.");
        }
    }

    private static synchronized void initDefaultRole() {
        if (defaultRole == null) {
            defaultRoleName = DEFAULT_ROLE_NAME;
            try {
                ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
                if (!$assertionsDisabled && configContext == null) {
                    throw new AssertionError();
                }
                Server server = ServerBeansFactory.getServerBean(configContext);
                if (!$assertionsDisabled && server == null) {
                    throw new AssertionError();
                }
                Security security = server.getJava().getSecurity();
                if (!$assertionsDisabled && security == null) {
                    throw new AssertionError();
                }
                defaultRoleName = security.getAnonymousrole();
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "java_security.anonymous_role_reading_exception", exception);
            }
            _logger.log(Level.FINE, "Default role is: " + defaultRoleName);
            defaultRole = new Role(defaultRoleName);
        }
    }

    private synchronized void createMapping(Hashtable hashtable, Principal principal, Principal principal2) {
        if (!hashtable.containsKey(principal)) {
            hashtable.put(principal, new HashSet());
        }
        HashSet hashSet = (HashSet)hashtable.get(principal);
        hashSet.add(principal2);
    }

    private boolean isPrincipalInMappedGroups(String string, Role role, String string2) {
        Realm realm = Realm.getInstance(string2);
        if (realm == null) {
            return false;
        }
        try {
            if (this.considerRoleAGroup && realm.isUserInGroup(string, role.getName())) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Principal [" + string + "] belongs to a group " + "named after role [" + role.getName() + "]");
                }
                return true;
            }
            HashSet hashSet = (HashSet)this.roleTable.get(role);
            if (hashSet != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    Object e = iterator.next();
                    if (!(e instanceof Group) || !realm.isUserInGroup(string, string3 = ((Group)e).getName())) continue;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Principal [" + string + "] is " + "in group [" + string3 + "] which " + "maps to role [" + role.getName() + "] " + "in realm [" + string2 + "]");
                    }
                    return true;
                }
            }
        }
        catch (Exception exception) {
            _logger.fine("Error while checking groups: " + exception);
        }
        return false;
    }

    private Enumeration getRoles() {
        return this.roleTable.keys();
    }

    private Enumeration getGroupsAssignedTo(Role role) {
        Vector vector = new Vector();
        HashSet hashSet = (HashSet)this.roleTable.get(role);
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Group)) continue;
                vector.add(e);
            }
        }
        return vector.elements();
    }

    private Enumeration getUsersAssignedTo(Role role) {
        Vector vector = new Vector();
        HashSet hashSet = (HashSet)this.roleTable.get(role);
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Group) continue;
                vector.add(e);
            }
        }
        return vector.elements();
    }

    public String toString() {
        String string = "RoleMapper";
        Enumeration enumeration = this.getRoles();
        while (enumeration.hasMoreElements()) {
            Role role = (Role)enumeration.nextElement();
            Enumeration enumeration2 = null;
            string = string + " : " + role + "(";
            enumeration2 = this.getGroupsAssignedTo(role);
            while (enumeration2.hasMoreElements()) {
                string = string + enumeration2.nextElement();
                if (!enumeration2.hasMoreElements()) continue;
                string = string + ",";
            }
            string = string + ")(";
            enumeration2 = this.getUsersAssignedTo(role);
            while (enumeration2.hasMoreElements()) {
                string = string + enumeration2.nextElement();
                if (!enumeration2.hasMoreElements()) continue;
                string = string + ",";
            }
            string = string + ")";
        }
        return string;
    }

    static {
        $assertionsDisabled = !RoleMapper.class.desiredAssertionStatus();
        debug = false;
        roleMaps = new Hashtable();
        defaultRole = null;
        defaultRoleName = null;
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

