/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.mapping;

import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Field {
    private static Logger _logger;
    private static ResourceBundle _rb;
    protected String name;
    protected int scope;

    public Field(String string, String string2) throws IllegalArgumentException {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        _rb = _logger.getResourceBundle();
        this.name = string;
        this.scope = this.parseScope(string2);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    private int parseScope(String string) throws IllegalArgumentException {
        int n;
        if ("context.attribute".equals(string)) {
            n = 1;
        } else if ("request.header".equals(string)) {
            n = 2;
        } else if ("request.parameter".equals(string)) {
            n = 3;
        } else if ("request.cookie".equals(string)) {
            n = 4;
        } else if ("session.attribute".equals(string)) {
            n = 5;
        } else if ("session.id".equals(string)) {
            n = 6;
        } else {
            String string2 = _rb.getString("cache.mapping.incorrectScope");
            Object[] objectArray = new Object[]{string, this.name};
            string2 = MessageFormat.format(string2, objectArray);
            throw new IllegalArgumentException(string2);
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public int getScope() {
        return this.scope;
    }

    public Object getValue(ServletContext servletContext, HttpServletRequest httpServletRequest) {
        Object object = null;
        block0 : switch (this.scope) {
            case 1: {
                object = servletContext.getAttribute(this.name);
                break;
            }
            case 2: {
                object = httpServletRequest.getHeader(this.name);
                break;
            }
            case 3: {
                object = httpServletRequest.getParameter(this.name);
                break;
            }
            case 4: {
                Cookie[] cookieArray = httpServletRequest.getCookies();
                for (int i = 0; i < cookieArray.length; ++i) {
                    if (!this.name.equals(cookieArray[i].getName())) continue;
                    object = cookieArray[i].getValue();
                    break block0;
                }
                break;
            }
            case 6: {
                HttpSession httpSession = httpServletRequest.getSession(false);
                if (httpSession == null) break;
                object = httpSession.getId();
                break;
            }
            case 5: {
                HttpSession httpSession = httpServletRequest.getSession(false);
                if (httpSession == null) break;
                object = httpSession.getAttribute(this.name);
            }
        }
        return object;
    }

    static {
        _rb = null;
    }
}

