/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

class BaseFilterImpl {
    protected Hashtable filters_ = null;
    protected String prefix_ = null;
    protected String suffix_ = null;
    private String description_ = null;
    private String fullDescription_ = null;
    private boolean useExtensionsInDescription_ = true;

    public BaseFilterImpl(String string, String string2, String[] stringArray, String string3) {
        if (stringArray != null) {
            this.filters_ = new Hashtable(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.addExtension(stringArray[i]);
            }
        } else {
            this.filters_ = new Hashtable();
        }
        this.prefix_ = string;
        this.suffix_ = string2;
        this.setDescription(string3);
    }

    public static String getName(File file) {
        if (file != null) {
            return BaseFilterImpl.getName(file.getName());
        }
        return null;
    }

    public static String getName(String string) {
        if (string != null) {
            int n = string.lastIndexOf(46);
            int n2 = string.lastIndexOf(47);
            n2 = n2 == -1 || n2 > n ? 0 : ++n2;
            if (n != -1) {
                return string.substring(n2, n);
            }
            return string;
        }
        return null;
    }

    public static String getExtension(File file) {
        if (file != null) {
            return BaseFilterImpl.getExtension(file.getName());
        }
        return null;
    }

    public static String getExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        if (string != null) {
            int n = string.lastIndexOf(46);
            if (n >= 0 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            this.filters_.put(string.toLowerCase(), this);
            this.fullDescription_ = null;
        }
    }

    public final String getDescription() {
        if (this.fullDescription_ == null) {
            if (this.description_ == null || this.isExtensionListInDescription()) {
                if (this.description_ != null) {
                    this.fullDescription_ = this.description_;
                }
                this.fullDescription_ = this.fullDescription_ + " (";
                Enumeration enumeration = this.filters_.keys();
                if (enumeration != null) {
                    this.fullDescription_ = this.fullDescription_ + "." + (String)enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        this.fullDescription_ = this.fullDescription_ + ", " + (String)enumeration.nextElement();
                    }
                }
                this.fullDescription_ = this.fullDescription_ + ")";
            } else {
                this.fullDescription_ = this.description_;
            }
        }
        return this.fullDescription_;
    }

    public final void setDescription(String string) {
        this.description_ = string;
        this.fullDescription_ = null;
    }

    public final void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription_ = bl;
        this.fullDescription_ = null;
    }

    public final boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription_;
    }

    protected boolean accept(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            boolean bl2 = true;
            if (this.filters_ != null) {
                bl2 = false;
                String string2 = BaseFilterImpl.getExtension(string);
                if (string2 != null && this.filters_.get(string2) != null) {
                    bl2 = true;
                }
            }
            boolean bl3 = true;
            boolean bl4 = true;
            if (this.prefix_ != null || this.suffix_ != null) {
                String string3 = BaseFilterImpl.getName(string);
                if (this.prefix_ != null) {
                    bl3 = false;
                    if (string3 != null) {
                        bl3 = string3.startsWith(this.prefix_);
                    }
                }
                if (this.suffix_ != null) {
                    bl4 = false;
                    if (string3 != null) {
                        bl4 = string3.endsWith(this.suffix_);
                    }
                }
            }
            bl = bl2 & bl3 & bl4;
        }
        return bl;
    }
}

