/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.session.MMapSession;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class MMapSessionManager
extends IWSHttpSessionManager {
    private boolean _initialized = false;
    private boolean _is_usable = false;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private long _nativePtr = 0L;
    private int _timeOut = 0;
    private int _maxSessions = 0;
    private int _reapCount = 0;
    protected Hashtable _sessions = new Hashtable();
    public static final String prop_timeOut = "timeOut";
    public static final String prop_maxSessions = "maxSessions";
    public static final String prop_maxValueSize = "maxValueSize";
    public static final String prop_maxValuesPerSession = "maxValuesPerSession";

    public synchronized void init(Properties properties) throws Exception {
        String string;
        File file;
        String string2;
        if (this._initialized) {
            return;
        }
        int n = 10;
        int n2 = 4096;
        this._maxSessions = 1000;
        this._timeOut = 1800;
        if (properties != null) {
            string2 = properties.getProperty(prop_maxSessions);
            if (string2 != null) {
                try {
                    this._maxSessions = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = properties.getProperty(prop_maxValuesPerSession)) != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = properties.getProperty(prop_maxValueSize)) != null) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = properties.getProperty(prop_timeOut)) != null) {
                try {
                    this._timeOut = Integer.parseInt(string2);
                    if (this._timeOut < 0) {
                        this._timeOut = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((string2 = properties.getProperty("session-data-dir")) == null) {
            string2 = "../SessionData/";
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if (!(file = new File(string2)).isDirectory()) {
            if (!file.mkdirs()) {
                LogUtil.logFailure(_res.getProp("session.MMapSessionManager.msg_DirCreateFailed", string2));
            } else {
                LogUtil.logInfo(_res.getProp("session.MMapSessionManager.msg_mmapDir", string2));
            }
        }
        if ((string = properties.getProperty("session-context-name")) == null) {
            string = "default-mmapsessionmanager";
        }
        int n3 = 0;
        String string3 = properties.getProperty("maxLocks");
        if (string3 != null) {
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.logWarning(_res.getProp("session.IWSSessionManager.msg_maxLocksNotValid ", new Integer(10)));
            }
        }
        this._nativePtr = this._cppInit(string2, n2, this._maxSessions, n, this._timeOut, string, n3);
        this._is_usable = this._isSessionMangerUsable(this._nativePtr);
        if (!this._is_usable) {
            throw new Exception(_res.getProp("session.MMapSessionManager.msg_createNativeFailed"));
        }
        this._cacheSessionFieldReference();
        LogUtil.logInfo(_res.getProp("session.MMapSessionManager.msg_sessionMgrInit", new Integer(this._maxSessions), (Object)new Integer(n), (Object)new Integer(n2), (Object)new Integer(this._timeOut)));
    }

    public HttpSession createSession(String string) {
        return this.createSession(string, null);
    }

    public HttpSession createSession(String string, ServletContext servletContext) {
        if (!this._is_usable) {
            return null;
        }
        MMapSession mMapSession = null;
        try {
            mMapSession = new MMapSession(string, this._timeOut, this, servletContext);
        }
        catch (NullPointerException nullPointerException) {
            LogUtil.logInfo(_res.getProp("session.MMapSessionManager.msg_TooManySessions", this.getMaxSession()));
            mMapSession = null;
        }
        if (mMapSession != null) {
            this._sessions.put(string, mMapSession);
        }
        return mMapSession;
    }

    public int getDefaultTimeOut() {
        return this._timeOut;
    }

    public void deleteSession(HttpSession httpSession) {
        this._deleteSession(httpSession);
    }

    public boolean _deleteSession(HttpSession httpSession) {
        if (!this._is_usable || httpSession == null) {
            return false;
        }
        MMapSession mMapSession = null;
        try {
            mMapSession = (MMapSession)httpSession;
        }
        catch (ClassCastException classCastException) {
            LogUtil.logWarning(_res.getProp("session.MMapSessionManager.msg_sessionType"));
            return false;
        }
        String string = ((MMapSession)httpSession).getIdWithoutExceptions();
        if (this._destroySession(this._nativePtr, string, mMapSession.getLocation())) {
            mMapSession.removeAllObjects();
            this._sessions.remove(string);
            return true;
        }
        return false;
    }

    public HttpSession getSession(String string) {
        return this.getSession(string, null);
    }

    public HttpSession getSession(String string, ServletContext servletContext) {
        if (!this._is_usable) {
            return null;
        }
        MMapSession mMapSession = null;
        mMapSession = (MMapSession)this._sessions.get(string);
        if (mMapSession == null) {
            try {
                mMapSession = new MMapSession(string, this._timeOut, this, servletContext, false);
            }
            catch (NullPointerException nullPointerException) {
                mMapSession = null;
            }
            if (mMapSession != null) {
                this._sessions.put(string, mMapSession);
            }
        }
        if (mMapSession != null) {
            try {
                mMapSession.loadSessionData();
            }
            catch (IllegalStateException illegalStateException) {
                this.deleteSession(mMapSession);
                mMapSession = null;
            }
        }
        return mMapSession;
    }

    public void reaper() {
        Object object;
        if (!this._is_usable) {
            return;
        }
        Object object2 = null;
        int n = 0;
        int n2 = 0;
        long l = System.currentTimeMillis();
        Enumeration enumeration = this._sessions.elements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object = (MMapSession)enumeration.nextElement();
                if (((MMapSession)object).isInvalid(l)) {
                    if (object2 == null) {
                        object2 = ((MMapSession)object).getServletContext();
                    }
                    if (((MMapSession)object).isInUse() || !this._deleteSession((HttpSession)object)) continue;
                    ++this._reapCount;
                    object = null;
                    ++n;
                    continue;
                }
                ++n2;
            }
        }
        if (n > 0) {
            object = object2 != null ? object2.toString() : "";
            int n3 = 0;
            if (this.getHandleFormLoginSessions()) {
                n3 = n2;
            }
            LogUtil.logInfo("MMAP session reaper stats: " + (String)object + " number of live sessions = " + n2 + ", number of sessions expired/total = " + n + "/" + this._reapCount + ", number of live form-login sessions = " + n3);
        }
    }

    public int getMaxSession() {
        return this._maxSessions;
    }

    public int getSessionCount() {
        return this._sessions.size();
    }

    public int getSessionReapCount() {
        return this._reapCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MMapSessionManager mMapSessionManager = this;
        synchronized (mMapSessionManager) {
            super.close();
            if (this._nativePtr != 0L) {
                this._cppDestroy(this._nativePtr);
                this._nativePtr = 0L;
            } else {
                LogUtil.logFailure(_res.getProp("session.MMapSessionManager.msg_alreadyClosed"));
            }
        }
    }

    protected long getNativePtr() {
        return this._nativePtr;
    }

    private int nativeReap() {
        int n = this._run_C_side_reaper(this._nativePtr);
        return n;
    }

    public void update(HttpSession httpSession) {
        try {
            ((MMapSession)httpSession).saveSessionData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean unlock(String string) {
        if (string == null) {
            return false;
        }
        MMapSession mMapSession = (MMapSession)this._sessions.get(string);
        if (mMapSession == null) {
            return false;
        }
        return this._unlock(this._nativePtr, string, mMapSession.getLocation());
    }

    private native long _cppInit(String var1, int var2, int var3, int var4, int var5, String var6, int var7);

    private native void _cppDestroy(long var1);

    private native boolean _isSessionMangerUsable(long var1);

    private native boolean _isValidSession(long var1, String var3);

    private native boolean _destroySession(long var1, String var3, long var4);

    private native int _run_C_side_reaper(long var1);

    private native void _cacheSessionFieldReference();

    private native boolean _unlock(long var1, String var3, long var4);
}

