/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.ias.web.session.IWS60SessionBase;
import com.iplanet.server.http.session.IWSHttpSessionInputStream;
import com.iplanet.server.http.session.MMapSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class MMapSession
extends IWS60SessionBase
implements HttpSession {
    private static final String MMAPSESSION_BLOB_NAME = "httpsession";
    private String _id = null;
    private byte[] _idBytes = null;
    private boolean _isValid = true;
    private boolean _expiring = false;
    private boolean _newSession = false;
    private MMapSessionManager _mgr = null;
    private int _numObjectsToBeUnbound = 0;
    private long _nativeMgr = 0L;
    private Hashtable _values;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private ServletContext _context = null;
    private long _location = -1L;
    private long _lastAccessedTime;
    private long _maxInactiveInterval;
    private long _creationTime;
    private long _currentAccessTime;
    private boolean _inUse = true;
    private boolean _timingOut = false;

    public MMapSession(String string, int n, MMapSessionManager mMapSessionManager, ServletContext servletContext, boolean bl) throws NullPointerException {
        this._id = string;
        this._idBytes = this._id.getBytes();
        this._mgr = mMapSessionManager;
        this._nativeMgr = this._mgr.getNativePtr();
        this._context = servletContext;
        this._prevReqEndTime = 0L;
        this.setMaxInactiveInterval(n);
        this._location = bl ? this._createSession(this._nativeMgr, this._idBytes, n) : this._getSession(this._nativeMgr, this._idBytes);
        if (this._location == -1L) {
            this._isValid = false;
            throw new NullPointerException();
        }
        if (bl) {
            this._values = new Hashtable();
            this._newSession = true;
        }
    }

    public MMapSession(String string, int n, MMapSessionManager mMapSessionManager, ServletContext servletContext) throws NullPointerException {
        this(string, n, mMapSessionManager, servletContext, true);
    }

    public boolean isNew() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._newSession;
    }

    public String getId() {
        return this._id;
    }

    public HttpSessionContext getSessionContext() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._mgr.getContext();
    }

    public boolean isInvalid(long l) {
        if (!this._isValid) {
            return true;
        }
        if (this._prevReqEndTime <= 0L) {
            return false;
        }
        long l2 = l / 1000L - this._prevReqEndTime;
        if (l2 >= this._maxInactiveInterval) {
            this._isValid = false;
            this._timingOut = true;
            return true;
        }
        return false;
    }

    private boolean _isInvalid() {
        return this.isInvalid(this._currentAccessTime);
    }

    protected String getIdWithoutExceptions() {
        return this._id;
    }

    public Object getValue(String string) {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException(_res.getProp("session.MMapSession.msg_namevalueNull"));
        }
        return this._values.get(string);
    }

    public Object getAttribute(String string) {
        return this.getValue(string);
    }

    public void putValue(String string, Object object) {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        if (string == null || object == null) {
            throw new NullPointerException(_res.getProp("session.MMapSession.msg_namevalueNull"));
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException(_res.getProp("session.MMapSession.msg_badAttribute", string));
        }
        this._values.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            ++this._numObjectsToBeUnbound;
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public void setAttribute(String string, Object object) {
        this.putValue(string, object);
    }

    public void removeValue(String string) {
        if (this._isInvalid() && !this._timingOut) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException(_res.getProp("session.MMapSession.msg_namevalueNull"));
        }
        Object v = this._values.remove(string);
        if (v instanceof HttpSessionBindingListener) {
            --this._numObjectsToBeUnbound;
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)v;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public void removeAttribute(String string) {
        this.removeValue(string);
    }

    public void invalidate() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        this._isValid = false;
        this._mgr.unlock(this._id);
        this._invalidate(this._nativeMgr, this._idBytes);
        this._mgr.deleteSession(this);
    }

    public long getCreationTime() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._creationTime * 1000L;
    }

    public long getLastAccessedTime() {
        return this._lastAccessedTime * 1000L;
    }

    public int getMaxInactiveInterval() {
        int n = (int)this._maxInactiveInterval;
        if (n == Integer.MAX_VALUE) {
            n = -1;
        }
        return n;
    }

    public void setMaxInactiveInterval(int n) {
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        this._maxInactiveInterval = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        String[] stringArray = null;
        Hashtable hashtable = this._values;
        synchronized (hashtable) {
            stringArray = new String[this._values.size()];
            int n = 0;
            Enumeration enumeration = this._values.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n] = (String)enumeration.nextElement();
                ++n;
            }
        }
        return stringArray;
    }

    public Enumeration getAttributeNames() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._values.keys();
    }

    private void unbindObject(String string, Object object) {
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
            --this._numObjectsToBeUnbound;
        }
    }

    protected synchronized void removeAllObjects() {
        if (this._values == null) {
            return;
        }
        if (this._numObjectsToBeUnbound > 0) {
            Enumeration enumeration = this._values.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this._values.get(string);
                if (v == null) continue;
                try {
                    this.unbindObject(string, v);
                }
                catch (Exception exception) {
                    LogUtil.logWarning(_res.getProp("session.IWSHttpSession.msg_UnbindError", string, (Object)LogUtil.getStackTrace(exception)));
                }
                if (this._numObjectsToBeUnbound != 0) continue;
            }
        }
        this._values.clear();
        this._values = null;
        this.fireSessionEvent("destroySession", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadSessionData() throws IllegalStateException {
        Object object;
        block25: {
            object = null;
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectInputStream objectInputStream = null;
            byte[] byArray = this._loadSessionData(this._nativeMgr, this._idBytes, this._location);
            if (byArray != null && byArray.length > 0) {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                if (this._context != null) {
                    ClassLoader classLoader = (ClassLoader)this._context.getAttribute("com.iplanet.server.http.servlet.classloader");
                    objectInputStream = new IWSHttpSessionInputStream(byteArrayInputStream, classLoader);
                } else {
                    objectInputStream = new ObjectInputStream(byteArrayInputStream);
                }
                object = objectInputStream.readObject();
                Object var7_7 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                        objectInputStream = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                    break block25;
                }
                catch (IOException iOException) {}
                break block25;
                {
                    catch (Exception exception) {
                        object = null;
                        LogUtil.logWarning(_res.getProp("session.MMapSession.msg_unable2Retrieve", exception));
                        Object var7_8 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                                objectInputStream = null;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            if (byteArrayInputStream != null) {
                                byteArrayInputStream.close();
                                byteArrayInputStream = null;
                            }
                            break block25;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                            objectInputStream = null;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                            byteArrayInputStream = null;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (this._isValid) {
            if (this._values != null) {
                this._values.clear();
            }
            this._newSession = false;
            this._inUse = true;
            this._values = object != null ? (Hashtable)object : new Hashtable();
        } else {
            LogUtil.TRACE(5, "loadSessionData: failed to load " + this._id);
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveSessionData() throws Exception {
        Exception exception;
        byte[] byArray;
        block21: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            byArray = null;
            exception = null;
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this._values);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            Object var7_5 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                    objectOutputStream = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
                break block21;
            }
            catch (IOException iOException) {}
            break block21;
            {
                catch (Exception exception2) {
                    exception = exception2;
                    Object var7_6 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                            objectOutputStream = null;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (byteArrayOutputStream != null) {
                            byteArrayOutputStream.close();
                            byteArrayOutputStream = null;
                        }
                        break block21;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                        objectOutputStream = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                        byteArrayOutputStream = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (byArray != null && !this._saveSessionData(this._nativeMgr, this._idBytes, byArray, this._location, this._maxInactiveInterval, this._prevReqEndTime)) {
            exception = new IOException("_saveSessionData");
        }
        if (exception != null) {
            LogUtil.logWarning(_res.getProp("session.MMapSession.msg_unable2Store", exception));
            throw exception;
        }
        this._inUse = false;
    }

    public final ServletContext getServletContext() {
        return this._context;
    }

    public final boolean isInUse() {
        return this._inUse;
    }

    public final long getLocation() {
        return this._location;
    }

    public void access() {
        this._mgr.unlock(this._id);
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void expire() {
        if (this._expiring || !this._isValid) {
            return;
        }
        this._expiring = true;
        this._isValid = false;
        Enumeration enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            this.removeAttribute((String)enumeration.nextElement());
        }
        this._mgr.deleteSession(this);
        this._expiring = false;
    }

    private native byte[] _loadSessionData(long var1, byte[] var3, long var4);

    private native boolean _saveSessionData(long var1, byte[] var3, byte[] var4, long var5, long var7, long var9);

    private native long _createSession(long var1, byte[] var3, int var4);

    private native long _getSession(long var1, byte[] var3);

    private native boolean _invalidate(long var1, byte[] var3);
}

