/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.session;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;

public abstract class IWS60SessionBase
implements HttpSession,
Session,
Serializable {
    private static final String info = "IWS60SessionBase/1.0";
    protected String authType = null;
    protected Manager manager = null;
    protected Principal principal = null;
    protected ArrayList listeners = new ArrayList();
    protected transient HashMap notes = new HashMap();
    protected long _prevReqEndTime = 0L;
    protected long _currentAccessTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSessionEvent(String string, Object object) {
        if (this.listeners.size() < 1) {
            return;
        }
        SessionEvent sessionEvent = new SessionEvent(this, string, object);
        SessionListener[] sessionListenerArray = new SessionListener[this.listeners.size()];
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            sessionListenerArray = this.listeners.toArray(sessionListenerArray);
        }
        for (int i = 0; i < sessionListenerArray.length; ++i) {
            sessionListenerArray[i].sessionEvent(sessionEvent);
        }
    }

    public String getInfo() {
        return info;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String string) {
        this.authType = string;
    }

    public void setCreationTime(long l) {
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public HttpSession getSession() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(SessionListener sessionListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(sessionListener);
        }
    }

    public void setNew(boolean bl) {
    }

    public void setValid(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNote(String string) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getNoteNames() {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.keySet().iterator();
        }
    }

    public void recycle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(String string) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(SessionListener sessionListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(sessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String string, Object object) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.put(string, object);
        }
    }

    public abstract void setId(String var1);

    public abstract boolean isValid();

    public void access() {
        this._currentAccessTime = System.currentTimeMillis();
    }

    public abstract void expire();

    public void markReqEndTime() {
        this._prevReqEndTime = System.currentTimeMillis() / 1000L;
    }
}

