/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.servlets;

import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;
import java.util.Enumeration;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.naming.resources.Resource;

public class DefaultServlet
extends HttpServlet {
    protected String[] welcomes = new String[0];
    protected static final String RESOURCES_JNDI_NAME = "java:/comp/Resources";
    protected static BitSet safeCharacters;
    protected static final char[] hexadecimal;

    public void destroy() {
    }

    public void init() throws ServletException {
        this.welcomes = (String[])this.getServletContext().getAttribute("org.apache.catalina.WELCOME_FILES");
        if (this.welcomes == null) {
            this.welcomes = new String[0];
        }
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        DirContext dirContext = this.getResources();
        ResourceInfo resourceInfo = new ResourceInfo(string, dirContext);
        if (resourceInfo.exists && resourceInfo.collection) {
            if (!httpServletRequest.getRequestURI().endsWith("/")) {
                String string2 = httpServletRequest.getRequestURI() + "/";
                string2 = this.appendParameters(httpServletRequest, string2);
                httpServletResponse.sendRedirect(string2);
                return;
            }
            ResourceInfo resourceInfo2 = this.checkWelcomeFiles(string, dirContext);
            if (resourceInfo2 != null) {
                String string3 = resourceInfo2.path;
                String string4 = httpServletRequest.getContextPath();
                if (string4 != null && !string4.equals("/")) {
                    string3 = string4 + string3;
                }
                string3 = this.appendParameters(httpServletRequest, string3);
                httpServletResponse.sendRedirect(string3);
                return;
            }
        }
        NSAPIConnector.dispatch(httpServletRequest, httpServletResponse);
    }

    protected DirContext getResources() {
        DirContext dirContext = null;
        try {
            dirContext = (DirContext)this.getServletContext().getAttribute("org.apache.catalina.resources");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (dirContext != null) {
            return dirContext;
        }
        try {
            dirContext = (DirContext)new InitialContext().lookup(RESOURCES_JNDI_NAME);
        }
        catch (NamingException namingException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return dirContext;
    }

    protected String rewriteUrl(String string) {
        int n = 10;
        int n2 = 32;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (safeCharacters.get(c)) {
                stringBuffer.append(c);
                continue;
            }
            try {
                outputStreamWriter.write(c);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                byte by = byArray[j];
                stringBuffer.append('%');
                int n3 = by & 0xF;
                int n4 = (by & 0xF0) >> 4;
                stringBuffer.append(hexadecimal[n4]);
                stringBuffer.append(hexadecimal[n3]);
            }
            byteArrayOutputStream.reset();
        }
        return stringBuffer.toString();
    }

    protected String getRelativePath(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
            String string = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            if (string == null) {
                string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            }
            if (string == null || string.equals("")) {
                string = "/";
            }
            return string;
        }
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        if (string == null || string.equals("")) {
            string = "/";
        }
        return this.normalize(string);
    }

    protected String normalize(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        if (string2.equals("/.")) {
            return "/";
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }

    private ResourceInfo checkWelcomeFiles(String string, DirContext dirContext) {
        String string2 = string;
        if (!string.endsWith("/")) {
            string2 = string2 + "/";
        }
        for (int i = 0; i < this.welcomes.length; ++i) {
            String string3 = string2 + this.welcomes[i];
            ResourceInfo resourceInfo = new ResourceInfo(string3, dirContext);
            if (!resourceInfo.exists()) continue;
            return resourceInfo;
        }
        return null;
    }

    protected String appendParameters(HttpServletRequest httpServletRequest, String string) {
        StringBuffer stringBuffer = new StringBuffer(this.rewriteUrl(string));
        Enumeration enumeration = httpServletRequest.getParameterNames();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append("?");
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(this.rewriteUrl(string2));
                stringBuffer.append("=");
                stringBuffer.append(this.rewriteUrl(stringArray[i]));
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append("&");
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append("&");
        }
        return stringBuffer.toString();
    }

    static {
        int n;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            safeCharacters.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            safeCharacters.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            safeCharacters.set(n);
        }
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(42);
        safeCharacters.set(47);
    }

    protected class ResourceInfo {
        public Object object;
        public DirContext directory;
        public Resource file;
        public Attributes attributes;
        public String path;
        public boolean collection;
        public boolean exists;
        public DirContext resources;

        public ResourceInfo(String string, DirContext dirContext) {
            this.set(string, dirContext);
        }

        public void recycle() {
            this.object = null;
            this.directory = null;
            this.file = null;
            this.attributes = null;
            this.path = null;
            this.collection = true;
            this.exists = false;
            this.resources = null;
        }

        public void set(String string, DirContext dirContext) {
            this.recycle();
            this.path = string;
            this.resources = dirContext;
            this.exists = true;
            try {
                this.object = dirContext.lookup(string);
                if (this.object instanceof Resource) {
                    this.file = (Resource)this.object;
                    this.collection = false;
                } else if (this.object instanceof DirContext) {
                    this.directory = (DirContext)this.object;
                    this.collection = true;
                } else {
                    this.exists = false;
                }
            }
            catch (NamingException namingException) {
                this.exists = false;
            }
            if (this.exists) {
                try {
                    this.attributes = dirContext.getAttributes(string);
                }
                catch (NamingException namingException) {
                    this.exists = false;
                }
            }
        }

        public boolean exists() {
            return this.exists;
        }
    }
}

