/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.J2EERunner;
import com.iplanet.ias.tools.common.dd.EjbRef;
import com.iplanet.ias.tools.common.dd.ResourceEnvRef;
import com.iplanet.ias.tools.common.dd.ResourceRef;
import com.iplanet.ias.tools.common.dd.webapp.LocaleCharsetInfo;
import com.iplanet.ias.tools.common.dd.webapp.LocaleCharsetMap;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.web.NSAPIApplicationContext;
import com.iplanet.ias.web.StatsSource;
import com.iplanet.ias.web.VirtualServer;
import com.iplanet.ias.web.session.SessionCookieConfig;
import com.iplanet.ias.web.util.LocaleCharsetMapper;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import com.sun.web.resource.ResourceManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.session.ManagerBase;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;

public final class WebModule
extends StandardContext
implements StatsSource {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private String _id = null;
    private SessionCookieConfig _cookieConfig = null;
    protected static final String info = "com.iplanet.ias.web.WebModule/1.0";
    SunWebApp iasBean = null;
    VirtualServer _vs = null;
    private LocaleCharsetMap[] _lcMap = null;
    private String _formHintField = null;
    private String _defaultCharset = null;
    private String namingContextName = null;
    private boolean statsEnabled = false;
    private boolean _isSystemDefaultContext = false;
    private boolean _encodeCookies = true;
    private boolean _useResponseCTforHeaders = false;

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            if (this._isSystemDefaultContext) {
                this.context = new NSAPIApplicationContext(this, this._vs);
            } else {
                return super.getServletContext();
            }
        }
        return this.context;
    }

    public void setAsSystemDefaultContext() {
        this._isSystemDefaultContext = true;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this._cookieConfig;
    }

    public void setSessionCookieConfig(SessionCookieConfig sessionCookieConfig) {
        this._cookieConfig = sessionCookieConfig;
    }

    public void setIasWebAppConfigBean(SunWebApp sunWebApp) {
        this.iasBean = sunWebApp;
    }

    public SunWebApp getIasWebAppConfigBean() {
        return this.iasBean;
    }

    public void setVirtualServer(VirtualServer virtualServer) {
        this._vs = virtualServer;
    }

    public void setI18nInfo() {
        if (this.iasBean != null) {
            if (this.iasBean.isParameterEncoding()) {
                this._formHintField = this.iasBean.getAttributeValue("ParameterEncoding", "FormHintField");
                this._defaultCharset = this.iasBean.getAttributeValue("ParameterEncoding", "DefaultCharset");
            }
            LocaleCharsetInfo localeCharsetInfo = this.iasBean.getLocaleCharsetInfo();
            if (this._formHintField == null && localeCharsetInfo != null && localeCharsetInfo.isParameterEncoding()) {
                this._formHintField = localeCharsetInfo.getAttributeValue("ParameterEncoding", "FormHintField");
                _logger.log(Level.WARNING, "webmodule.localeCharsetInfoWarning");
            }
            if (localeCharsetInfo != null) {
                this._lcMap = localeCharsetInfo.getLocaleCharsetMap();
            }
        }
    }

    public String getFormHintField() {
        return this._formHintField;
    }

    public String getDefaultCharset() {
        return this._defaultCharset;
    }

    public synchronized void start() throws LifecycleException {
        LocaleCharsetMapper localeCharsetMapper = new LocaleCharsetMapper(this._lcMap);
        this.setCharsetMapper(localeCharsetMapper);
        super.start();
    }

    public synchronized void reload() {
        J2EERunner.requestReconfiguration();
    }

    public void setEncodeCookies(boolean bl) {
        this._encodeCookies = bl;
    }

    public boolean getEncodeCookies() {
        return this._encodeCookies;
    }

    public void setUseResponseCTforHeaders(boolean bl) {
        this._useResponseCTforHeaders = bl;
    }

    public boolean getUseResponseCTforHeaders() {
        return this._useResponseCTforHeaders;
    }

    public synchronized void stop() throws LifecycleException {
        if (this.isUseNaming() && this.started && this.iasBean != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
            ApplicationServer.getServerContext().getResourceManager().removeWebAppBinding();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        super.stop();
    }

    protected void createNamingContext() throws NamingException {
        super.createNamingContext();
        this.bindGlobalResourceRefs();
    }

    private void bindGlobalResourceRefs() throws NamingException {
        if (this.iasBean == null) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
        Context context = ContextBindings.getClassLoader();
        Context context2 = (Context)context.lookup("comp/env");
        ContextAccessController.setWritable(this.getNamingContextName(), this);
        this.bindResources(context2);
        this.bindEjbs(context2);
        ContextAccessController.setReadOnly(this.getNamingContextName());
        ApplicationServer.getServerContext().getResourceManager().setWebAppBinding(this);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private void bindResources(Context context) throws NamingException {
        ResourceRef[] resourceRefArray = this.iasBean.getResourceRef();
        for (int i = 0; i < resourceRefArray.length; ++i) {
            ContextResource contextResource;
            if (resourceRefArray[i].getDefaultResourcePrincipal() != null) {
                _logger.log(Level.WARNING, "webmodule.deprecated_default_resource_principal");
            }
            if ((contextResource = this.findResource(resourceRefArray[i].getResRefName())) == null) {
                String string = Utility.getLocalizedString(_logger, "resource.name_does_not_exist_in_web_xml", new String[]{resourceRefArray[i].getResRefName(), this.getName()});
                throw new NamingException(string);
            }
            if (contextResource.getType().equals("java.net.URL")) {
                try {
                    URL uRL = new URL(resourceRefArray[i].getJndiName());
                    context.rebind(resourceRefArray[i].getResRefName(), (Object)uRL);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    String string = Utility.getLocalizedString(_logger, "resource.url.malformed_url_error", new String[]{resourceRefArray[i].getResRefName(), resourceRefArray[i].getJndiName()});
                    throw new NamingException(string);
                }
            }
            this.verifyResType(contextResource.getType(), resourceRefArray[i].getJndiName(), contextResource.getName());
            this.createAndBindReference(context, contextResource.getType(), resourceRefArray[i].getResRefName(), resourceRefArray[i].getJndiName());
            _logger.log(Level.FINER, "resource.mapping_global_resource_to_app", new String[]{resourceRefArray[i].getResRefName(), resourceRefArray[i].getJndiName()});
        }
        String string = null;
        ResourceEnvRef[] resourceEnvRefArray = this.iasBean.getResourceEnvRef();
        for (int i = 0; i < resourceEnvRefArray.length; ++i) {
            string = this.findResourceEnvRef(resourceEnvRefArray[i].getResourceEnvRefName());
            if (string == null) {
                String string2 = Utility.getLocalizedString(_logger, "resource.name_does_not_exist_in_web_xml", new String[]{resourceEnvRefArray[i].getResourceEnvRefName(), this.getName()});
                throw new NamingException(string2);
            }
            this.verifyResType(string, resourceEnvRefArray[i].getJndiName(), resourceEnvRefArray[i].getResourceEnvRefName());
            this.createAndBindReference(context, string, resourceEnvRefArray[i].getResourceEnvRefName(), resourceEnvRefArray[i].getJndiName());
            _logger.log(Level.FINER, "resource.mapping_global_resource_to_app", new String[]{resourceEnvRefArray[i].getResourceEnvRefName(), resourceEnvRefArray[i].getJndiName()});
        }
    }

    private void bindEjbs(Context context) throws NamingException {
        EjbRef[] ejbRefArray = this.iasBean.getEjbRef();
        for (int i = 0; i < ejbRefArray.length; ++i) {
            ContextEjb contextEjb = this.findEjb(ejbRefArray[i].getEjbRefName());
            if (contextEjb == null) {
                String string = Utility.getLocalizedString(_logger, "resource.ejb.name_does_not_exist_in_web_xml", new String[]{ejbRefArray[i].getEjbRefName(), this.getName()});
                throw new NamingException(string);
            }
            this.createAndBindReference(context, contextEjb.getHome(), ejbRefArray[i].getEjbRefName(), ejbRefArray[i].getJndiName());
            _logger.log(Level.FINER, "resource.ejb.mapping_global_resource_to_app", new String[]{ejbRefArray[i].getEjbRefName(), ejbRefArray[i].getJndiName()});
        }
    }

    private void createAndBindReference(Context context, String string, String string2, String string3) throws NamingException {
        Reference reference = new Reference(string, "com.sun.web.naming.ResourceFactory", ResourceManager.RESOURCE_FACTORY_LOCATION);
        StringRefAddr stringRefAddr = new StringRefAddr("com.sun.web.resource.global_resource_jndi_name", string3);
        reference.add(stringRefAddr);
        context.rebind(string2, (Object)reference);
    }

    public String findMimeMapping(String string) {
        String string2 = super.findMimeMapping(string);
        if (string2 != null) {
            return string2;
        }
        if (this._vs != null) {
            return this._vs.findMimeMapping(string);
        }
        return null;
    }

    private void verifyResType(String string, String string2, String string3) throws NamingException {
        try {
            Object object = ApplicationServer.getServerContext().getNamingContext().lookup(string2);
            ClassLoader classLoader = this.getLoader().getClassLoader();
            Class<?> clazz = classLoader.loadClass(string);
            if (!clazz.isAssignableFrom(object.getClass())) {
                String string4 = Utility.getLocalizedString(_logger, "resource.incorrect_resource_type", new Object[]{string3, clazz, object});
                throw new NamingException(string4);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string5 = Utility.getLocalizedString(_logger, "resource.could_not_find_class_restype", new Object[]{string3, string});
            throw new NamingException(string5);
        }
    }

    public void setStatsEnabled(boolean bl) {
        this.statsEnabled = bl;
    }

    public boolean getStatsEnabled() {
        return this.statsEnabled;
    }

    public Map getStats() {
        HashMap hashMap = new HashMap();
        ManagerBase managerBase = (ManagerBase)this.getManager();
        managerBase.fillStats(hashMap);
        return hashMap;
    }
}

