/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server.logging;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.Java;
import com.iplanet.ias.config.serverbeans.Log;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.logging.BaseLogManager;
import com.iplanet.ias.server.logging.ServerFormatter;
import com.iplanet.ias.server.logging.ServerHandler;
import com.iplanet.ias.util.logging.LogLevels;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerLogManager
extends BaseLogManager {
    private static List _unInitializedServerLoggers = new ArrayList();

    public static Level getConfiguredLogLevel(String string) {
        Java java;
        Object object;
        Server server = null;
        try {
            object = ApplicationServer.getServerContext();
            if (object == null) {
                return Level.FINEST;
            }
            server = ServerBeansFactory.getServerBean(object.getConfigContext());
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "exception initializing server side logger " + configException.toString(), configException);
            return Level.FINEST;
        }
        object = LogLevels.getJavaLogLevel(Log.getDefaultLoglevel(), Level.INFO);
        Log log = server.getLog();
        if (log != null) {
            object = LogLevels.getJavaLogLevel(log.getLoglevel(), Log.getDefaultLoglevel());
        }
        if ((java = server.getJava()) != null) {
            object = LogLevels.getJavaLogLevel(java.getLoglevel(), (Level)object);
        }
        if ("javax.enterprise.system.container.web".equals(string) || "javax.enterprise.system.core.search".equals(string)) {
            object = LogLevels.getJavaLogLevel(server.getJava().getLoglevel(), (Level)object);
        } else if ("javax.enterprise.system.core.security".equals(string)) {
            object = LogLevels.getJavaLogLevel(server.getJava().getSecurity().getLoglevel(), (Level)object);
        } else if (log != null) {
            ElementProperty[] elementPropertyArray = log.getElementProperty();
            String string2 = string + ".level";
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                if (!elementPropertyArray[i].getName().equals(string2)) continue;
                try {
                    object = Level.parse(elementPropertyArray[i].getValue());
                    continue;
                }
                catch (Exception exception) {
                    _logger.warning("Logger " + elementPropertyArray[i].getName() + " has invalid level " + elementPropertyArray[i].getValue() + " " + exception);
                }
            }
        }
        return object;
    }

    public static void initializeServerLogger(final Logger logger) {
        if (ApplicationServer.getServerContext() != null) {
            _logger.log(Level.FINE, "initializeServerLogger: " + logger.getName() + " " + logger.getResourceBundleName() + " " + logger.getLevel());
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Handler[] handlerArray = logger.getHandlers();
                for (int i = 0; i < handlerArray.length; ++i) {
                    logger.removeHandler(handlerArray[i]);
                }
                logger.setUseParentHandlers(false);
                ServerHandler serverHandler = new ServerHandler();
                serverHandler.setFormatter(new ServerFormatter());
                logger.addHandler(serverHandler);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInitializeServerLoggers() {
        if (ApplicationServer.getServerContext() == null) {
            _logger.log(Level.WARNING, "Unable to reinitialize server loggers.");
            return;
        }
        List list = _unInitializedServerLoggers;
        synchronized (list) {
            Iterator iterator = _unInitializedServerLoggers.iterator();
            _logger.setLevel(ServerLogManager.getConfiguredLogLevel(_logger.getName()));
            while (iterator.hasNext()) {
                final Logger logger = (Logger)iterator.next();
                final String string = logger.getName();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        logger.setLevel(ServerLogManager.getConfiguredLogLevel(string));
                        return null;
                    }
                });
                _logger.log(Level.FINE, "reinitializeLogger: " + string + " " + logger.getResourceBundleName() + " " + logger.getLevel());
            }
            _unInitializedServerLoggers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeLogger(final Logger logger) {
        if (ApplicationServer.getServerContext() == null) {
            List list = _unInitializedServerLoggers;
            synchronized (list) {
                _unInitializedServerLoggers.add(logger);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setLevel(ServerLogManager.getConfiguredLogLevel(logger.getName()));
                return null;
            }
        });
        ServerLogManager.initializeServerLogger(logger);
    }
}

