/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server.logging;

import com.iplanet.ias.util.logging.IASLevel;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class ServerHandler
extends StreamHandler {
    private static final int LOG_WARN = 0;
    private static final int LOG_MISCONFIG = 1;
    private static final int LOG_SECURITY = 2;
    private static final int LOG_FAILURE = 3;
    private static final int LOG_CATASTROPHE = 4;
    private static final int LOG_INFORM = 5;
    private static final int LOG_VERBOSE = 6;
    private static final int LOG_FINER = 7;
    private static final int LOG_FINEST = 8;
    private static Logger _logger;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise");
        }
        return _logger;
    }

    private static native void log_error(int var0, String var1);

    public void publish(LogRecord logRecord) {
        String string = null;
        if (logRecord != null) {
            try {
                string = this.getFormatter().format(logRecord);
                Level level = logRecord.getLevel();
                ServerHandler.log_error(this.getNativeLevel(level.intValue()), string);
            }
            catch (Exception exception) {
                ServerHandler.getLogger().log(Level.WARNING, "could not publish", exception);
            }
        }
    }

    private int getNativeLevel(int n) {
        if (n >= IASLevel.FATAL.intValue()) {
            return 4;
        }
        if (n == IASLevel.ALERT.intValue()) {
            return 2;
        }
        if (n >= Level.SEVERE.intValue()) {
            return 3;
        }
        if (n >= Level.WARNING.intValue()) {
            return 0;
        }
        if (n >= Level.INFO.intValue()) {
            return 5;
        }
        if (n >= Level.FINE.intValue()) {
            return 6;
        }
        if (n >= Level.FINER.intValue()) {
            return 7;
        }
        return 8;
    }

    static {
        System.loadLibrary("j2eeplugin");
        _logger = null;
    }
}

