/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.web.resource.ResourceManager;
import java.io.File;
import javax.naming.Context;

public class ServerContextImpl
implements ServerContext {
    public final String SERVER_XML = "server.xml";
    public final String CONFIG_DIR = "config";
    private String[] cmdLineArgs;
    private String installRoot;
    private String instanceName;
    private static StringManager localStrings = StringManager.getManager("com.iplanet.ias.server");
    private static ClassLoader commonClassLoader;
    private ClassLoader lifeCycleClassLoader;
    private ConfigContext configContext;
    private Server server;
    private String serverConfigPath = null;
    private String serverConfigURL = null;
    private InstanceEnvironment instanceEnvironment = null;
    private Context namingContext = null;
    private ResourceManager resourceManager = null;

    protected void setCmdLineArgs(String[] stringArray) {
        this.cmdLineArgs = stringArray;
    }

    public String[] getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    protected void setInstallRoot(String string) {
        this.installRoot = string;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    protected void setInstanceName(String string) {
        this.instanceName = string;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getServerConfigPath() {
        if (this.serverConfigPath != null) {
            return this.serverConfigPath;
        }
        this.serverConfigPath = this.getInstallRoot() + "/" + this.getInstanceName() + "/" + "config";
        return this.serverConfigPath;
    }

    public String getConfigURL(String string) {
        String string2 = this.getServerConfigPath() + "/" + string;
        return string2;
    }

    public String getServerConfigURL() {
        if (this.serverConfigURL != null) {
            return this.serverConfigURL;
        }
        this.serverConfigURL = this.getConfigURL("server.xml");
        return this.serverConfigURL;
    }

    public Context getNamingContext() {
        return this.namingContext;
    }

    public void setNamingContext(Context context) {
        this.namingContext = context;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    private boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public Server getConfigBean() throws ConfigException {
        if (this.server != null) {
            return this.server;
        }
        if (this.configContext == null) {
            String string = localStrings.getString("serverContext.config_context_is_null");
            throw new ConfigException(string);
        }
        this.server = ServerBeansFactory.getServerBean(this.configContext);
        return this.server;
    }

    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    public void setConfigContext(ConfigContext configContext) {
        this.configContext = configContext;
    }

    public ClassLoader getCommonClassLoader() {
        return commonClassLoader;
    }

    protected void setCommonClassLoader(ClassLoader classLoader) {
        commonClassLoader = classLoader;
    }

    public ClassLoader getLifecycleParentClassLoader() {
        return this.lifeCycleClassLoader;
    }

    protected void setLifecycleParentClassLoader(ClassLoader classLoader) {
        this.lifeCycleClassLoader = classLoader;
    }

    public InstanceEnvironment getInstanceEnvironment() {
        if (this.instanceEnvironment == null) {
            this.instanceEnvironment = new InstanceEnvironment(this.installRoot, this.instanceName);
        }
        return this.instanceEnvironment;
    }

    void setInstanceEnvironment(InstanceEnvironment instanceEnvironment) {
        this.instanceEnvironment = instanceEnvironment;
    }
}

