/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.serverbeans.Security;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Auditor;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.connector.HttpRequestBase;

public class Audit
implements Auditor {
    private static boolean auditFlag;
    private static Logger logger;
    private static String strPrivateAudit;
    private static String strDenied;
    private static String strOK;
    private static String strMethodName;
    private static String strSession;
    private static Auditor[] instances;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean isActive() {
        return auditFlag;
    }

    public static Auditor[] getInstances() {
        return instances;
    }

    public static void init() {
        Object object;
        Object object2;
        Object object3;
        try {
            object3 = ApplicationServer.getServerContext().getConfigContext();
            if (!$assertionsDisabled && object3 == null) {
                throw new AssertionError();
            }
            object2 = ServerBeansFactory.getServerBean((ConfigContext)object3);
            if (!$assertionsDisabled && object2 == null) {
                throw new AssertionError();
            }
            object = ((Server)object2).getJava().getSecurity();
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            auditFlag = ((Security)object).isAudit();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "audit.badinit", exception);
        }
        if (auditFlag) {
            logger.info("audit.enabled");
        }
        object3 = logger.getResourceBundle();
        strPrivateAudit = ((ResourceBundle)object3).getString("audit.string_private_audit");
        strDenied = " " + ((ResourceBundle)object3).getString("audit.denied");
        strOK = " " + ((ResourceBundle)object3).getString("audit.ok");
        strMethodName = " " + ((ResourceBundle)object3).getString("audit.methodname");
        strSession = " " + ((ResourceBundle)object3).getString("audit.session");
        object2 = null;
        object = System.getProperty("com.iplanet.ias.security.Audit");
        if (object != null) {
            logger.finest("Instantiating debug audit class " + (String)object);
            try {
                Class<?> clazz = Class.forName((String)object);
                object2 = (Auditor)clazz.newInstance();
            }
            catch (Exception exception) {
                logger.finest("Error attempting to instantiate audit class.");
            }
        }
        if (object2 != null) {
            instances = new Auditor[2];
            Audit.instances[1] = object2;
        } else {
            instances = new Auditor[1];
        }
        Audit.instances[0] = new Audit();
    }

    public void authentication(String string, String string2, boolean bl) {
        if (!bl || !auditFlag) {
            return;
        }
        logger.log(Level.INFO, "java_security.audit_auth_accepted", string);
    }

    public void webInvocation(HttpRequest httpRequest, boolean bl) {
        if (!logger.isLoggable(Level.INFO) || !auditFlag) {
            return;
        }
        if (httpRequest == null) {
            logger.fine("Audit: No HttpRequest available.");
            return;
        }
        if (!(httpRequest instanceof HttpRequestBase)) {
            logger.fine("Audit internal error, class: " + httpRequest.getClass());
            return;
        }
        HttpRequestBase httpRequestBase = (HttpRequestBase)httpRequest;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(strPrivateAudit);
        String string = httpRequestBase.getRemoteUser();
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("(null)");
        }
        stringBuffer.append(" ");
        stringBuffer.append(httpRequestBase.getMethod());
        stringBuffer.append(" ");
        stringBuffer.append(httpRequestBase.getRequestURI());
        stringBuffer.append(strSession);
        stringBuffer.append(httpRequestBase.getRequestedSessionId());
        if (bl) {
            stringBuffer.append(strOK);
        } else {
            stringBuffer.append(strDenied);
        }
        logger.info(stringBuffer.toString());
    }

    static {
        $assertionsDisabled = !Audit.class.desiredAssertionStatus();
        auditFlag = false;
        logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        strPrivateAudit = null;
        strDenied = null;
        strOK = null;
        strMethodName = null;
        strSession = null;
        instances = null;
    }
}

