/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.loader;

import com.iplanet.ias.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderUtils {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");

    public static ClassLoader getClassLoader(File[] fileArray, File[] fileArray2, ClassLoader classLoader) throws IOException {
        URLClassLoader uRLClassLoader = null;
        URL[] uRLArray = ClassLoaderUtils.getUrls(fileArray, fileArray2);
        if (uRLArray != null) {
            uRLClassLoader = classLoader != null ? new URLClassLoader(uRLArray, classLoader) : new URLClassLoader(uRLArray);
        }
        return uRLClassLoader;
    }

    public static URL[] getUrls(File[] fileArray, File[] fileArray2) throws IOException {
        File[] fileArray3;
        File file;
        int n;
        URL[] uRLArray = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (fileArray != null) {
            for (n = 0; n < fileArray.length; ++n) {
                file = fileArray[n];
                if (!file.isDirectory() && !file.canRead()) continue;
                fileArray3 = file.toURL();
                arrayList.add(fileArray3);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Adding directory to class path:" + fileArray3.toString());
            }
        }
        if (fileArray2 != null) {
            for (n = 0; n < fileArray2.length; ++n) {
                file = fileArray2[n];
                if (!file.isDirectory() && !file.canRead()) continue;
                fileArray3 = file.listFiles();
                for (int i = 0; i < fileArray3.length; ++i) {
                    File file2 = fileArray3[i];
                    if (!FileUtils.isJar(file2) && !FileUtils.isZip(file2)) continue;
                    arrayList.add(file2.toURL());
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Adding jar to class path:" + file2.toURL());
                }
            }
        }
        if (arrayList.size() > 0) {
            uRLArray = new URL[arrayList.size()];
            uRLArray = arrayList.toArray(uRLArray);
        }
        return uRLArray;
    }

    public static List getUrlList(File[] fileArray, File[] fileArray2) throws IOException {
        File file;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fileArray != null) {
            for (n = 0; n < fileArray.length; ++n) {
                file = fileArray[n];
                if (!file.isDirectory() && !file.canRead()) continue;
                arrayList.add(file.getCanonicalPath());
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Adding directory to class path:" + file.getCanonicalPath());
            }
        }
        if (fileArray2 != null) {
            for (n = 0; n < fileArray2.length; ++n) {
                file = fileArray2[n];
                if (!file.isDirectory() && !file.canRead()) continue;
                File[] fileArray3 = file.listFiles();
                for (int i = 0; i < fileArray3.length; ++i) {
                    File file2 = fileArray3[i];
                    if (!FileUtils.isJar(file2) && !FileUtils.isZip(file2)) continue;
                    arrayList.add(file2.getCanonicalPath());
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Adding jar to class path:" + file2.getCanonicalPath());
                }
            }
        }
        return arrayList;
    }

    public static URL[] getUrlsFromClasspath(String string) {
        URL[] uRLArray;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (string == null) {
            return (URL[])arrayList.toArray();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                uRLArray = new File(stringTokenizer.nextToken());
                arrayList.add(uRLArray.toURL());
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "loader.unexpected_error_while_creating_urls", exception);
            }
        }
        if (arrayList.size() > 0) {
            uRLArray = new URL[arrayList.size()];
            uRLArray = arrayList.toArray(uRLArray);
        } else {
            uRLArray = new URL[]{};
        }
        return uRLArray;
    }

    public static void main(String[] stringArray) {
        try {
            URL[] uRLArray = ClassLoaderUtils.getUrls(new File[]{new File(stringArray[0])}, new File[]{new File(stringArray[1])});
            for (int i = 0; i < uRLArray.length; ++i) {
                System.out.println(uRLArray[i]);
            }
            URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoaderUtils.getClassLoader(new File[]{new File(stringArray[0])}, new File[]{new File(stringArray[1])}, null);
            Class<?> clazz = uRLClassLoader.loadClass(stringArray[2]);
            System.out.println("Loaded: " + clazz.getName());
            System.out.println("Loaded class has the following methods...");
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                System.out.println(methodArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

