/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.Localizer;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.ObjectAnalyzer;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Logger;

public final class InstanceEnvironment {
    private static Object lock = new Object();
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    public static final String kConfigDirName = "config";
    public static final String kBackupDirName = "conf_bk";
    public static final String kGeneratedDirName = "ClassCache";
    public static final String kModuleDirName = "web-modules";
    public static final String kConfigXMLFileName = "server.xml";
    public static final String kLibDirName = "lib";
    public static final String kLibClassesDirName = "classes";
    public static final String kSessionStoreDirName = "SessionData";
    public static final String kDocRootDirName = "docs";
    public static final String kObjectFileName = "obj.conf";
    public static final String kInitFileName = "init.conf";
    public static final String kSecurityPasswordsFileName = "password.conf";
    public static final String kRealmsKeyFileName = "keyfile";
    private String instanceRoot = null;
    private String mLogicalName = null;
    private String mInstanceDirPath = null;
    private String mConfigFilePath = null;
    private String mBackupConfigFilePath = null;
    private String mModuleRepositoryPath = null;
    private String mLibPath = null;
    private String mLibClassesPath = null;
    private String mWebModuleCompiledJspPath = null;
    private String mModuleHttpSessionStorePath = null;
    private String mDocRootPath = null;
    private String mStopCommandPath = null;
    private String mDefaultAccessLogPath = null;
    private String mObjectFilePath = null;
    private String mInitFilePath = null;
    private String mBackupObjectFilePath = null;
    private String mBackupInitFilePath = null;
    private String mSecurityPasswordsFilePath = null;
    private String mRealmsKeyFilePath = null;
    private String mBackupRealmsKeyFilePath = null;
    private String mAclFilePath = null;
    private String mBackupAclFilePath = null;
    private String kAclFilePrefix = "generated";
    private String kBackupAclFilePrefix = "genwork";
    private String kAclFileSuffix = "acl";
    private boolean mInited = false;

    public InstanceEnvironment(String string) {
        this(System.getProperty("com.sun.web.instanceRoot"), string);
    }

    public InstanceEnvironment(String string, String string2) {
        if (!StringUtils.ok(string2)) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NULL_ARG));
        }
        this.mLogicalName = string2;
        this.createInstanceDirPath(string, string2);
        boolean bl = new File(this.mInstanceDirPath).exists();
        if (!bl) {
            Object[] objectArray = new Object[]{this.mInstanceDirPath, this.mLogicalName};
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NO_INSTANCE_DIR, objectArray));
        }
        this.createConfigFilePath();
        this.createBackupConfigFilePath();
    }

    private void init() {
        if (this.mInited) {
            return;
        }
        this.createLibPath();
        this.createLibClassesPath();
        this.createWebModuleCompiledJspPath();
        this.createDocRootPath();
        this.createDefaultAccessLogPath();
        this.createObjectFilePath();
        this.createInitFilePath();
        this.createBackupObjectFilePath();
        this.createBackupInitFilePath();
        this.createSecurityPasswordsFilePath();
        this.createRealmsKeyFilePath();
        this.createBackupRealmsKeyFilePath();
        this.createAclFilePath();
        this.createBackupAclFilePath();
        this.mInited = true;
    }

    private void createInstanceDirPath(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        this.mInstanceDirPath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createConfigFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kConfigXMLFileName};
        this.mConfigFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createBackupConfigFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kBackupDirName, kConfigXMLFileName};
        this.mBackupConfigFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createLibPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kLibDirName};
        this.mLibPath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createLibClassesPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kLibDirName, kLibClassesDirName};
        this.mLibClassesPath = StringUtils.makeFilePath(stringArray, false);
    }

    private String getDefaultSessionStorePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kSessionStoreDirName};
        return StringUtils.makeFilePath(stringArray, false);
    }

    private void createWebModuleCompiledJspPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kGeneratedDirName};
        this.mWebModuleCompiledJspPath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createDocRootPath() {
        String string = System.getProperty("com.sun.web.installRoot");
        String[] stringArray = new String[]{string, kDocRootDirName};
        this.mDocRootPath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createDefaultAccessLogPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, "logs", "access"};
        this.mDefaultAccessLogPath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createObjectFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kObjectFileName};
        this.mObjectFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createInitFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kInitFileName};
        this.mInitFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createSecurityPasswordsFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kSecurityPasswordsFileName};
        this.mSecurityPasswordsFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createRealmsKeyFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kRealmsKeyFileName};
        this.mRealmsKeyFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createBackupObjectFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kBackupDirName, kObjectFileName};
        this.mBackupObjectFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createBackupInitFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kBackupDirName, kInitFileName};
        this.mBackupInitFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createAclFilePath() {
        String string = this.kAclFilePrefix + "." + this.getName() + "." + this.kAclFileSuffix;
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, string};
        this.mAclFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createBackupAclFilePath() {
        String string = this.kBackupAclFilePrefix + "." + this.getName() + "." + this.kAclFileSuffix;
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, string};
        this.mBackupAclFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    private void createBackupRealmsKeyFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kBackupDirName, kRealmsKeyFileName};
        this.mBackupRealmsKeyFilePath = StringUtils.makeFilePath(stringArray, false);
    }

    public String getName() {
        return this.mLogicalName;
    }

    public String getInstanceDirPath() {
        return this.mInstanceDirPath;
    }

    public String getConfigDirPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName};
        String string = StringUtils.makeFilePath(stringArray, false);
        return string;
    }

    public String getBackupConfigDirPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kBackupDirName};
        String string = StringUtils.makeFilePath(stringArray, false);
        return string;
    }

    public String getConfigFilePath() {
        return this.mConfigFilePath;
    }

    public String getBackupConfigFilePath() {
        return this.mBackupConfigFilePath;
    }

    public String getModuleRepositoryPath() {
        this.init();
        return this.mModuleRepositoryPath;
    }

    public String getLibPath() {
        this.init();
        return this.mLibPath;
    }

    public String getLibClassesPath() {
        this.init();
        return this.mLibClassesPath;
    }

    public String getWebModuleCompileJspPath() {
        this.init();
        return this.mWebModuleCompiledJspPath;
    }

    public String getModuleHttpSessionStorePath() {
        this.init();
        return this.mModuleHttpSessionStorePath;
    }

    public String getDocRootPath() {
        this.init();
        return this.mDocRootPath;
    }

    public String getStopCommandPath() {
        this.init();
        return this.mStopCommandPath;
    }

    public String getDefaultAccessLogPath() {
        this.init();
        return this.mDefaultAccessLogPath;
    }

    public String getInitFilePath() {
        this.init();
        return this.mInitFilePath;
    }

    public String getBackupInitFilePath() {
        this.init();
        return this.mBackupInitFilePath;
    }

    public String getSecurityPasswordsFilePath() {
        this.init();
        return this.mSecurityPasswordsFilePath;
    }

    public String getRealmsKeyFilePath() {
        this.init();
        return this.mRealmsKeyFilePath;
    }

    public String getBackupRealmsKeyFilePath() {
        this.init();
        return this.mBackupRealmsKeyFilePath;
    }

    public String getObjectFilePath() {
        this.init();
        return this.mObjectFilePath;
    }

    public String getBackupObjectFilePath() {
        this.init();
        return this.mBackupObjectFilePath;
    }

    public String verify() {
        return null;
    }

    public String toString() {
        this.init();
        return ObjectAnalyzer.toString(this);
    }
}

