/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config.serverbeans;

import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerXPathHelper {
    public static final String XPATH_SEPARATOR = "/";
    public static final String XPATH_SERVER = "/" + ServerTags.SERVER;
    public static final String XPATH_JAVA = XPATH_SERVER + "/" + ServerTags.JAVA;
    public static final String XPATH_LOG = XPATH_SERVER + "/" + ServerTags.LOG;
    public static final String XPATH_SECURITY = XPATH_JAVA + "/" + ServerTags.SECURITY;
    public static final String XPATH_SECURITY_AUTHREALM = XPATH_SECURITY + "/" + ServerTags.AUTHREALM;
    public static final String XPATH_RESOURCES = XPATH_JAVA + "/" + ServerTags.RESOURCES;
    public static final String XPATH_JDBCRESOURCE = XPATH_RESOURCES + "/" + ServerTags.JDBCRESOURCE;
    public static final String XPATH_EXTERNALJNDIRESOURCE = XPATH_RESOURCES + "/" + ServerTags.EXTERNALJNDIRESOURCE;
    public static final String XPATH_CUSTOMRESOURCE = XPATH_RESOURCES + "/" + ServerTags.CUSTOMRESOURCE;
    public static final String XPATH_JDBCCONNECTIONPOOL = XPATH_RESOURCES + "/" + ServerTags.JDBCCONNECTIONPOOL;
    public static final String XPATH_PROFILER = XPATH_JAVA + "/" + ServerTags.PROFILER;
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.config");
    private static char SEPARATOR_CHAR = (char)47;
    private static char OPENBRACKET_CHAR = (char)91;
    private static char CLOSEBRACKET_CHAR = (char)93;
    private static char ESCAPE_CHAR = (char)92;

    public static NodeList processXPath(Node node, String string) throws SAXException {
        NodeList nodeList = null;
        try {
            nodeList = XPathAPI.selectNodeList((Node)node, (String)string);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "config.select_nodelist_exception", exception);
        }
        return nodeList;
    }

    public static String getJDBCResourceIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JDBCRESOURCE, ServerTags.JNDINAME, string);
    }

    public static String getJNDIResourceIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_EXTERNALJNDIRESOURCE, ServerTags.JNDINAME, string);
    }

    public static String getCustomResourceIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_CUSTOMRESOURCE, ServerTags.JNDINAME, string);
    }

    public static String getJDBCConnectionPoolIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JDBCCONNECTIONPOOL, ServerTags.NAME, string);
    }

    public static String getLogXpath() {
        return XPATH_LOG;
    }

    public static String getSecurityXpath() {
        return XPATH_SECURITY;
    }

    public static String getSecurityAuthRealmIdXpath(String string) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_SECURITY_AUTHREALM, ServerTags.NAME, string);
    }

    public static String getJavaXpath() {
        return XPATH_JAVA;
    }

    public static String getProfilerXpath() {
        return XPATH_PROFILER;
    }

    public static String getAbsoluteIdXpathExpression(String string, String string2, String string3) {
        return XPATH_SEPARATOR + string + "[@" + string2 + "='" + string3 + "']";
    }

    public static String getLastNodeName(String string) {
        char c;
        int n = string.length() - 1;
        int n2 = -1;
        if (n >= 0 && (c = string.charAt(n)) == CLOSEBRACKET_CHAR) {
            --n;
            n = n2 = ServerXPathHelper.bypassBrackets(string, n);
        }
        while (n >= 0 && ((c = string.charAt(n)) != SEPARATOR_CHAR || ServerXPathHelper.isEscapedChar(string, n))) {
            --n;
        }
        ++n;
        if (n2 <= 0 || n2 == string.length() - 1) {
            return string.substring(n);
        }
        return string.substring(n, n2 + 1);
    }

    private static int bypassBrackets(String string, int n) {
        char c;
        while (n >= 0 && ((c = string.charAt(n)) != OPENBRACKET_CHAR || ServerXPathHelper.isEscapedChar(string, n))) {
            --n;
        }
        return n - 1;
    }

    private static boolean isEscapedChar(String string, int n) {
        if (n <= 0) {
            return false;
        }
        int n2 = 0;
        while (--n >= 0 && string.charAt(n) == ESCAPE_CHAR) {
            ++n2;
        }
        return n2 % 2 == 1;
    }
}

