/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.management.jmx.Trace;
import java.util.Vector;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class MBeanServerNotificationFilter
extends NotificationFilterSupport {
    private Vector mySelectObjNameList = new Vector();
    private Vector myDeselectObjNameList = null;
    private static String localClassName = "MBeanServerNotificationFilter";

    public MBeanServerNotificationFilter() {
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", null);
        }
        this.enableType("JMX.mbean.registered");
        this.enableType("JMX.mbean.unregistered");
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    private void debug(String string, String string2) {
        Trace.send(2, 64, localClassName, string, string2);
        Trace.send(2, 64, "", "", "\n");
    }

    public synchronized void disableAllObjectNames() {
        if (this.isTraceOn()) {
            this.trace("disableAllObjectNames: entering", null);
        }
        this.mySelectObjNameList = new Vector();
        this.myDeselectObjNameList = null;
        if (this.isTraceOn()) {
            this.trace("disableAllObjectNames: exiting", null);
        }
    }

    public synchronized void disableObjectName(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("disableObjectName: entering", objectName.toString());
        }
        if (this.mySelectObjNameList != null && this.mySelectObjNameList.size() != 0) {
            this.mySelectObjNameList.removeElement(objectName);
        }
        if (this.myDeselectObjNameList != null && !this.myDeselectObjNameList.contains(objectName)) {
            this.myDeselectObjNameList.addElement(objectName);
        }
        if (this.isTraceOn()) {
            this.trace("disableObjectName: exiting", null);
        }
    }

    public synchronized void enableAllObjectNames() {
        if (this.isTraceOn()) {
            this.trace("enableAllObjectNames: entering", null);
        }
        this.mySelectObjNameList = null;
        this.myDeselectObjNameList = new Vector();
        if (this.isTraceOn()) {
            this.trace("enableAllObjectNames: exiting", null);
        }
    }

    public synchronized void enableObjectName(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("enableObjectName: entering", objectName.toString());
        }
        if (this.myDeselectObjNameList != null && this.myDeselectObjNameList.size() != 0) {
            this.myDeselectObjNameList.removeElement(objectName);
        }
        if (this.mySelectObjNameList != null && !this.mySelectObjNameList.contains(objectName)) {
            this.mySelectObjNameList.addElement(objectName);
        }
        if (this.isTraceOn()) {
            this.trace("enableObjectName: exiting", null);
        }
    }

    public synchronized Vector getDisabledObjectNames() {
        return (Vector)this.myDeselectObjNameList.clone();
    }

    public synchronized Vector getEnabledObjectNames() {
        return (Vector)this.mySelectObjNameList.clone();
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    public synchronized boolean isNotificationEnabled(Notification notification) throws IllegalArgumentException {
        if (notification == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("isNotificationEnabled: entering", notification.toString());
        }
        String string = notification.getType();
        Vector vector = this.getEnabledTypes();
        if (!vector.contains(string)) {
            if (this.isTraceOn()) {
                this.trace("isNotificationEnabled: type not selected, exiting", null);
            }
            return false;
        }
        MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
        ObjectName objectName = mBeanServerNotification.getMBeanName();
        boolean bl = false;
        if (this.mySelectObjNameList != null) {
            if (this.mySelectObjNameList.size() == 0) {
                if (this.isTraceOn()) {
                    this.trace("isNotificationEnabled: no ObjectNames selected, exiting", null);
                }
                return false;
            }
            bl = this.mySelectObjNameList.contains(objectName);
            if (!bl) {
                if (this.isTraceOn()) {
                    this.trace("isNotificationEnabled: ObjectName not in selected list, exiting", null);
                }
                return false;
            }
        }
        if (!bl) {
            if (this.myDeselectObjNameList == null) {
                if (this.isTraceOn()) {
                    this.trace("isNotificationEnabled: ObjectName not selected and all deselectedm, exiting", null);
                }
                return false;
            }
            if (this.myDeselectObjNameList.contains(objectName)) {
                if (this.isTraceOn()) {
                    this.trace("isNotificationEnabled: ObjectName explicitly not selected, exiting", null);
                }
                return false;
            }
        }
        if (this.isTraceOn()) {
            this.trace("isNotificationEnabled: ObjectName selected, exiting", null);
        }
        return true;
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    private void trace(String string, String string2) {
        Trace.send(1, 64, localClassName, string, string2);
        Trace.send(1, 64, "", "", "\n");
    }
}

