/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.jmx;

import com.sun.management.jmx.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.RuntimeErrorException;

class MetaData {
    private Class baseClass = null;
    private Class beanClass;
    private MBeanInfo superBeanInfo;
    private Hashtable attributes = new Hashtable();
    private Hashtable operations = new Hashtable();
    private static Hashtable declaredMethodCache = new Hashtable();
    private static Hashtable MethodCache = new Hashtable();
    private Hashtable primitiveClasses = new Hashtable(8);
    private static Hashtable primitiveobjects = new Hashtable();
    private static Hashtable mbeanInfoCache = new Hashtable();
    private static Hashtable mbeanInterfaceCache = new Hashtable();

    public MetaData() {
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        primitiveobjects.put(Boolean.TYPE, MetaData.getClass("java.lang.Boolean"));
        primitiveobjects.put(Character.TYPE, MetaData.getClass("java.lang.Character"));
        primitiveobjects.put(Byte.TYPE, MetaData.getClass("java.lang.Byte"));
        primitiveobjects.put(Short.TYPE, MetaData.getClass("java.lang.Short"));
        primitiveobjects.put(Integer.TYPE, MetaData.getClass("java.lang.Integer"));
        primitiveobjects.put(Long.TYPE, MetaData.getClass("java.lang.Long"));
        primitiveobjects.put(Float.TYPE, MetaData.getClass("java.lang.Float"));
        primitiveobjects.put(Double.TYPE, MetaData.getClass("java.lang.Double"));
    }

    private MetaData(Class clazz, Class clazz2) {
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        primitiveobjects.put(Boolean.TYPE, MetaData.getClass("java.lang.Boolean"));
        primitiveobjects.put(Character.TYPE, MetaData.getClass("java.lang.Character"));
        primitiveobjects.put(Byte.TYPE, MetaData.getClass("java.lang.Byte"));
        primitiveobjects.put(Short.TYPE, MetaData.getClass("java.lang.Short"));
        primitiveobjects.put(Integer.TYPE, MetaData.getClass("java.lang.Integer"));
        primitiveobjects.put(Long.TYPE, MetaData.getClass("java.lang.Long"));
        primitiveobjects.put(Float.TYPE, MetaData.getClass("java.lang.Float"));
        primitiveobjects.put(Double.TYPE, MetaData.getClass("java.lang.Double"));
        this.beanClass = clazz;
        this.baseClass = clazz2;
    }

    Class findClassForPrim(String string) {
        return (Class)this.primitiveClasses.get(string);
    }

    Constructor findConstructor(Class clazz, Class[] classArray) {
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            return null;
        }
        return constructor;
    }

    Method findGetter(Class clazz, String string) {
        Method method = this.findMethod(clazz, "get" + string, null);
        if (method == null) {
            method = this.findMethod(clazz, "is" + string, null);
        }
        return method;
    }

    Method findMethod(Class clazz, String string) {
        Method method = null;
        try {
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length && !methodArray[n].getName().equals(string)) {
                ++n;
            }
            if (n < methodArray.length) {
                method = methodArray[n];
            }
        }
        catch (Exception exception) {}
        return method;
    }

    Method findMethod(Class clazz, String string, int n) {
        Method method = null;
        try {
            Method[] methodArray = clazz.getMethods();
            int n2 = 0;
            boolean bl = false;
            while (n2 < methodArray.length && !bl) {
                bl = methodArray[n2].getName().equals(string);
                if (bl) {
                    bl = methodArray[n2].getParameterTypes().length == n;
                }
                ++n2;
            }
            if (bl) {
                method = methodArray[n2 - 1];
            }
        }
        catch (Exception exception) {}
        return method;
    }

    Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {}
        return method;
    }

    Class findPrimForClass(Object object) {
        if (object instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (object instanceof Character) {
            return Character.TYPE;
        }
        if (object instanceof Byte) {
            return Byte.TYPE;
        }
        if (object instanceof Short) {
            return Short.TYPE;
        }
        if (object instanceof Integer) {
            return Integer.TYPE;
        }
        if (object instanceof Long) {
            return Long.TYPE;
        }
        if (object instanceof Float) {
            return Float.TYPE;
        }
        if (object instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    Method findSetter(Class clazz, String string) {
        return this.findMethod(clazz, "set" + string, 1);
    }

    Method findSetter(Class clazz, String string, Class clazz2) {
        Class<?>[] classArray;
        Method method = this.findMethod(clazz, "set" + string, 1);
        if (method != null && (classArray = method.getParameterTypes())[0].isAssignableFrom(clazz2)) {
            return method;
        }
        return null;
    }

    static String findSignature(Class clazz) {
        return clazz.getName();
    }

    static String[] findSignatures(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            stringArray[n] = MetaData.findSignature(classArray[n]);
            ++n;
        }
        return stringArray;
    }

    private static Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeErrorException(new Error("ClassNotFoundException for class named" + string));
        }
    }

    public MBeanInfo getMBeanInfo(Class clazz) throws IntrospectionException {
        MBeanInfo mBeanInfo = (MBeanInfo)mbeanInfoCache.get(clazz);
        return (MBeanInfo)mBeanInfo.clone();
    }

    public Class getMBeanInterface(Class clazz) {
        Class clazz2 = (Class)mbeanInterfaceCache.get(clazz);
        return clazz2;
    }

    private Class getMBeanToIntrospect(Class clazz) throws IntrospectionException {
        Class<?>[] classArray = null;
        Class clazz2 = clazz;
        boolean bl = false;
        Class<?> clazz3 = null;
        while (clazz2 != null) {
            classArray = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].getName().compareTo(String.valueOf(clazz2.getName()) + "MBean") == 0) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                try {
                    clazz3 = Class.forName(String.valueOf(clazz2.getName()) + "MBean");
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IntrospectionException("Interface " + clazz.getName() + "MBean not found");
                }
            }
            clazz2 = clazz2.getSuperclass();
        }
        return clazz3;
    }

    public synchronized void testCompliance(Class clazz) throws NotCompliantMBeanException {
        Class clazz2;
        MBeanInfo mBeanInfo = Introspector.testCompliance(clazz);
        if (mBeanInfo != null && mbeanInfoCache.get(clazz) == null) {
            mbeanInfoCache.put(clazz, mBeanInfo);
        }
        if ((clazz2 = Introspector.getMBeanInterface(clazz)) != null && mbeanInterfaceCache.get(clazz) == null) {
            mbeanInterfaceCache.put(clazz, clazz2);
        }
    }
}

