/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.util;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.Aclfile;
import com.iplanet.ias.config.serverbeans.Ls;
import com.iplanet.ias.config.serverbeans.Mime;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.config.serverbeans.Vs;
import com.iplanet.ias.config.serverbeans.Vsclass;
import java.util.HashMap;

public class XmlIdValidator {
    private ConfigContext _ctx = null;
    private HashMap _ids = new HashMap();

    public XmlIdValidator(String string) throws ConfigException {
        this._ctx = ConfigFactory.createConfigContext((String)string, (boolean)true, (boolean)false, (boolean)false);
        this.init();
    }

    public XmlIdValidator(ConfigContext configContext) throws ConfigException {
        this._ctx = configContext;
        this.init();
    }

    private void init() throws ConfigException {
        Server server = ServerBeansFactory.getServerBean((ConfigContext)this._ctx);
        if (server != null) {
            this.getLSids(server);
            this.getMIMEids(server);
            this.getACLFILEids(server);
            this.getVSCLASSids(server);
        }
    }

    private void getLSids(Server server) {
        Ls[] lsArray = server.getLs();
        if (lsArray == null) {
            return;
        }
        for (int i = 0; i < lsArray.length; ++i) {
            this._ids.put(lsArray[i].getId(), "ListenSocket");
        }
    }

    private void getMIMEids(Server server) {
        Mime[] mimeArray = server.getMime();
        if (mimeArray == null) {
            return;
        }
        for (int i = 0; i < mimeArray.length; ++i) {
            this._ids.put(mimeArray[i].getId(), "MIME");
        }
    }

    private void getACLFILEids(Server server) {
        Aclfile[] aclfileArray = server.getAclfile();
        if (aclfileArray == null) {
            return;
        }
        for (int i = 0; i < aclfileArray.length; ++i) {
            this._ids.put(aclfileArray[i].getId(), "ACLFILE");
        }
    }

    private void getVSCLASSids(Server server) {
        Vsclass[] vsclassArray = server.getVsclass();
        if (vsclassArray == null) {
            return;
        }
        for (int i = 0; i < vsclassArray.length; ++i) {
            this._ids.put(vsclassArray[i].getId(), "VSCLASS");
            this.getVSids(vsclassArray[i]);
        }
    }

    private void getVSids(Vsclass vsclass) {
        Vs[] vsArray = vsclass.getVs();
        if (vsArray == null) {
            return;
        }
        for (int i = 0; i < vsArray.length; ++i) {
            this._ids.put(vsArray[i].getId(), "VS");
        }
    }

    public boolean isUnique(String string) {
        return this._ids.get(string) == null;
    }

    public String getElementNameForId(String string) {
        return (String)this._ids.get(string);
    }
}

