/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.SlashUtil;
import com.sun.web.admin.util.ValidateUtil;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.io.IOException;
import java.util.Vector;

public class VirtualServers {
    private XmlNodeWrapper wrapperXmlNode_ = null;
    private String serverRoot_ = null;
    private String instanceName_ = null;
    private String serverXml_ = null;
    private String[] covslist = null;
    private String[] enabledvslist = null;
    private String[] qos_maxbps = null;
    private String[] qos_bw = null;
    private String[] qos_maxconn = null;
    private String[] qos_cnx = null;
    private String[] cgiuserlist = null;
    private String[] cgigrouplist = null;
    private String[] cgichrootlist = null;
    private String[] cginicelist = null;
    private String[] cgidirlist = null;

    public void init(String string, String string2) throws Exception {
        this.serverRoot_ = string.trim();
        this.instanceName_ = string2.trim();
        XmlNode xmlNode = AdminConfig.getInstance(this.serverRoot_, this.instanceName_);
        this.wrapperXmlNode_ = new XmlNodeWrapper(xmlNode);
        this.serverXml_ = this.serverRoot_ + "/" + this.instanceName_ + "/" + "conf_bk" + "/" + "server.xml";
        XmlNode[] xmlNodeArray = this.wrapperXmlNode_.getAllVSClassNodes();
        int n = xmlNodeArray.length;
        this.covslist = new String[n];
        this.cgiuserlist = new String[n];
        this.cgigrouplist = new String[n];
        this.cgichrootlist = new String[n];
        this.cginicelist = new String[n];
        this.cgidirlist = new String[n];
        this.qos_maxbps = new String[n];
        this.qos_bw = new String[n];
        this.qos_maxconn = new String[n];
        this.qos_cnx = new String[n];
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            XmlNode xmlNode2 = this.wrapperXmlNode_.getQOSNode(xmlNodeArray[i]);
            if (xmlNode2 != null) {
                this.qos_maxbps[i] = xmlNode2.getString("maxbps", "");
                this.qos_bw[i] = xmlNode2.getString("enforcebandwidth", "off");
                this.qos_maxconn[i] = xmlNode2.getString("maxconn", "");
                this.qos_cnx[i] = xmlNode2.getString("enforceconnections", "off");
            } else {
                this.qos_bw[i] = "off";
                this.qos_cnx[i] = "off";
            }
            this.covslist[i] = xmlNodeArray[i].getString("id", "null");
            this.cgiuserlist[i] = xmlNodeArray[i].getString("user", null);
            this.cgigrouplist[i] = xmlNodeArray[i].getString("group", null);
            this.cgichrootlist[i] = xmlNodeArray[i].getString("chroot", null);
            this.cginicelist[i] = xmlNodeArray[i].getString("nice", null);
            this.cgidirlist[i] = xmlNodeArray[i].getString("dir", null);
            XmlNode[] xmlNodeArray2 = this.wrapperXmlNode_.getAllVSNodes(xmlNodeArray[i]);
            if (xmlNodeArray2 == null) continue;
            for (int j = 0; j < xmlNodeArray2.length; ++j) {
                String string3 = xmlNodeArray2[j].getString("id", "null").trim();
                String string4 = xmlNodeArray2[j].getString("state", "null").trim();
                if (!ValidateUtil.isTrue(string4)) continue;
                vector.add(string3);
            }
        }
        this.enabledvslist = vector.toArray(new String[vector.size()]);
    }

    public boolean removeVS(String string, String string2) {
        XmlNode xmlNode;
        XmlNode xmlNode2;
        XmlNode xmlNode3 = this.wrapperXmlNode_.getServerRootNode();
        if (xmlNode3 != null && (xmlNode2 = this.wrapperXmlNode_.getClassNode(string)) != null && (xmlNode = this.wrapperXmlNode_.getVSNode(string, string2)) != null) {
            xmlNode2.removeChild(xmlNode);
        }
        return true;
    }

    public boolean editAttributes(String string, String string2, String string3, String string4, String string5) {
        XmlNode xmlNode;
        XmlNode xmlNode2;
        XmlNode xmlNode3 = this.wrapperXmlNode_.getServerRootNode();
        if (xmlNode3 != null && (xmlNode2 = this.wrapperXmlNode_.getClassNode(string)) != null && (xmlNode = this.wrapperXmlNode_.getVSNode(string, string2)) != null) {
            if (string3 != null) {
                this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "state", string3);
            } else {
                this.wrapperXmlNode_.removeAttribute(xmlNode, "state");
            }
            if (string4 != null && !string4.trim().equals("")) {
                this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "connections", string4);
            } else {
                this.wrapperXmlNode_.removeAttribute(xmlNode, "connections");
            }
            if (string5 != null && !string5.trim().equals("")) {
                this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "urlhosts", string5);
            } else {
                this.wrapperXmlNode_.removeAttribute(xmlNode, "urlhosts");
            }
        }
        return true;
    }

    public boolean setAccessLog(String string, String string2) {
        XmlNode xmlNode = this.wrapperXmlNode_.getServerRootNode();
        if (xmlNode != null) {
            String string3 = this.wrapperXmlNode_.getPropertyValue(xmlNode, "accesslog");
            XmlNode xmlNode2 = this.wrapperXmlNode_.getVSNode(string);
            if (xmlNode2 != null) {
                if (string2 == null) {
                    return false;
                }
                if (string2 != null && string2.equals("")) {
                    this.wrapperXmlNode_.removeProperty(xmlNode2, "accesslog");
                } else {
                    this.wrapperXmlNode_.setProperty(xmlNode2, "accesslog", string2);
                }
            }
        }
        return true;
    }

    public boolean resetAccessLog(String string) {
        String string2 = SlashUtil.de_slashes(this.serverRoot_) + "/" + this.instanceName_ + "/config/server.xml";
        XmlNode xmlNode = null;
        try {
            xmlNode = new XmlConfig(string2).parseConfig();
        }
        catch (Exception exception) {
            return false;
        }
        XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode);
        String string3 = xmlNodeWrapper.getParentClassName(string);
        if (string3 == null) {
            return false;
        }
        XmlNode xmlNode2 = xmlNodeWrapper.getVSNode(string3, string);
        if (xmlNode2 != null) {
            String string4 = xmlNodeWrapper.getPropertyValue(xmlNode2, "accesslog");
            XmlNode xmlNode3 = this.wrapperXmlNode_.getVSNode(string);
            if (string4 == null || string4.equals("")) {
                this.wrapperXmlNode_.removeProperty(xmlNode3, "accesslog");
            } else {
                this.wrapperXmlNode_.setProperty(xmlNode3, "accesslog", string4);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean resetErrorLog(String string) {
        String string2 = SlashUtil.de_slashes(this.serverRoot_) + "/" + this.instanceName_ + "/config/server.xml";
        XmlNode xmlNode = null;
        try {
            xmlNode = new XmlConfig(string2).parseConfig();
        }
        catch (Exception exception) {
            return false;
        }
        XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode);
        String string3 = xmlNodeWrapper.getParentClassName(string);
        if (string3 == null) {
            return false;
        }
        XmlNode xmlNode2 = xmlNodeWrapper.getVSNode(string3, string);
        if (xmlNode2 != null) {
            String string4 = xmlNodeWrapper.getPropertyValue(xmlNode2, "errorlog");
            XmlNode xmlNode3 = this.wrapperXmlNode_.getVSNode(string);
            if (string4 == null || string4.equals("")) {
                xmlNode3.removeChild("errorlog");
            } else {
                this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode3, "errorlog", string4);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setErrorLog(String string, String string2) {
        XmlNode xmlNode = this.wrapperXmlNode_.getServerRootNode();
        if (xmlNode != null) {
            String string3 = this.wrapperXmlNode_.getPropertyValue(xmlNode, "errorlog");
            XmlNode xmlNode2 = this.wrapperXmlNode_.getVSNode(string);
            if (xmlNode2 != null) {
                if (string2 == null) {
                    return false;
                }
                if (string2 != null && string2.equals("")) {
                    xmlNode2.removeChild("errorlog");
                } else {
                    this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode2, "errorlog", string2);
                }
            }
        }
        return true;
    }

    public boolean setCgiVars(String string, String string2, String string3, String string4, String string5, String string6) {
        XmlNode xmlNode = this.wrapperXmlNode_.getVSNode(string);
        if (xmlNode != null) {
            if (string2 != null && !string2.equals("")) {
                this.wrapperXmlNode_.setProperty(xmlNode, "user", string2);
            } else {
                this.wrapperXmlNode_.removeProperty(xmlNode, "user");
            }
            if (string3 != null && !string3.equals("")) {
                this.wrapperXmlNode_.setProperty(xmlNode, "group", string3);
            } else {
                this.wrapperXmlNode_.removeProperty(xmlNode, "group");
            }
            if (string4 != null && !string4.equals("")) {
                this.wrapperXmlNode_.setProperty(xmlNode, "chroot", string4);
            } else {
                this.wrapperXmlNode_.removeProperty(xmlNode, "chroot");
            }
            if (string5 != null && !string5.equals("")) {
                this.wrapperXmlNode_.setProperty(xmlNode, "nice", string5);
            } else {
                this.wrapperXmlNode_.removeProperty(xmlNode, "nice");
            }
            if (string6 != null && !string6.equals("")) {
                this.wrapperXmlNode_.setProperty(xmlNode, "dir", string6);
            } else {
                this.wrapperXmlNode_.removeProperty(xmlNode, "dir");
            }
        }
        return true;
    }

    public boolean saveXMLConfiguration() throws IOException {
        XmlNode xmlNode = null;
        if (this.wrapperXmlNode_ != null) {
            xmlNode = this.wrapperXmlNode_.getServerRootNode();
        }
        AdminConfig.writeXmlToFile(xmlNode, this.serverRoot_, this.serverXml_);
        return true;
    }

    public boolean setDocroot(String string, String string2) {
        XmlNode xmlNode = this.wrapperXmlNode_.getVSNode(string);
        if (xmlNode != null) {
            this.wrapperXmlNode_.setProperty(xmlNode, "docroot", string2);
        }
        return true;
    }

    public boolean removeDocroot(String string) {
        XmlNode xmlNode = this.wrapperXmlNode_.getVSNode(string);
        if (xmlNode != null) {
            this.wrapperXmlNode_.removeProperty(xmlNode, "docroot");
        }
        return true;
    }

    public boolean setQOSParams(String string, String string2, String string3, String string4, String string5) {
        XmlNode xmlNode = null;
        XmlNode xmlNode2 = this.wrapperXmlNode_.getVSNode(string);
        if (xmlNode2 != null) {
            xmlNode = this.wrapperXmlNode_.getQOSNode(xmlNode2);
            if (xmlNode == null) {
                xmlNode = this.wrapperXmlNode_.createElement(xmlNode2, "QOSPARAMS");
            }
            if (xmlNode != null) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "maxbps", string2);
                } else {
                    this.wrapperXmlNode_.removeAttribute(xmlNode, "maxbps");
                }
                if (string3 != null) {
                    this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "enforcebandwidth", string3);
                }
                if (string4 != null && string4.trim().length() > 0) {
                    this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "maxconn", string4);
                } else {
                    this.wrapperXmlNode_.removeAttribute(xmlNode, "maxconn");
                }
                if (string5 != null) {
                    this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "enforceconnections", string5);
                }
                return true;
            }
        }
        return false;
    }

    public boolean removeQOSParams(String string) {
        XmlNode xmlNode = this.wrapperXmlNode_.getVSNode(string);
        this.wrapperXmlNode_.removeElement(xmlNode, "QOSPARAMS");
        return true;
    }

    public boolean setState(String string, String string2) {
        XmlNode xmlNode = this.wrapperXmlNode_.getVSNode(string);
        if (xmlNode != null && string2 != null) {
            this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "state", string2);
        }
        return true;
    }

    public boolean setMime(String string, String string2) {
        XmlNode xmlNode = this.wrapperXmlNode_.getVSNode(string);
        if (xmlNode != null && string2 != null) {
            this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "mime", string2);
        }
        return true;
    }
}

