/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.XmlNode;
import java.io.IOException;

public class SecurityService {
    private XmlNodeWrapper wrapperXmlNode_ = null;
    private String serverRoot_ = null;
    private String instanceName_ = null;
    private String serverXml_ = null;
    private XmlNode securityNode_ = null;

    public void init(String string, String string2) throws Exception {
        this.serverRoot_ = string.trim();
        this.instanceName_ = string2.trim();
        XmlNode xmlNode = AdminConfig.getInstance(this.serverRoot_, this.instanceName_);
        this.wrapperXmlNode_ = new XmlNodeWrapper(xmlNode);
        this.securityNode_ = this.wrapperXmlNode_.getSecurityNode();
        this.serverXml_ = this.serverRoot_ + "/" + this.instanceName_ + "/" + "conf_bk" + "/" + "server.xml";
    }

    public boolean exists() {
        return this.securityNode_ != null;
    }

    public String getDefaultRealm() {
        return this.securityNode_.getString("defaultrealm", "file");
    }

    public void setDefaultRealm(String string) {
        this.securityNode_.setAttribute("defaultrealm", string);
    }

    public String getAnonymousRole() {
        return this.securityNode_.getString("anonymousrole", "ANYONE");
    }

    public void setAnonymousRole(String string) {
        this.securityNode_.setAttribute("anonymousrole", string);
    }

    public boolean isAuditEnabled() {
        String string = this.securityNode_.getString("audit", "false");
        return string.equals("true");
    }

    public void enableAudit() {
        this.securityNode_.setAttribute("audit", "true");
    }

    public void disableAudit() {
        this.securityNode_.setAttribute("audit", "false");
    }

    public String getLogLevel() {
        return this.securityNode_.getString("loglevel", "");
    }

    public void setLogLevel(String string) {
        if (string == null || string.length() < 1) {
            this.securityNode_.removeChild("loglevel");
        } else {
            this.securityNode_.setAttribute("loglevel", string);
        }
    }

    public boolean saveXMLConfiguration() throws IOException {
        XmlNode xmlNode = null;
        if (this.wrapperXmlNode_ != null) {
            xmlNode = this.wrapperXmlNode_.getServerRootNode();
        }
        AdminConfig.writeXmlToFile(xmlNode, this.serverRoot_, this.serverXml_);
        return true;
    }
}

